/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandBuscarEntidadePrincipal;
import br.com.elotech.portalarrecadacao.command.CommandCarregaParametrosEntidade;
import br.com.elotech.portalarrecadacao.command.CommandCarregarEntidade;
import br.com.elotech.portalarrecadacao.command.CommandValidarRegistroSistema;
import br.com.elotech.portalarrecadacao.command.CommandVerificaIntegradoGeo;
import br.com.elotech.portalarrecadacao.command.CommandVerificaIntegradoISSFacil;
import br.com.elotech.tributacao.command.CommandGetValorParamGeral;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.ParametroEntidadeExercicioEntity;
import java.util.List;

public abstract class FacadeEntidade
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregarEntidade getCommandCarregarEntidade();

    protected abstract CommandVerificaIntegradoGeo getCommandVerificaIntegradoGeo();

    protected abstract CommandCarregaParametrosEntidade getCommandCarregaParametrosEntidade();

    protected abstract CommandVerificaIntegradoISSFacil getCommandVerificaIntegracaoIssFacil();

    protected abstract CommandGetValorParamGeral getCommandGetValorParametroGeral();

    protected abstract CommandValidarRegistroSistema getCommandValidarRegistroSistema();

    protected abstract CommandBuscarEntidadePrincipal getCommandBuscarEntidadePrincipal();

    public EntidadeTributacaoEntity getEntidade() throws BaseException {
        CommandCarregarEntidade command = this.getCommandCarregarEntidade();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getEntidade();
    }

    public Boolean verificaIntegradoGeo() throws BaseException {
        CommandVerificaIntegradoGeo command = this.getCommandVerificaIntegradoGeo();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getIntegradoGeo();
    }

    public List<ParametroEntidadeExercicioEntity> carregaParametros(Long entidade, Long exercicio) throws BaseException {
        CommandCarregaParametrosEntidade command = this.getCommandCarregaParametrosEntidade();
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getParametros();
    }

    public Boolean verificaIntegradoLoginExterno() throws BaseException {
        CommandVerificaIntegradoISSFacil command = this.getCommandVerificaIntegracaoIssFacil();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getIntegradoLoginExterno();
    }

    public String getParametroGeralPorModulo(String modulo, String parametro) throws BaseException {
        CommandGetValorParamGeral command = this.getCommandGetValorParametroGeral();
        command.setModulo(modulo);
        command.setParametro(parametro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValor();
    }

    public boolean isRegistroSistemaValido(EntidadeTributacaoEntity entidade, String modulo) throws BaseException {
        CommandValidarRegistroSistema command = this.getCommandValidarRegistroSistema();
        command.setEntidade(entidade);
        command.setModulo(modulo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.isValido();
    }

    public EntidadeAiseEntity buscarEntidadePrincipal() throws BaseException {
        CommandBuscarEntidadePrincipal command = this.getCommandBuscarEntidadePrincipal();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEntidadePrincipal();
    }
}

