/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCidadesByUF;
import br.com.elotech.portalarrecadacao.command.CommandCarregarTiposLogradouro;
import br.com.elotech.portalarrecadacao.command.CommandSalvarBairro;
import br.com.elotech.portalarrecadacao.command.CommandSalvarLogradouro;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoLogradouroEntity;
import java.util.List;

public abstract class FacadeEndereco
extends Facade {
    private static final long serialVersionUID = 2901319003600939661L;

    protected abstract CommandCarregaCidadesByUF getCommandCarregaCidadesByUF();

    protected abstract CommandCarregarTiposLogradouro getCommandCarregarTiposLogradouro();

    protected abstract CommandSalvarBairro getCommandSalvarBairro();

    protected abstract CommandSalvarLogradouro getCommandSalvarLogradouro();

    public List<CidadeEntity> getCidadesByUF(String query, String uf) throws BaseException {
        CommandCarregaCidadesByUF command = this.getCommandCarregaCidadesByUF();
        command.setDescricao(query);
        command.setUF(uf);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCidades();
    }

    public List<TipoLogradouroEntity> carregarTiposLogradouro() throws BaseException {
        CommandCarregarTiposLogradouro command = this.getCommandCarregarTiposLogradouro();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTiposLogradouro();
    }

    public BairroEntity salvarBairro(BairroEntity bairro) throws BaseException {
        CommandSalvarBairro command = this.getCommandSalvarBairro();
        command.setBairro(bairro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getBairro();
    }

    public LogradouroEntity salvarLogradouro(LogradouroEntity logradouro) throws BaseException {
        CommandSalvarLogradouro command = this.getCommandSalvarLogradouro();
        command.setLogradouro(logradouro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getLogradouro();
    }
}

