/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAdicionarDocumentoSefaz;
import br.com.elotech.portalarrecadacao.command.CommandBuscarTiposDocumento;
import br.com.elotech.portalarrecadacao.command.CommandCarregaDocumentoPorAtividadeOuTipoInscricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaTiposDocumentoPorTipoInscricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarTipoDocumentoPorId;
import br.com.elotech.portalarrecadacao.command.CommandCarregarTiposDocumentoPorAtividades;
import br.com.elotech.portalarrecadacao.command.CommandGetUltimoDocumentoEmitido;
import br.com.elotech.portalarrecadacao.command.CommandImprimirDocumento;
import br.com.elotech.portalarrecadacao.command.CommandImprimirDocumentoEloArquivo;
import br.com.elotech.portalarrecadacao.command.CommandPossuiDocumentoParaAtividade;
import br.com.elotech.portalarrecadacao.command.CommandRemoverDocumentoSefaz;
import br.com.elotech.portalarrecadacao.command.CommandSalvarDocumentoEloArquivo;
import br.com.elotech.portalarrecadacao.command.CommandValidaDocObrigatorioPorAtividade;
import br.com.elotech.portalarrecadacao.command.CommandVerificaPatrimonioPublicoMunicipalByImobiliario;
import br.com.elotech.portalarrecadacao.domain.ArquivoDocumentoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.DocumentoAtividadeTipoInscricaoVo;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocTipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import java.util.List;

public abstract class FacadeDocumento
extends Facade {
    private static final long serialVersionUID = 850392308075798196L;

    protected abstract CommandBuscarTiposDocumento getCommandBuscarTiposDocumento();

    protected abstract CommandVerificaPatrimonioPublicoMunicipalByImobiliario getCommandVerificaPatrimonioPublicoMunicipalByImobiliario();

    protected abstract CommandCarregaTiposDocumentoPorTipoInscricao getCommandCarregaTiposDocumentoPorTipoInscricao();

    protected abstract CommandImprimirDocumento getCommandImprimirDocumento();

    protected abstract CommandCarregarTiposDocumentoPorAtividades getCommandCarregarTiposDocumentoPorAtividades();

    protected abstract CommandCarregarTipoDocumentoPorId getCommandCarregarTipoDocumentoPorId();

    protected abstract CommandCarregaDocumentoPorAtividadeOuTipoInscricao getCommandCarregaDocumentoPorAtividadeOuTipoInscricao();

    protected abstract CommandPossuiDocumentoParaAtividade getCommandPossuiDocumentoParaAtividade();

    protected abstract CommandValidaDocObrigatorioPorAtividade getCommandValidaDocObrigatorioPorAtividade();

    protected abstract CommandAdicionarDocumentoSefaz getCommandAdicionarDocumentoSefaz();

    protected abstract CommandRemoverDocumentoSefaz getCommandRemoverDocumentoSefaz();

    protected abstract CommandSalvarDocumentoEloArquivo getCommandSalvarDocumentoEloArquivo();

    protected abstract CommandGetUltimoDocumentoEmitido getCommandGetUltimoDocumentoEmitido();

    protected abstract CommandImprimirDocumentoEloArquivo getCommandImprimirDocumentoEloArquivo();

    public boolean verificaPatrimonioPublicoByImobiliario(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        CommandVerificaPatrimonioPublicoMunicipalByImobiliario command = this.getCommandVerificaPatrimonioPublicoMunicipalByImobiliario();
        command.setCadastroImobiliario(cadastroImobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getPatrimonioPublico();
    }

    public List<TipoDocumentoEntity> buscarTiposDocumento() throws BaseException {
        CommandBuscarTiposDocumento command = this.getCommandBuscarTiposDocumento();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getTiposDocumento();
    }

    public List<TipoDocTipoInscricaoAlvaraEntity> carregaTiposDocumentoPorTipoInscricao(TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        CommandCarregaTiposDocumentoPorTipoInscricao command = this.getCommandCarregaTiposDocumentoPorTipoInscricao();
        command.setTipoInscricao(tipoInscricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTiposDocumento();
    }

    public void imprimirDocumento(CadastroGeralAisePK cadastroGeralPK, Long idTipoDocumento) throws BaseException {
        CommandImprimirDocumento command = this.getCommandImprimirDocumento();
        command.setCadastroGeralPK(cadastroGeralPK);
        command.setTipoDocumento(idTipoDocumento);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public List<ConfiguracaoAtividadeDocumentoEntity> carregaTiposDocumentoPorAtividades(List<SolicitacaoAlvaraAtividadeEntity> atividades) throws BaseException {
        CommandCarregarTiposDocumentoPorAtividades command = this.getCommandCarregarTiposDocumentoPorAtividades();
        command.setAtividades(atividades);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTiposDocumento();
    }

    public TipoDocumentoEntity carregarTipoDocumentoPorId(Long idTipoDocumento) throws BaseException {
        CommandCarregarTipoDocumentoPorId command = this.getCommandCarregarTipoDocumentoPorId();
        command.setId(idTipoDocumento);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTipoDocumento();
    }

    public List<DocumentoAtividadeTipoInscricaoVo> carregarDocumentoPorAtividadeOuTipoInscricao(SolicitacaoAlvaraEntity solicitacao, TipoConfiguracaoAtividadeDocEnum tipo) throws BaseException {
        CommandCarregaDocumentoPorAtividadeOuTipoInscricao command = this.getCommandCarregaDocumentoPorAtividadeOuTipoInscricao();
        command.setSolicitacaoAlvara(solicitacao);
        command.setTipoDocumento(tipo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDocumentos();
    }

    public boolean possuiDocumentoParaAtividade(SolicitacaoAlvaraEntity solicitacao, TipoConfiguracaoAtividadeDocEnum tipo) throws BaseException {
        CommandPossuiDocumentoParaAtividade command = this.getCommandPossuiDocumentoParaAtividade();
        command.setSolicitacao(solicitacao);
        command.setTipoConfiguracaoAtividadeDocEnum(tipo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiDocumento();
    }

    public void validarDocObrigatorioPorAtividade(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraDocumentoEntity> documentos) throws BaseException {
        CommandValidaDocObrigatorioPorAtividade command = this.getCommandValidaDocObrigatorioPorAtividade();
        command.setDocumentos(documentos);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void adicionarDocumentoSefaz(SefazDocumentoEntity documentoSefaz) throws BaseException {
        CommandAdicionarDocumentoSefaz command = this.getCommandAdicionarDocumentoSefaz();
        command.setDocumentoSefaz(documentoSefaz);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void removerDocumentoSefaz(SefazDocumentoEntity documentoSefaz) throws BaseException {
        CommandRemoverDocumentoSefaz command = this.getCommandRemoverDocumentoSefaz();
        command.setDocumentoSefaz(documentoSefaz);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void salvarDocumentoEloArquivo(byte[] documento, SolicitacaoAlvaraEntity solicitacao, DocumentoAiseEntity documentoAise) throws BaseException {
        CommandSalvarDocumentoEloArquivo command = this.getCommandSalvarDocumentoEloArquivo();
        command.setDocumento(documento);
        command.setSolicitacao(solicitacao);
        command.setDocumentoAise(documentoAise);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public DocumentoAiseEntity buscarUltimoDocumentoEmitidoDoCadastro(CadastroGeralAisePK id, Long idTipoDocumento) throws BaseException {
        CommandGetUltimoDocumentoEmitido command = this.getCommandGetUltimoDocumentoEmitido();
        command.setCadastroGeral(id);
        command.setTipoDocumento(idTipoDocumento);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDocumento();
    }

    public ArquivoDocumentoAlvaraEntity imprimirDocumentoEloArquivo(Long id) throws BaseException {
        CommandImprimirDocumentoEloArquivo command = this.getCommandImprimirDocumentoEloArquivo();
        command.setIdArquivoDocumento(id);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getArquivoDocumentoAlvara();
    }
}

