/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandBuscaEnderecoImobiliarioPrincipal;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCadastroImobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCadastroImobiliarioPorCodigoOuInscricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaImagemImobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaImobiliarioSegmentoPorCadastroImobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaLogradouros;
import br.com.elotech.portalarrecadacao.command.CommandRecuperarTestadaCadastroGeral;
import br.com.elotech.portalarrecadacao.command.CommandRestricaoAlvaraIsencaoImobiliario;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.VisualizarLoteEnvio;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioSegmentoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import java.util.List;

public abstract class FacadeCadastroImobiliario
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaCadastroImobiliario getCommandCarregaCadastroImobiliario();

    protected abstract CommandCarregaLogradouros getCommandCarregaLogradouros();

    protected abstract CommandBuscaEnderecoImobiliarioPrincipal getCommandBuscaEnderecoImobiliarioPrincipal();

    protected abstract CommandCarregaImagemImobiliario getCommandCarregaImagemImobiliario();

    protected abstract CommandRestricaoAlvaraIsencaoImobiliario getCommandRestricaoAlvaraIsencaoImobiliario();

    protected abstract CommandCarregaImobiliarioSegmentoPorCadastroImobiliario getCommandCarregaImobiliarioSegmentoPorCadastroImobiliairo();

    protected abstract CommandRecuperarTestadaCadastroGeral getCommandRecuperarTestadaCadastroGeral();

    protected abstract CommandCarregaCadastroImobiliarioPorCodigoOuInscricao getCommandCarregaCadastroImobiliarioPorCodigoOuInscricao();

    public CadastroImobiliarioEntity getCadastroImobiliarioPorCodigo(Long tipoCadastro, Long cadastroGeral) throws BaseException {
        CommandCarregaCadastroImobiliario command = this.getCommandCarregaCadastroImobiliario();
        command.setTipoCadastro(tipoCadastro);
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCadastroImobiliario();
    }

    public List<EnderecoCadastroAlvaraEntity> getCadastroImobiliarioPorEndereco(String descricao) throws BaseException {
        CommandCarregaLogradouros command = this.getCommandCarregaLogradouros();
        command.setDescricao(descricao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getEnderecos();
    }

    public EnderecoCadastroGeralEntity getBuscaEnderecoImobiliarioPrincipal(Long codigo) throws BaseException {
        CommandBuscaEnderecoImobiliarioPrincipal command = this.getCommandBuscaEnderecoImobiliarioPrincipal();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getBuscaEnderecoImobiliarioPrincipal();
    }

    public byte[] carregarImagemImobiliarioPorWS(VisualizarLoteEnvio envio) throws BaseException {
        CommandCarregaImagemImobiliario command = this.getCommandCarregaImagemImobiliario();
        command.setVisualizarLoteEnvio(envio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.retornarImagemImobiliario();
    }

    public boolean verificaRestricaoIsencaoImobiliario(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        CommandRestricaoAlvaraIsencaoImobiliario command = this.getCommandRestricaoAlvaraIsencaoImobiliario();
        command.setCadastroImobiliario(cadastroImobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRestricao();
    }

    public List<CadastroImobiliarioSegmentoEntity> carregaSegmentoPorCadastroImobiliario(CadastroGeralAiseEntity cadastroGeral) throws BaseException {
        CommandCarregaImobiliarioSegmentoPorCadastroImobiliario command = this.getCommandCarregaImobiliarioSegmentoPorCadastroImobiliairo();
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getImobiliarioSegmento();
    }

    public CadastroImobiliarioTestadaEntity recuperarTestada(CadastroGeralAiseEntity cadastroGeral) throws BaseException {
        CommandRecuperarTestadaCadastroGeral command = this.getCommandRecuperarTestadaCadastroGeral();
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCadastroImobiliarioTestadaEntity();
    }

    public List<CadastroImobiliarioEntity> getCadastroImobiliarioPorCodigoOuInscricaoCadastral(String codigo) throws BaseException {
        CommandCarregaCadastroImobiliarioPorCodigoOuInscricao command = this.getCommandCarregaCadastroImobiliarioPorCodigoOuInscricao();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCadastroImobiliario();
    }
}

