/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.enumerator;

import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public enum GrauDeRiscoEnum {
    RISCO_ALTO("C", "Risco Alto", Integer.valueOf(1)),
    RISCO_BAIXO("B", "Risco Baixo", Integer.valueOf(2)),
    RISCO_LIBERDADE_ECONOMICA("A", "Liberdade Econ\u00f4mica", Integer.valueOf(3));

    final String sigla;
    final String descricao;
    final Integer indice;

    private GrauDeRiscoEnum(String sigla, String descricao, Integer indice) {
        this.sigla = sigla;
        this.descricao = descricao;
        this.indice = indice;
    }

    public String getSigla() {
        return this.sigla;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Integer getIndice() {
        return this.indice;
    }

    public static boolean isGrauRiscoBaixo(String grauRisco) {
        return RISCO_BAIXO.getSigla().equals(grauRisco);
    }

    public static boolean isGrauRiscoAlto(String grauRisco) {
        return RISCO_ALTO.getSigla().equals(grauRisco);
    }

    public static boolean isGrauRiscoLiberdadeEconomica(String grauRisco) {
        return RISCO_LIBERDADE_ECONOMICA.getSigla().equals(grauRisco);
    }

    public static String getTextoFromSigla(String sigla) {
        for (GrauDeRiscoEnum grauDeRiscoEnum : GrauDeRiscoEnum.values()) {
            if (!grauDeRiscoEnum.getSigla().equals(sigla)) continue;
            return grauDeRiscoEnum.getDescricao();
        }
        return "";
    }

    public static GrauDeRiscoEnum fromString(String sigla) {
        if (Objects.nonNull(sigla)) {
            for (GrauDeRiscoEnum grauRisco : GrauDeRiscoEnum.values()) {
                if (!sigla.equalsIgnoreCase(grauRisco.sigla)) continue;
                return grauRisco;
            }
        }
        return null;
    }

    public static GrauDeRiscoEnum fromIndice(Integer indice) {
        if (Objects.nonNull(indice)) {
            for (GrauDeRiscoEnum grauRisco : GrauDeRiscoEnum.values()) {
                if (indice.compareTo(grauRisco.indice) != 0) continue;
                return grauRisco;
            }
        }
        return null;
    }
}

