/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dto.webiss;

import br.com.elotech.portalarrecadacao.dto.webiss.QualificacaoSocioWebIss;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Socios;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Qualificacoes;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.ResponsavelLegal;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocioWebIssDTO {
    @JsonProperty(value="Qualificacao")
    private Integer qualificacao;
    @JsonProperty(value="Nome")
    private String nome;
    @JsonProperty(value="Documento")
    private String documento;
    @JsonProperty(value="DataEntrada")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dataEntrada;
    @JsonProperty(value="Participacao")
    private BigDecimal participacao;
    @JsonProperty(value="RepresentanteLegal")
    private Boolean representanteLegal;

    public static List<SocioWebIssDTO> from(CadastroMobiliarioEntity cadastroMobiliarioEntity, String arquivoDadosEmpresa, List<String> cpfCnpjRepresentantesCadastroMobiliario) throws SolicitacaoAlvaraRedeSimException {
        SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO = PortalUtils.normalizeJson((String)arquivoDadosEmpresa);
        Map<String, List<Socios>> sociosRedeSimPorCnpjCpf = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getSocios().stream().collect(Collectors.groupingBy(Socios::getNu_cpf_cnpj));
        ResponsavelLegal responsavelLegalVox = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getResponsavel_legal();
        List<SocioWebIssDTO> result = cadastroMobiliarioEntity.getSocios().stream().map(a -> SocioWebIssDTO.from((ContratoSocialPessoaEntity)a, (Socios)((List)sociosRedeSimPorCnpjCpf.get(a.getId().getPessoa().getCnpjCpf())).stream().findAny().orElse(null), (List)cpfCnpjRepresentantesCadastroMobiliario, (CadastroMobiliarioEntity)cadastroMobiliarioEntity, (ResponsavelLegal)responsavelLegalVox)).collect(Collectors.toList());
        Boolean possuiAlgumSocioRepresentanteLegal = result.stream().anyMatch(SocioWebIssDTO::getRepresentanteLegal);
        if (Boolean.FALSE.equals(possuiAlgumSocioRepresentanteLegal) && !result.isEmpty()) {
            result.get(0).setRepresentanteLegal(Boolean.valueOf(true));
        }
        return result;
    }

    private static SocioWebIssDTO from(ContratoSocialPessoaEntity contratoSocialPessoaEntity, Socios socioRedeSim, List<String> cpfCnpjRepresentantesCadastroMobiliario, CadastroMobiliarioEntity cadastroMobiliarioEntity, ResponsavelLegal responsavelLegalVox) {
        Qualificacoes qualificacaoRedeSim = socioRedeSim.getQualificacoes().stream().findAny().orElse(null);
        QualificacaoSocioWebIss qualificacaoWebIss = QualificacaoSocioWebIss.findByCodigoRFB((Integer)qualificacaoRedeSim.getCo_tipo_qualificacao_rfb());
        SocioWebIssDTO dto = new SocioWebIssDTO();
        dto.setDataEntrada(Optional.ofNullable(contratoSocialPessoaEntity.getId().getContratoSocial()).map(ContratoSocialEntity::getDataRegistroJuntaComercial).orElse(cadastroMobiliarioEntity.getDataAbertura()));
        dto.setNome(contratoSocialPessoaEntity.getId().getPessoa().getNome());
        dto.setDocumento(contratoSocialPessoaEntity.getId().getPessoa().getCnpjCpf());
        dto.setParticipacao(contratoSocialPessoaEntity.getPercentualCapital());
        if (Objects.nonNull(responsavelLegalVox) && responsavelLegalVox.getNu_cpf().equals(dto.getDocumento())) {
            dto.setRepresentanteLegal(Boolean.valueOf(true));
        } else {
            dto.setRepresentanteLegal(Boolean.valueOf(cpfCnpjRepresentantesCadastroMobiliario.contains(dto.getDocumento())));
        }
        if (Objects.nonNull(qualificacaoWebIss)) {
            dto.setQualificacao(qualificacaoWebIss.getCodigo());
        }
        return dto;
    }

    public Integer getQualificacao() {
        return this.qualificacao;
    }

    public String getNome() {
        return this.nome;
    }

    public String getDocumento() {
        return this.documento;
    }

    public Date getDataEntrada() {
        return this.dataEntrada;
    }

    public BigDecimal getParticipacao() {
        return this.participacao;
    }

    public Boolean getRepresentanteLegal() {
        return this.representanteLegal;
    }

    public void setQualificacao(Integer qualificacao) {
        this.qualificacao = qualificacao;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public void setDataEntrada(Date dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    public void setParticipacao(BigDecimal participacao) {
        this.participacao = participacao;
    }

    public void setRepresentanteLegal(Boolean representanteLegal) {
        this.representanteLegal = representanteLegal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SocioWebIssDTO)) {
            return false;
        }
        SocioWebIssDTO other = (SocioWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$qualificacao = this.getQualificacao();
        Integer other$qualificacao = other.getQualificacao();
        if (this$qualificacao == null ? other$qualificacao != null : !((Object)this$qualificacao).equals(other$qualificacao)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$documento = this.getDocumento();
        String other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        Date this$dataEntrada = this.getDataEntrada();
        Date other$dataEntrada = other.getDataEntrada();
        if (this$dataEntrada == null ? other$dataEntrada != null : !((Object)this$dataEntrada).equals(other$dataEntrada)) {
            return false;
        }
        BigDecimal this$participacao = this.getParticipacao();
        BigDecimal other$participacao = other.getParticipacao();
        if (this$participacao == null ? other$participacao != null : !((Object)this$participacao).equals(other$participacao)) {
            return false;
        }
        Boolean this$representanteLegal = this.getRepresentanteLegal();
        Boolean other$representanteLegal = other.getRepresentanteLegal();
        return !(this$representanteLegal == null ? other$representanteLegal != null : !((Object)this$representanteLegal).equals(other$representanteLegal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SocioWebIssDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $qualificacao = this.getQualificacao();
        result = result * 59 + ($qualificacao == null ? 43 : ((Object)$qualificacao).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        Date $dataEntrada = this.getDataEntrada();
        result = result * 59 + ($dataEntrada == null ? 43 : ((Object)$dataEntrada).hashCode());
        BigDecimal $participacao = this.getParticipacao();
        result = result * 59 + ($participacao == null ? 43 : ((Object)$participacao).hashCode());
        Boolean $representanteLegal = this.getRepresentanteLegal();
        result = result * 59 + ($representanteLegal == null ? 43 : ((Object)$representanteLegal).hashCode());
        return result;
    }

    public String toString() {
        return "SocioWebIssDTO(qualificacao=" + this.getQualificacao() + ", nome=" + this.getNome() + ", documento=" + this.getDocumento() + ", dataEntrada=" + this.getDataEntrada() + ", participacao=" + this.getParticipacao() + ", representanteLegal=" + this.getRepresentanteLegal() + ")";
    }
}

