/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dto.webiss;

import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Optional;

public class CnaeWebIssDTO {
    @JsonProperty(value="Codigo")
    private String codigo;
    @JsonProperty(value="DataInclusao")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dataInclusao;
    @JsonProperty(value="IndicaPrincipal")
    private Boolean principal;

    public static CnaeWebIssDTO from(MobiliarioCnaeEntity mobiliarioCnaeEntity, CadastroMobiliarioEntity cadastroMobiliarioEntity) {
        CnaeWebIssDTO dto = new CnaeWebIssDTO();
        dto.setCodigo(mobiliarioCnaeEntity.getId().getCnae().getCodigo());
        dto.setDataInclusao(Optional.ofNullable(mobiliarioCnaeEntity.getDataInicio()).orElse(cadastroMobiliarioEntity.getDataAbertura()));
        dto.setPrincipal(SimNaoEnum.equalSim((String)mobiliarioCnaeEntity.getCnaePrincipal()));
        return dto;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CnaeWebIssDTO)) {
            return false;
        }
        CnaeWebIssDTO other = (CnaeWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        Date this$dataInclusao = this.getDataInclusao();
        Date other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        Boolean this$principal = this.getPrincipal();
        Boolean other$principal = other.getPrincipal();
        return !(this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CnaeWebIssDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        Date $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        Boolean $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        return result;
    }

    public String toString() {
        return "CnaeWebIssDTO(codigo=" + this.getCodigo() + ", dataInclusao=" + this.getDataInclusao() + ", principal=" + this.getPrincipal() + ")";
    }
}

