/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dto.solicitacaoalvara;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import java.util.Objects;
import java.util.Optional;

public class SolicitacaoAlvaraObservacaoDTO {
    private String nomeRazaoSocial;
    private String nomeFantasia;
    private Long cadastroImobiliario;
    private String logradouro;
    private String numeroEndereco;
    private String naturezaJuridica;

    public static SolicitacaoAlvaraObservacaoDTO of(SolicitacaoAlvaraEntity solicitacaoAlvaraEntity) {
        if (Objects.isNull(solicitacaoAlvaraEntity)) {
            return null;
        }
        SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoDTO = new SolicitacaoAlvaraObservacaoDTO();
        CadastroGeralAiseEntity cadastroGeral = Optional.ofNullable(solicitacaoAlvaraEntity.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getCadastroGeral).orElse(null);
        if (Objects.nonNull(cadastroGeral)) {
            if (Objects.nonNull(cadastroGeral.getPessoa())) {
                solicitacaoAlvaraObservacaoDTO.setNomeRazaoSocial(cadastroGeral.getPessoa().getNome());
                solicitacaoAlvaraObservacaoDTO.setNomeFantasia(cadastroGeral.getPessoa().getNomeFantasia());
            }
            if (Objects.nonNull(cadastroGeral.getLogradouro())) {
                solicitacaoAlvaraObservacaoDTO.setLogradouro(cadastroGeral.getLogradouro().getTipoDescricao());
            }
            solicitacaoAlvaraObservacaoDTO.setNumeroEndereco(cadastroGeral.getNumero());
        }
        solicitacaoAlvaraObservacaoDTO.setCadastroImobiliario((Long)Optional.ofNullable(solicitacaoAlvaraEntity.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getCadastroImobiliario).map(CadastroImobiliarioEntity::getId).map(CadastroGeralAisePK::getCodigo).orElse(null));
        solicitacaoAlvaraObservacaoDTO.setNaturezaJuridica((String)Optional.ofNullable(solicitacaoAlvaraEntity.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getNaturezaJuridica).map(NaturezaJuridicaEntity::getIdNaturezaJuridica).map(Objects::toString).orElse(null));
        return solicitacaoAlvaraObservacaoDTO;
    }

    public String getNomeRazaoSocial() {
        return this.nomeRazaoSocial;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public Long getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getNumeroEndereco() {
        return this.numeroEndereco;
    }

    public String getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    public void setNomeRazaoSocial(String nomeRazaoSocial) {
        this.nomeRazaoSocial = nomeRazaoSocial;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public void setCadastroImobiliario(Long cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public void setNumeroEndereco(String numeroEndereco) {
        this.numeroEndereco = numeroEndereco;
    }

    public void setNaturezaJuridica(String naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoAlvaraObservacaoDTO)) {
            return false;
        }
        SolicitacaoAlvaraObservacaoDTO other = (SolicitacaoAlvaraObservacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nomeRazaoSocial = this.getNomeRazaoSocial();
        String other$nomeRazaoSocial = other.getNomeRazaoSocial();
        if (this$nomeRazaoSocial == null ? other$nomeRazaoSocial != null : !this$nomeRazaoSocial.equals(other$nomeRazaoSocial)) {
            return false;
        }
        String this$nomeFantasia = this.getNomeFantasia();
        String other$nomeFantasia = other.getNomeFantasia();
        if (this$nomeFantasia == null ? other$nomeFantasia != null : !this$nomeFantasia.equals(other$nomeFantasia)) {
            return false;
        }
        Long this$cadastroImobiliario = this.getCadastroImobiliario();
        Long other$cadastroImobiliario = other.getCadastroImobiliario();
        if (this$cadastroImobiliario == null ? other$cadastroImobiliario != null : !((Object)this$cadastroImobiliario).equals(other$cadastroImobiliario)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numeroEndereco = this.getNumeroEndereco();
        String other$numeroEndereco = other.getNumeroEndereco();
        if (this$numeroEndereco == null ? other$numeroEndereco != null : !this$numeroEndereco.equals(other$numeroEndereco)) {
            return false;
        }
        String this$naturezaJuridica = this.getNaturezaJuridica();
        String other$naturezaJuridica = other.getNaturezaJuridica();
        return !(this$naturezaJuridica == null ? other$naturezaJuridica != null : !this$naturezaJuridica.equals(other$naturezaJuridica));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoAlvaraObservacaoDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nomeRazaoSocial = this.getNomeRazaoSocial();
        result = result * 59 + ($nomeRazaoSocial == null ? 43 : $nomeRazaoSocial.hashCode());
        String $nomeFantasia = this.getNomeFantasia();
        result = result * 59 + ($nomeFantasia == null ? 43 : $nomeFantasia.hashCode());
        Long $cadastroImobiliario = this.getCadastroImobiliario();
        result = result * 59 + ($cadastroImobiliario == null ? 43 : ((Object)$cadastroImobiliario).hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numeroEndereco = this.getNumeroEndereco();
        result = result * 59 + ($numeroEndereco == null ? 43 : $numeroEndereco.hashCode());
        String $naturezaJuridica = this.getNaturezaJuridica();
        result = result * 59 + ($naturezaJuridica == null ? 43 : $naturezaJuridica.hashCode());
        return result;
    }

    public String toString() {
        return "SolicitacaoAlvaraObservacaoDTO(nomeRazaoSocial=" + this.getNomeRazaoSocial() + ", nomeFantasia=" + this.getNomeFantasia() + ", cadastroImobiliario=" + this.getCadastroImobiliario() + ", logradouro=" + this.getLogradouro() + ", numeroEndereco=" + this.getNumeroEndereco() + ", naturezaJuridica=" + this.getNaturezaJuridica() + ")";
    }
}

