/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.vo;

import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;

public class HotelMotelVO
implements Serializable {
    private static final long serialVersionUID = -2946115189550108353L;
    public static final String CODIGO_CNAE_HOTEL = "5510801";
    public static final String CODIGO_CNAE_APARTAMENTO_HOTEL = "5510802";
    public static final String CODIGO_CNAE_MOTEL = "5510803";
    private boolean renderHotel;
    private String hotelNumeroQuarto;
    private String hotelNumeroApartamentos;
    private String hotelNumeroSuites;
    private boolean renderApartamentoHotel;
    private String apartamentoHotelNumeroQuarto;
    private String apartamentoHotelNumeroApartamentos;
    private String apartamentoHotelNumeroSuites;
    private boolean renderMotel;
    private String motelNumeroQuarto;
    private String motelNumeroApartamentos;
    private String motelNumeroSuites;

    public String getHotelNumeroQuarto() {
        return this.hotelNumeroQuarto;
    }

    public void setHotelNumeroQuarto(String hotelNumeroQuarto) {
        this.hotelNumeroQuarto = hotelNumeroQuarto;
    }

    public String getHotelNumeroApartamentos() {
        return this.hotelNumeroApartamentos;
    }

    public void setHotelNumeroApartamentos(String hotelNumeroApartamentos) {
        this.hotelNumeroApartamentos = hotelNumeroApartamentos;
    }

    public String getHotelNumeroSuites() {
        return this.hotelNumeroSuites;
    }

    public void setHotelNumeroSuites(String hotelNumeroSuites) {
        this.hotelNumeroSuites = hotelNumeroSuites;
    }

    public String getApartamentoHotelNumeroQuarto() {
        return this.apartamentoHotelNumeroQuarto;
    }

    public void setApartamentoHotelNumeroQuarto(String apartamentoHotelNumeroQuarto) {
        this.apartamentoHotelNumeroQuarto = apartamentoHotelNumeroQuarto;
    }

    public String getApartamentoHotelNumeroApartamentos() {
        return this.apartamentoHotelNumeroApartamentos;
    }

    public void setApartamentoHotelNumeroApartamentos(String apartamentoHotelNumeroApartamentos) {
        this.apartamentoHotelNumeroApartamentos = apartamentoHotelNumeroApartamentos;
    }

    public String getApartamentoHotelNumeroSuites() {
        return this.apartamentoHotelNumeroSuites;
    }

    public void setApartamentoHotelNumeroSuites(String apartamentoHotelNumeroSuites) {
        this.apartamentoHotelNumeroSuites = apartamentoHotelNumeroSuites;
    }

    public String getMotelNumeroQuarto() {
        return this.motelNumeroQuarto;
    }

    public void setMotelNumeroQuarto(String motelNumeroQuarto) {
        this.motelNumeroQuarto = motelNumeroQuarto;
    }

    public String getMotelNumeroApartamentos() {
        return this.motelNumeroApartamentos;
    }

    public void setMotelNumeroApartamentos(String motelNumeroApartamentos) {
        this.motelNumeroApartamentos = motelNumeroApartamentos;
    }

    public String getMotelNumeroSuites() {
        return this.motelNumeroSuites;
    }

    public void setMotelNumeroSuites(String motelNumeroSuites) {
        this.motelNumeroSuites = motelNumeroSuites;
    }

    public boolean isRenderHotel() {
        return this.renderHotel;
    }

    public void setRenderHotel(boolean renderHotel) {
        this.renderHotel = renderHotel;
    }

    public boolean isRenderApartamentoHotel() {
        return this.renderApartamentoHotel;
    }

    public void setRenderApartamentoHotel(boolean renderApartamentoHotel) {
        this.renderApartamentoHotel = renderApartamentoHotel;
    }

    public boolean isRenderMotel() {
        return this.renderMotel;
    }

    public void setRenderMotel(boolean renderMotel) {
        this.renderMotel = renderMotel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apartamentoHotelNumeroApartamentos == null ? 0 : this.apartamentoHotelNumeroApartamentos.hashCode());
        result = 31 * result + (this.apartamentoHotelNumeroQuarto == null ? 0 : this.apartamentoHotelNumeroQuarto.hashCode());
        result = 31 * result + (this.apartamentoHotelNumeroSuites == null ? 0 : this.apartamentoHotelNumeroSuites.hashCode());
        result = 31 * result + (this.hotelNumeroApartamentos == null ? 0 : this.hotelNumeroApartamentos.hashCode());
        result = 31 * result + (this.hotelNumeroQuarto == null ? 0 : this.hotelNumeroQuarto.hashCode());
        result = 31 * result + (this.hotelNumeroSuites == null ? 0 : this.hotelNumeroSuites.hashCode());
        result = 31 * result + (this.motelNumeroApartamentos == null ? 0 : this.motelNumeroApartamentos.hashCode());
        result = 31 * result + (this.motelNumeroQuarto == null ? 0 : this.motelNumeroQuarto.hashCode());
        result = 31 * result + (this.motelNumeroSuites == null ? 0 : this.motelNumeroSuites.hashCode());
        result = 31 * result + (this.renderApartamentoHotel ? 1231 : 1237);
        result = 31 * result + (this.renderHotel ? 1231 : 1237);
        result = 31 * result + (this.renderMotel ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HotelMotelVO other = (HotelMotelVO)obj;
        if (this.apartamentoHotelNumeroApartamentos == null ? other.apartamentoHotelNumeroApartamentos != null : !this.apartamentoHotelNumeroApartamentos.equals(other.apartamentoHotelNumeroApartamentos)) {
            return false;
        }
        if (this.apartamentoHotelNumeroQuarto == null ? other.apartamentoHotelNumeroQuarto != null : !this.apartamentoHotelNumeroQuarto.equals(other.apartamentoHotelNumeroQuarto)) {
            return false;
        }
        if (this.apartamentoHotelNumeroSuites == null ? other.apartamentoHotelNumeroSuites != null : !this.apartamentoHotelNumeroSuites.equals(other.apartamentoHotelNumeroSuites)) {
            return false;
        }
        if (this.hotelNumeroApartamentos == null ? other.hotelNumeroApartamentos != null : !this.hotelNumeroApartamentos.equals(other.hotelNumeroApartamentos)) {
            return false;
        }
        if (this.hotelNumeroQuarto == null ? other.hotelNumeroQuarto != null : !this.hotelNumeroQuarto.equals(other.hotelNumeroQuarto)) {
            return false;
        }
        if (this.hotelNumeroSuites == null ? other.hotelNumeroSuites != null : !this.hotelNumeroSuites.equals(other.hotelNumeroSuites)) {
            return false;
        }
        if (this.motelNumeroApartamentos == null ? other.motelNumeroApartamentos != null : !this.motelNumeroApartamentos.equals(other.motelNumeroApartamentos)) {
            return false;
        }
        if (this.motelNumeroQuarto == null ? other.motelNumeroQuarto != null : !this.motelNumeroQuarto.equals(other.motelNumeroQuarto)) {
            return false;
        }
        if (this.motelNumeroSuites == null ? other.motelNumeroSuites != null : !this.motelNumeroSuites.equals(other.motelNumeroSuites)) {
            return false;
        }
        if (this.renderApartamentoHotel != other.renderApartamentoHotel) {
            return false;
        }
        if (this.renderHotel != other.renderHotel) {
            return false;
        }
        return this.renderMotel == other.renderMotel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HotelMotelVO [renderHotel=");
        builder.append(this.renderHotel);
        builder.append(", hotelNumeroQuarto=");
        builder.append(this.hotelNumeroQuarto);
        builder.append(", hotelNumeroApartamentos=");
        builder.append(this.hotelNumeroApartamentos);
        builder.append(", hotelNumeroSuites=");
        builder.append(this.hotelNumeroSuites);
        builder.append(", renderApartamentoHotel=");
        builder.append(this.renderApartamentoHotel);
        builder.append(", apartamentoHotelNumeroQuarto=");
        builder.append(this.apartamentoHotelNumeroQuarto);
        builder.append(", apartamentoHotelNumeroApartamentos=");
        builder.append(this.apartamentoHotelNumeroApartamentos);
        builder.append(", apartamentoHotelNumeroSuites=");
        builder.append(this.apartamentoHotelNumeroSuites);
        builder.append(", renderMotel=");
        builder.append(this.renderMotel);
        builder.append(", motelNumeroQuarto=");
        builder.append(this.motelNumeroQuarto);
        builder.append(", motelNumeroApartamentos=");
        builder.append(this.motelNumeroApartamentos);
        builder.append(", motelNumeroSuites=");
        builder.append(this.motelNumeroSuites);
        builder.append("]");
        return builder.toString();
    }

    public boolean isInformacoesPreenchidasCorretamente() {
        boolean retorno = true;
        if (this.isRenderHotel()) {
            retorno = this.validarHoteis();
        }
        if (this.isRenderApartamentoHotel()) {
            retorno = this.validarApartamentoHotel();
        }
        if (this.isRenderMotel()) {
            retorno = this.validarMotel();
        }
        return retorno;
    }

    private boolean validarMotel() {
        if (EloStringUtils.isEmpty((String)this.motelNumeroQuarto) && EloStringUtils.isEmpty((String)this.motelNumeroApartamentos) && EloStringUtils.isEmpty((String)this.motelNumeroSuites)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"\u00c9 necess\u00e1rio informar ao menos uma das Informa\u00e7\u00f5es Adicionais para a Atividade de Mot\u00e9is.");
            return false;
        }
        return true;
    }

    private boolean validarApartamentoHotel() {
        if (EloStringUtils.isEmpty((String)this.apartamentoHotelNumeroQuarto) && EloStringUtils.isEmpty((String)this.apartamentoHotelNumeroApartamentos) && EloStringUtils.isEmpty((String)this.apartamentoHotelNumeroSuites)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"\u00c9 necess\u00e1rio informar ao menos uma das Informa\u00e7\u00f5es Adicionais para a Atividade de Apart/Hot\u00e9is.");
            return false;
        }
        return true;
    }

    private boolean validarHoteis() {
        if (EloStringUtils.isEmpty((String)this.hotelNumeroQuarto) && EloStringUtils.isEmpty((String)this.hotelNumeroApartamentos) && EloStringUtils.isEmpty((String)this.hotelNumeroSuites)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"\u00c9 necess\u00e1rio informar ao menos uma das Informa\u00e7\u00f5es Adicionais para a Atividade de Hot\u00e9is.");
            return false;
        }
        return true;
    }
}

