/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.helper;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraImpl;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;

public abstract class ValidaTaxas
extends SrvSolicitacaoAlvaraImpl {
    public void validaSolicitacaoImpressaoTaxas(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> listaLaudos, List<SolicitacaoAlvaraDocumentoEntity> documentos) throws BaseException {
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            this.verificaLaudoECorrigeDataValidadeAlvara(solicitacao);
            if (!this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro n\u00e3o \u00e9 v\u00e1lida ou existe uma data de validade sem laudos no alvar\u00e1 online.");
            }
            if (!EloListUtils.safeIsEmpty(listaLaudos).booleanValue() && solicitacao.isSituacaoMobiliarioDesatualizado() && !this.isTodosLaudosLiberados(solicitacao)) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar liberados!");
            }
        }
        if (solicitacao.isGrauRiscoAlto() && this.validaLaudoRiscoC(solicitacao) && !this.isTodosLaudosLiberados(solicitacao)) {
            throw new SolicitacaoAlvaraException("Todos os Laudos devem estar liberados!");
        }
    }
}

