/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.helper;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ValidaTaxas;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;

public class ValidaImpressao
extends ValidaTaxas {
    private static final String TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS = "Todos os Documentos devem estar validados!";

    public void validaSolicitacaoImpressaoTaxas(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> listaLaudos, List<SolicitacaoAlvaraDocumentoEntity> documentos) throws BaseException {
        super.validaSolicitacaoImpressaoTaxas(solicitacao, listaLaudos, documentos);
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL}) && !EloListUtils.safeIsEmpty(listaLaudos).booleanValue() && solicitacao.isSituacaoMobiliarioDesatualizado() && !this.isDocumentoComSituacaoValida(documentos)) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
        if (solicitacao.isGrauRiscoAlto() && this.validaDocumentoRiscoC(solicitacao) && !this.isDocumentoComSituacaoValida(documentos)) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && !this.isDocumentoComSituacaoValida(documentos)) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
    }
}

