/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.portalarrecadacao.rest.dto.StatusLaudoAlvaraDTO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum StatusLaudoAlvara {
    EM_ANDAMENTO("A", "EM ANDAMENTO"),
    LIBERADO_DEFINITIVO("LD", "LIBERADO DEFINITIVO"),
    LIBERADO_PROVISORIO("LP", "LIBERADO PROVIS\u00d3RIO"),
    NAO_LIBERADO("NL", "N\u00c3O LIBERADO"),
    EXIGENCIA("E", "EXIG\u00caNCIA"),
    ENCAMINHADO_PARA_VISTORIA("EV", "ENCAMINHADO PARA VISTORIA"),
    EM_ANALISE("AL", "EM AN\u00c1LISE"),
    NAO_CONCLUIDO("NC", "N\u00c3O CONCLU\u00cdDO"),
    RENOVAR("R", "RENOVAR"),
    CANCELADO("C", "CANCELADO"),
    INDEFERIDO("I", "INDEFERIDO"),
    LIBERDADE_ECONOMICA("LE", "LIBERADO - LIBERDADE ECON\u00d4MICA"),
    LAUDO_LIBERADO_RISCO_B("LLB", "LAUDO LIBERADO - RISCO BAIXO"),
    LOCAL_FECHADO("LF", "LOCAL FECHADO");

    private static Map<String, StatusLaudoAlvara> map;
    private final String codigo;
    private final String descricao;

    private StatusLaudoAlvara(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String toString() {
        return this.descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static StatusLaudoAlvara fromCodigo(String codigo) {
        return (StatusLaudoAlvara)map.get(codigo);
    }

    public String descricaoCapitalize() {
        return StringUtils.capitalize((String)this.descricao.toLowerCase());
    }

    public static List<StatusLaudoAlvaraDTO> getSituacoes() {
        ArrayList<StatusLaudoAlvaraDTO> situacoes = new ArrayList<StatusLaudoAlvaraDTO>();
        for (StatusLaudoAlvara status : StatusLaudoAlvara.values()) {
            situacoes.add(StatusLaudoAlvaraDTO.of((String)status.getCodigo(), (String)status.getDescricao()));
        }
        return situacoes;
    }

    public static StatusLaudoAlvara getStatusByCodigo(String codigo) {
        for (StatusLaudoAlvara status : StatusLaudoAlvara.values()) {
            if (!codigo.equals(status.getCodigo())) continue;
            return status;
        }
        return null;
    }

    static {
        map = new LinkedHashMap();
        for (StatusLaudoAlvara status : StatusLaudoAlvara.values()) {
            map.put(status.getCodigo(), status);
        }
    }
}

