/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoBaixaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.EnquadramentoEmpresaEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosConsultaPrevia;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Natureza_imovel;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Empresa;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity(name="SolicitacaoRedeSim")
@Table(name="tribSolicitacaoRedeSim")
public class SolicitacaoRedeSimEntity
implements EntityDef {
    private static final String TIPO_NATUREZA_RURAL = "1";
    @Id
    private Long id;
    private String arquivoConsulta;
    private String arquivoDadosEmpresa;
    private Date dataSolicitacao;
    private String situacao;
    private String protocolo;
    private String tipo;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="TRIBSOLICITACAOREDESIMALVARA ", joinColumns={@JoinColumn(name="solicitacaoRedeSim")}, inverseJoinColumns={@JoinColumn(name="solicitacaoAlvara")})
    private List<SolicitacaoAlvaraEntity> solicitacoesAlvara = new ArrayList();
    private String indeferido;
    private String motivoIndeferimento;
    private String resposta;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="TRIBSOLICITACAOINDEFERIMENTO", joinColumns={@JoinColumn(name="idSolicitacaoRedeSim")}, inverseJoinColumns={@JoinColumn(name="IDINDEFERIMENTO")})
    private List<IndeferimentoRedeSimEntity> indeferimentos = new ArrayList();
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="TRIBSOLICITACAOREDESIMEVENTO ", joinColumns={@JoinColumn(name="idSolicitacaoRedeSim")}, inverseJoinColumns={@JoinColumn(name="evento")})
    private List<EventoRedeSimEntity> eventos = new ArrayList();
    @OneToMany(mappedBy="solicitacaoRedeSim", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<HistoricoExigenciaRedeSimEntity> historicosExigencias = new ArrayList();
    private String observacao;
    private String invalidado;
    @Enumerated(value=EnumType.STRING)
    private TipoAlvaraEnum alvaraEnviado;
    private Long idRespostaConsulta;
    private String tipoLogradouro;
    private String endereco;
    private String numero;
    private String bairro;
    private String complemento;
    private String usuarioTramitacao;
    private Date dataTramitacao;
    private String cpfSolicitante;
    private String cnpjEmpresa;
    @OneToOne(mappedBy="solicitacaoRedeSim")
    private SolicitacaoBaixaRedeSimEntity solicitacaoBaixaRedeSim;
    @Column(nullable=false)
    @Type(type="org.hibernate.type.BooleanType")
    private boolean ativo = Boolean.TRUE;
    private String inscricaoEnviada = SimNaoEnum.getNaoShortText();
    private Long cep;
    @Transient
    private ImprimirTaxasAlvara imprimirTaxasAlvara;

    public boolean isSolicitacaoBaixa() {
        return Objects.nonNull(this.solicitacaoBaixaRedeSim);
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public String getIndeferidoDescricao() {
        return this.indeferido == null ? "" : SimNaoEnum.fromString((String)this.indeferido).toLongString();
    }

    public String getTipoDescricao() {
        return TipoSolicitacaoAlvaraEnum.fromString((String)this.tipo).toLongString();
    }

    public String getTextFromSituacao() {
        for (SituacaoConsultaPreviaRedeSimEnum situacaoEnums : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!Objects.nonNull(this.situacao) || !this.situacao.equals(situacaoEnums.getSigla())) continue;
            return situacaoEnums.getTexto();
        }
        return this.situacao;
    }

    public String getTextFromTipo() {
        for (TipoSolicitacaoRedeSimEnum tipoEnums : TipoSolicitacaoRedeSimEnum.values()) {
            if (!this.tipo.equals(tipoEnums.getSigla())) continue;
            return tipoEnums.getTexto();
        }
        return this.tipo;
    }

    public boolean isIndeferido() {
        return SimNaoEnum.equalSim((String)this.indeferido);
    }

    public boolean isSituacaoEncaminhadoVistoria() {
        return this.situacao.equals(SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA.getSigla());
    }

    public boolean isSituacaoNaoProcessada() {
        return this.situacao.equals(SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla());
    }

    public boolean isSituacaoInconsistente() {
        return this.situacao.equals(SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE.getSigla());
    }

    public boolean isSituacaoAnalise() {
        return this.situacao.equals(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacoesAlvara.stream().max(Comparator.comparing(SolicitacaoAlvaraEntity::getSolicitacaoAlvara)).orElse(null);
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (EloListUtils.safeIsEmpty((List)this.solicitacoesAlvara).booleanValue()) {
            this.solicitacoesAlvara = Lists.newArrayList();
        }
        this.solicitacoesAlvara.removeIf(solicitacao -> Objects.nonNull(solicitacao.getSolicitacaoAlvara()) && Objects.nonNull(solicitacaoAlvara.getSolicitacaoAlvara()) && solicitacao.getSolicitacaoAlvara().compareTo(solicitacaoAlvara.getSolicitacaoAlvara()) == 0);
        this.solicitacoesAlvara.add(solicitacaoAlvara);
    }

    public boolean temSolicitacaoAlvara() {
        return Objects.nonNull(this.getSolicitacaoAlvara());
    }

    public boolean isMeiInicial() throws SolicitacaoAlvaraRedeSimException {
        try {
            return this.isMei() && this.isEventoInicial(PortalUtils.normalizeJson((String)this.arquivoDadosEmpresa));
        }
        catch (SolicitacaoAlvaraRedeSimException e) {
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha, verificar o enquadramento da empresa.", e.getCause());
        }
    }

    public boolean isMei() throws SolicitacaoAlvaraRedeSimException {
        try {
            SolicitacaoAlvaraRedeSimDTO solicitacao = PortalUtils.normalizeJson((String)this.arquivoDadosEmpresa);
            Integer enquadramento = new Integer(solicitacao.getDados_solicitacao().getEmpresa().getCo_enquadramento());
            if (EnquadramentoEmpresaEnum.fromCodigo((Integer)enquadramento).getSigla().equals("M")) {
                return Boolean.TRUE;
            }
        }
        catch (SolicitacaoAlvaraRedeSimException e) {
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha ai verificar o enquadramento da empresa", e.getCause());
        }
        return Boolean.FALSE;
    }

    public boolean isAtualizacaoCadastral() {
        return !SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO.getSigla().equals(this.situacao) && !SituacaoConsultaPreviaRedeSimEnum.CONSULTA_INDEFERIDA.getSigla().equals(this.situacao) && !SituacaoConsultaPreviaRedeSimEnum.RESTRICAO_CADASTRAL.getSigla().equals(this.situacao);
    }

    private boolean isEventoInicial(SolicitacaoAlvaraRedeSimDTO solicitacao) {
        return (long)((Evento)solicitacao.getDados_solicitacao().getEventos_redesim().stream().findFirst().get()).getCo_evento() == 101L;
    }

    public boolean isRenovarAlvaraProvisorio() {
        return Objects.nonNull(this.getAlvaraEnviado()) && TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)this.getAlvaraEnviado()) && !this.getSolicitacaoAlvara().isRenovacao() && this.getSolicitacaoAlvara().possuiNumeroAlvara();
    }

    public boolean isRuralArquivoEmpresa() throws SolicitacaoAlvaraRedeSimException {
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(this.arquivoDadosEmpresa);
            return Optional.of(DadosSolicitacao.of((JsonNode)jsonNode)).map(DadosSolicitacao::getEmpresa).map(Empresa::getEndereco).map(Endereco::getNatureza_imovel).map(Natureza_imovel::getCo_tipo_natureza).map(TIPO_NATUREZA_RURAL::equals).orElse(Boolean.FALSE);
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha ao verificar se a empresa \u00e9 rural", (Throwable)e);
        }
    }

    public boolean isRuralArquivoConsulta() {
        ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)new Gson().fromJson(this.arquivoConsulta, ConsultaPreviaDTO.class);
        return Optional.ofNullable(consultaPreviaDTO.getDados_consulta_previa()).map(DadosConsultaPrevia::getEndereco).map(Endereco::getNatureza_imovel).map(Natureza_imovel::getCo_tipo_natureza).map(TIPO_NATUREZA_RURAL::equals).orElse(Boolean.FALSE);
    }

    public boolean isInscricaoEnviada() {
        return SimNaoEnum.equalSim((String)this.inscricaoEnviada);
    }

    public String getTipoInscricaoAlvara() {
        return Optional.ofNullable(this.getSolicitacaoAlvara()).map(SolicitacaoAlvaraEntity::getTipoDeInscricao).map(TipoInscricaoAlvaraEntity::getDescricao).orElse("");
    }

    public Boolean isEnderecoCadastroGeralValido() {
        return Optional.ofNullable(this.getSolicitacaoAlvara()).map(SolicitacaoAlvaraEntity::getCadastroMobiliario).map(CadastroMobiliarioEntity::getCadastroGeral).map(CadastroGeralAiseEntity::isEnderecoValido).orElse(Boolean.FALSE);
    }

    public Long getId() {
        return this.id;
    }

    public String getArquivoConsulta() {
        return this.arquivoConsulta;
    }

    public String getArquivoDadosEmpresa() {
        return this.arquivoDadosEmpresa;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoesAlvara() {
        return this.solicitacoesAlvara;
    }

    public String getIndeferido() {
        return this.indeferido;
    }

    public String getMotivoIndeferimento() {
        return this.motivoIndeferimento;
    }

    public String getResposta() {
        return this.resposta;
    }

    public List<IndeferimentoRedeSimEntity> getIndeferimentos() {
        return this.indeferimentos;
    }

    public List<EventoRedeSimEntity> getEventos() {
        return this.eventos;
    }

    public List<HistoricoExigenciaRedeSimEntity> getHistoricosExigencias() {
        return this.historicosExigencias;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public String getInvalidado() {
        return this.invalidado;
    }

    public TipoAlvaraEnum getAlvaraEnviado() {
        return this.alvaraEnviado;
    }

    public Long getIdRespostaConsulta() {
        return this.idRespostaConsulta;
    }

    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getUsuarioTramitacao() {
        return this.usuarioTramitacao;
    }

    public Date getDataTramitacao() {
        return this.dataTramitacao;
    }

    public String getCpfSolicitante() {
        return this.cpfSolicitante;
    }

    public String getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    public SolicitacaoBaixaRedeSimEntity getSolicitacaoBaixaRedeSim() {
        return this.solicitacaoBaixaRedeSim;
    }

    public String getInscricaoEnviada() {
        return this.inscricaoEnviada;
    }

    public Long getCep() {
        return this.cep;
    }

    public ImprimirTaxasAlvara getImprimirTaxasAlvara() {
        return this.imprimirTaxasAlvara;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setArquivoConsulta(String arquivoConsulta) {
        this.arquivoConsulta = arquivoConsulta;
    }

    public void setArquivoDadosEmpresa(String arquivoDadosEmpresa) {
        this.arquivoDadosEmpresa = arquivoDadosEmpresa;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setSolicitacoesAlvara(List<SolicitacaoAlvaraEntity> solicitacoesAlvara) {
        this.solicitacoesAlvara = solicitacoesAlvara;
    }

    public void setIndeferido(String indeferido) {
        this.indeferido = indeferido;
    }

    public void setMotivoIndeferimento(String motivoIndeferimento) {
        this.motivoIndeferimento = motivoIndeferimento;
    }

    public void setResposta(String resposta) {
        this.resposta = resposta;
    }

    public void setIndeferimentos(List<IndeferimentoRedeSimEntity> indeferimentos) {
        this.indeferimentos = indeferimentos;
    }

    public void setEventos(List<EventoRedeSimEntity> eventos) {
        this.eventos = eventos;
    }

    public void setHistoricosExigencias(List<HistoricoExigenciaRedeSimEntity> historicosExigencias) {
        this.historicosExigencias = historicosExigencias;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setInvalidado(String invalidado) {
        this.invalidado = invalidado;
    }

    public void setAlvaraEnviado(TipoAlvaraEnum alvaraEnviado) {
        this.alvaraEnviado = alvaraEnviado;
    }

    public void setIdRespostaConsulta(Long idRespostaConsulta) {
        this.idRespostaConsulta = idRespostaConsulta;
    }

    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setUsuarioTramitacao(String usuarioTramitacao) {
        this.usuarioTramitacao = usuarioTramitacao;
    }

    public void setDataTramitacao(Date dataTramitacao) {
        this.dataTramitacao = dataTramitacao;
    }

    public void setCpfSolicitante(String cpfSolicitante) {
        this.cpfSolicitante = cpfSolicitante;
    }

    public void setCnpjEmpresa(String cnpjEmpresa) {
        this.cnpjEmpresa = cnpjEmpresa;
    }

    public void setSolicitacaoBaixaRedeSim(SolicitacaoBaixaRedeSimEntity solicitacaoBaixaRedeSim) {
        this.solicitacaoBaixaRedeSim = solicitacaoBaixaRedeSim;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public void setInscricaoEnviada(String inscricaoEnviada) {
        this.inscricaoEnviada = inscricaoEnviada;
    }

    public void setCep(Long cep) {
        this.cep = cep;
    }

    public void setImprimirTaxasAlvara(ImprimirTaxasAlvara imprimirTaxasAlvara) {
        this.imprimirTaxasAlvara = imprimirTaxasAlvara;
    }

    public String toString() {
        return "SolicitacaoRedeSimEntity(id=" + this.getId() + ", arquivoConsulta=" + this.getArquivoConsulta() + ", arquivoDadosEmpresa=" + this.getArquivoDadosEmpresa() + ", dataSolicitacao=" + this.getDataSolicitacao() + ", situacao=" + this.getSituacao() + ", protocolo=" + this.getProtocolo() + ", tipo=" + this.getTipo() + ", solicitacoesAlvara=" + this.getSolicitacoesAlvara() + ", indeferido=" + this.getIndeferido() + ", motivoIndeferimento=" + this.getMotivoIndeferimento() + ", resposta=" + this.getResposta() + ", indeferimentos=" + this.getIndeferimentos() + ", eventos=" + this.getEventos() + ", historicosExigencias=" + this.getHistoricosExigencias() + ", observacao=" + this.getObservacao() + ", invalidado=" + this.getInvalidado() + ", alvaraEnviado=" + this.getAlvaraEnviado() + ", idRespostaConsulta=" + this.getIdRespostaConsulta() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", endereco=" + this.getEndereco() + ", numero=" + this.getNumero() + ", bairro=" + this.getBairro() + ", complemento=" + this.getComplemento() + ", usuarioTramitacao=" + this.getUsuarioTramitacao() + ", dataTramitacao=" + this.getDataTramitacao() + ", cpfSolicitante=" + this.getCpfSolicitante() + ", cnpjEmpresa=" + this.getCnpjEmpresa() + ", solicitacaoBaixaRedeSim=" + this.getSolicitacaoBaixaRedeSim() + ", ativo=" + this.isAtivo() + ", inscricaoEnviada=" + this.getInscricaoEnviada() + ", cep=" + this.getCep() + ", imprimirTaxasAlvara=" + this.getImprimirTaxasAlvara() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoRedeSimEntity)) {
            return false;
        }
        SolicitacaoRedeSimEntity other = (SolicitacaoRedeSimEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoRedeSimEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

