/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoConselhoEntity;
import br.com.elotech.tributacao.domain.aise.CarteiraProfissionalEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.util.list.EloListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity(name="SolicitacaoNumeroConselho")
@Table(name="tribsolalvaranumeroconselho")
public class SolicitacaoAlvaraNumConselhoEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="idsolalvaranumeroconselho")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idsolicitacaoatividade", referencedColumnName="idsolicitacaoatividade")
    private SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade;
    private String numeroRegistro;
    private String nomeResponsavel;
    @ManyToOne
    @JoinColumn(name="carteiraprofissional", referencedColumnName="carteiraprofissional")
    private CarteiraProfissionalEntity carteiraProfissional;
    @OneToMany(mappedBy="solicitacaoAlvaraNumConselho", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SolicitacaoAlvaraDocumentoConselhoEntity> documentos;
    @Transient
    private List<String> mensagemErroDocumentosNaoEnviados;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SolicitacaoAlvaraAtividadeEntity getSolicitacaoAtividade() {
        return this.solicitacaoAtividade;
    }

    public void setSolicitacaoAtividade(SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade) {
        this.solicitacaoAtividade = solicitacaoAtividade;
    }

    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    public String getNomeResponsavel() {
        return this.nomeResponsavel;
    }

    public void setNomeResponsavel(String nomeResponsavel) {
        this.nomeResponsavel = nomeResponsavel;
    }

    public CarteiraProfissionalEntity getCarteiraProfissional() {
        return this.carteiraProfissional;
    }

    public void setCarteiraProfissional(CarteiraProfissionalEntity carteiraProfissional) {
        this.carteiraProfissional = carteiraProfissional;
    }

    public List<SolicitacaoAlvaraDocumentoConselhoEntity> getDocumentos() {
        return this.documentos;
    }

    public List<String> getMensagemErroDocumentosNaoEnviados() {
        return this.mensagemErroDocumentosNaoEnviados;
    }

    public void addDocumentos(List<SolicitacaoAlvaraDocumentoConselhoEntity> documentos) {
        if (Objects.isNull(this.documentos)) {
            this.documentos = new ArrayList();
        }
        this.documentos.addAll(documentos);
    }

    public Boolean possuiTodosDocumentosAnexados(List<TipoDocumentoEntity> tiposDocumento) {
        this.mensagemErroDocumentosNaoEnviados = new ArrayList();
        if (EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
            this.mensagemErroDocumentosNaoEnviados.add("\u00c9 necess\u00e1rio informar os documentos do Respons\u00e1vel T\u00e9cnico");
            return false;
        }
        if (!EloListUtils.safeIsEmpty(tiposDocumento).booleanValue()) {
            for (TipoDocumentoEntity tipoDocumentoObrigatorio : tiposDocumento) {
                boolean possuiTipoDocumentoAnexado = false;
                for (SolicitacaoAlvaraDocumentoConselhoEntity documentoAnexado : this.documentos) {
                    if (!documentoAnexado.getSolicitacaoAlvaraDocumento().getTipoDocumento().equals((Object)tipoDocumentoObrigatorio)) continue;
                    possuiTipoDocumentoAnexado = true;
                }
                if (possuiTipoDocumentoAnexado) continue;
                this.mensagemErroDocumentosNaoEnviados.add(String.format("N\u00e3o foi anexado um documento do tipo '%s' para o respons\u00e1vel %s", tipoDocumentoObrigatorio.getDescricao(), this.nomeResponsavel));
            }
        }
        return EloListUtils.safeIsEmpty((List)this.mensagemErroDocumentosNaoEnviados);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.carteiraProfissional == null ? 0 : this.carteiraProfissional.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.nomeResponsavel == null ? 0 : this.nomeResponsavel.hashCode());
        result = 31 * result + (this.numeroRegistro == null ? 0 : this.numeroRegistro.hashCode());
        result = 31 * result + (this.solicitacaoAtividade == null ? 0 : this.solicitacaoAtividade.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SolicitacaoAlvaraNumConselhoEntity other = (SolicitacaoAlvaraNumConselhoEntity)obj;
        if (this.carteiraProfissional == null ? other.carteiraProfissional != null : !this.carteiraProfissional.equals((Object)other.carteiraProfissional)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.nomeResponsavel == null ? other.nomeResponsavel != null : !this.nomeResponsavel.equals(other.nomeResponsavel)) {
            return false;
        }
        if (this.numeroRegistro == null ? other.numeroRegistro != null : !this.numeroRegistro.equals(other.numeroRegistro)) {
            return false;
        }
        return !(this.solicitacaoAtividade == null ? other.solicitacaoAtividade != null : !this.solicitacaoAtividade.equals((Object)other.solicitacaoAtividade));
    }
}

