/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ClassificacaoTipoInscricaoEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoConsultaPreviaEntity;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDebitoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.AtividadeCnaeVo;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.PessoaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.RegimeFiscalPeriodoRealAiseEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.aise.ZoneamentoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.interfaces.Testada;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.string.Strings;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.springframework.security.core.userdetails.UserDetails;

@Entity(name="SolicitacaoAlvara")
@Table(name="tribsolicitacaoalvara")
public class SolicitacaoAlvaraEntity
implements EntityDef,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    private Long solicitacaoAlvara;
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumns(value={@JoinColumn(name="tipocadastroimobiliario", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeralimobiliario", referencedColumnName="cadastrogeral")})
    private CadastroImobiliarioEntity cadastroImobiliario;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumns(value={@JoinColumn(name="tipocadastromobiliario", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeralmobiliario", referencedColumnName="cadastrogeral")})
    private CadastroMobiliarioEntity cadastroMobiliario;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="tipocadastroimobiliario", referencedColumnName="tipocadastro")), @JoinColumnOrFormula(formula=@JoinFormula(value="cadastrogeralimobiliario", referencedColumnName="cadastrogeral")), @JoinColumnOrFormula(column=@JoinColumn(name="idlogradourotestada", referencedColumnName="idlogradourotestada"))})
    private CadastroImobiliarioTestadaEntity imobiliarioTestada;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="tipocadastroimobiliario", referencedColumnName="tipocadastro")), @JoinColumnOrFormula(formula=@JoinFormula(value="cadastrogeralimobiliario", referencedColumnName="cadastrogeral")), @JoinColumnOrFormula(column=@JoinColumn(name="codigotestadagenerica", referencedColumnName="codigotestadagenerica"))})
    private CadastroImobiliarioTestadaGenericaEntity imobiliarioTestadaGenerica;
    @OneToMany(mappedBy="solicitacaoAlvara", cascade={CascadeType.ALL})
    private List<SolicitacaoAlvaraAtividadeEntity> solicitacaoAlvaraAtividades;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="tribsolicitacaoalvaranatureza", joinColumns={@JoinColumn(name="solicitacaoalvara", referencedColumnName="solicitacaoalvara")}, inverseJoinColumns={@JoinColumn(name="naturezasolicitacao", referencedColumnName="naturezasolicitacao")})
    private List<NaturezaSolicitacaoAlvaraEntity> naturezas;
    private Long numeroSolicitacao;
    @Temporal(value=TemporalType.DATE)
    private Date dataSolicitacao;
    @ManyToOne
    @JoinColumn(name="tipoDeInscricao", referencedColumnName="idTipoInscricaoAlvara")
    private TipoInscricaoAlvaraEntity tipoDeInscricao;
    @Temporal(value=TemporalType.DATE)
    private Date dataValidadeConsultaPrevia;
    private String nomeRazaoSocial;
    private String fantasia;
    private String cpfCnpj;
    private String rg;
    private String rgOrgaoEmissor;
    private String rgUfEmissor;
    @Temporal(value=TemporalType.DATE)
    private Date rgDataEmissao;
    private String telefone;
    private String telefoneCelular;
    @Column(length=4000)
    private String descricaoAtividades;
    private Long numeroAlvara;
    private String exigencias;
    private Integer taxaLocalizacao;
    private String obsValidacaoDoc;
    private String msgEmailDebito;
    @Transient
    private String msgEmailHabitese;
    @ManyToOne
    @JoinColumn(name="pessoamobiliario", referencedColumnName="pessoamobiliario", insertable=false, updatable=false)
    private PessoaMobiliarioEntity pessoaMobiliario;
    private Long codigoCmcResponsavel;
    private String nomeCmcResponsavel;
    @Transient
    private String cpfCnpjCmcResponsavel;
    private BigDecimal areaUtilizada;
    private String logradouroImobiliario;
    private String numeroImobiliario;
    private String complementoImobiliario;
    private String bairroImobiliario;
    private String quadraImobiliario;
    private Long exercicio;
    private String rivGasAcima1560k;
    private String rivNaveAcima500m;
    @Column(name="FINALIZADO", length=1)
    private String finalizado;
    @Column(name="TIPOREQUERENTE", length=1)
    private String tipoRequerente;
    @Column(name="GRAURISCO", length=1)
    private String grauRisco;
    @Column(name="OBSERVACOES", length=4000)
    private String observacoes;
    @Temporal(value=TemporalType.DATE)
    private Date dataValidadeSefaz;
    @Column(name="AREACONSTRUIDA")
    private BigDecimal areaConstruida;
    @Column(name="AREAPATIO")
    private BigDecimal areaPatio;
    @Column(name="ARMAZENAMENTO")
    private BigDecimal armazenamento;
    @Transient
    private EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal;
    @OneToMany(mappedBy="solicitacaoAlvara", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<SolicitacaoAlvaraDocumentoEntity> documentos;
    @OneToMany(mappedBy="solicitacaoAlvara", cascade={CascadeType.ALL})
    private List<SolicitacaoAlvaraDebitoEntity> debitos = new ArrayList();
    private String gerarAlvara;
    @Temporal(value=TemporalType.DATE)
    private Date dataValidadeAcessibilidade;
    private String possuiAcessibilidade;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataConsultaPrevia;
    @Temporal(value=TemporalType.DATE)
    private Date dataValidadeProvisorio;
    private String verificaPropImovel;
    private String renovacao;
    @Temporal(value=TemporalType.DATE)
    private Date dataRenovacao;
    @ManyToOne
    @JoinColumn(name="usuario", referencedColumnName="usuario")
    private UsuarioEntity usuario;
    @ManyToOne
    @JoinColumn(name="IDAcessoWeb", referencedColumnName="IDAcessoWeb")
    private AcessoWebEntity acessoWeb;
    private String protocoloRedeSim;
    private String cpfCnpjConsulta;
    @OneToMany(mappedBy="solicitacaoAlvara", cascade={CascadeType.ALL})
    private List<RestricaoAlvaraEntity> restricoes;
    private String geraRestricaoCadJaExistente;
    private String eixoGeo;
    private String zonaGeo;
    private String proibicao;
    @Transient
    private SolicitacaoAlvaraAtividadeEntity solicitacaoAtividadeSelecionada;
    private String email;
    @Transient
    private Boolean verificaRestricaoCadastroExistente;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="idSolicitacaoAlvara")
    private List<LaudoAlvaraEntity> laudos = new ArrayList();
    private String areaMaiorQueAtual;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="idSolicitacaoAlvara")
    private ClassificacaoTipoInscricaoEntity classificacaoTipoInscricao;
    @OneToOne(mappedBy="solicitacaoAlvara")
    private SolicitacaoContratoSocialEntity contratoSocial;
    @OneToMany(mappedBy="solicitacaoAlvara", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SefazDocumentoEntity> sefazDocumentos = new ArrayList();
    private String usuarioImpressao;
    @Transient
    private String codAutenticidade;
    @Transient
    private DocumentoAiseEntity documento;
    @Transient
    private RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo;
    private String processoGerado;
    @Transient
    private List<AtividadeCnaeVo> atividadesVo;
    @Column(length=100)
    private String complementoCadGeral;
    private String efetivado;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="solicitacaoAlvara")
    private RestricaoConsultaPreviaEntity restricaoConsultaPrevia;
    @OneToOne(mappedBy="solicitacaoAlvara", fetch=FetchType.LAZY, orphanRemoval=true)
    private SolicitacaoDispensaAmbientalEntity solicitacaoDispensaAmbiental;
    private Long logradouro;
    private Long cidadeLogradouro;
    private Long bairro;
    private Long cidadeBairro;
    private Long cep;
    private String numero;
    private String complementoLogradouro;
    @Transient
    private List<String> errosValidacaoImobiliario = new ArrayList();
    @Transient
    private List<Atividade> listaDeAtividades = new ArrayList();

    public SolicitacaoAlvaraEntity() {
    }

    public SolicitacaoAlvaraEntity(String nomeRazaoSocial, Long numeroSolicitacao) {
        this.nomeRazaoSocial = nomeRazaoSocial;
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public SolicitacaoAlvaraEntity(Long solicitacaoAlvara, Long numeroSolicitacao, Long exercicio, TipoInscricaoAlvaraEntity tipoDeInscricao, String processoGerado) {
        this.solicitacaoAlvara = solicitacaoAlvara;
        this.numeroSolicitacao = numeroSolicitacao;
        this.exercicio = exercicio;
        this.tipoDeInscricao = tipoDeInscricao;
        this.processoGerado = processoGerado;
    }

    public List<Atividade> getListaDeAtividades() {
        return this.listaDeAtividades;
    }

    public DocumentoAiseEntity getDocumento() {
        return this.documento;
    }

    public void setDocumento(DocumentoAiseEntity documento) {
        this.documento = documento;
    }

    public RegimeFiscalPeriodoRealAiseEntity getRegimeFiscalPeriodo() {
        return this.regimeFiscalPeriodo;
    }

    public void setRegimeFiscalPeriodo(RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo) {
        this.regimeFiscalPeriodo = regimeFiscalPeriodo;
    }

    public List<SefazDocumentoEntity> getSefazDocumentos() {
        return this.sefazDocumentos;
    }

    public void setSefazDocumentos(List<SefazDocumentoEntity> validaSefazDocumentos) {
        this.sefazDocumentos = validaSefazDocumentos;
    }

    public RestricaoConsultaPreviaEntity getRestricaoConsultaPrevia() {
        return this.restricaoConsultaPrevia;
    }

    public void setRestricaoConsultaPrevia(RestricaoConsultaPreviaEntity restricaoConsultaPrevia) {
        this.restricaoConsultaPrevia = restricaoConsultaPrevia;
    }

    public SolicitacaoDispensaAmbientalEntity getSolicitacaoDispensaAmbiental() {
        return this.solicitacaoDispensaAmbiental;
    }

    public void setSolicitacaoDispensaAmbiental(SolicitacaoDispensaAmbientalEntity solicitacaoDispensaAmbiental) {
        this.solicitacaoDispensaAmbiental = solicitacaoDispensaAmbiental;
    }

    public String getEfetivado() {
        return this.efetivado;
    }

    public void setEfetivado(String efetivado) {
        this.efetivado = efetivado;
    }

    public TipoInscricaoAlvaraEntity getTipoDeInscricao() {
        return this.tipoDeInscricao;
    }

    public void setTipoDeInscricao(TipoInscricaoAlvaraEntity tipoDeInscricao) {
        this.tipoDeInscricao = tipoDeInscricao;
    }

    public Boolean getVerificaRestricaoCadastroExistente() {
        return this.verificaRestricaoCadastroExistente;
    }

    public void setVerificaRestricaoCadastroExistente(Boolean verificaRestricaoCadastroExistente) {
        this.verificaRestricaoCadastroExistente = verificaRestricaoCadastroExistente;
    }

    public String getProibicao() {
        return this.proibicao;
    }

    public void setProibicao(String proibicao) {
        this.proibicao = proibicao;
    }

    public String getEixoGeo() {
        return this.eixoGeo;
    }

    public void setEixoGeo(String eixoGeo) {
        this.eixoGeo = eixoGeo;
    }

    public String getZonaGeo() {
        return this.zonaGeo;
    }

    public void setZonaGeo(String zonaGeo) {
        this.zonaGeo = zonaGeo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<LaudoAlvaraEntity> getLaudos() {
        return this.laudos;
    }

    public void setLaudos(List<LaudoAlvaraEntity> laudos) {
        this.laudos = laudos;
    }

    public SolicitacaoAlvaraAtividadeEntity getSolicitacaoAtividadeSelecionada() {
        return this.solicitacaoAtividadeSelecionada;
    }

    public void setSolicitacaoAtividadeSelecionada(SolicitacaoAlvaraAtividadeEntity solicitacaoAtividadeSelecionada) {
        this.solicitacaoAtividadeSelecionada = solicitacaoAtividadeSelecionada;
    }

    public String getGeraRestricaoCadJaExistente() {
        return this.geraRestricaoCadJaExistente;
    }

    public void setGeraRestricaoCadJaExistente(String geraRestricaoCadJaExistente) {
        this.geraRestricaoCadJaExistente = geraRestricaoCadJaExistente;
    }

    public String getCpfCnpjConsulta() {
        return this.cpfCnpjConsulta;
    }

    public void setCpfCnpjConsulta(String cpfCnpjConsulta) {
        this.cpfCnpjConsulta = cpfCnpjConsulta;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getRgOrgaoEmissor() {
        return this.rgOrgaoEmissor;
    }

    public void setRgOrgaoEmissor(String rgOrgaoEmissor) {
        this.rgOrgaoEmissor = rgOrgaoEmissor;
    }

    public String getRgUfEmissor() {
        return this.rgUfEmissor;
    }

    public void setRgUfEmissor(String rgUfEmissor) {
        this.rgUfEmissor = rgUfEmissor;
    }

    public Date getRgDataEmissao() {
        return this.rgDataEmissao;
    }

    public void setRgDataEmissao(Date rgDataEmissao) {
        this.rgDataEmissao = rgDataEmissao;
    }

    public String getProtocoloRedeSim() {
        return this.protocoloRedeSim;
    }

    public void setProtocoloRedeSim(String protocoloRedeSim) {
        this.protocoloRedeSim = protocoloRedeSim;
    }

    public UsuarioEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioEntity usuario) {
        this.usuario = usuario;
    }

    public AcessoWebEntity getAcessoWeb() {
        return this.acessoWeb;
    }

    public void setAcessoWeb(AcessoWebEntity acessoWeb) {
        this.acessoWeb = acessoWeb;
    }

    public String getRenovacao() {
        return this.renovacao;
    }

    public void setRenovacao(String renovacao) {
        this.renovacao = renovacao;
    }

    public Date getDataRenovacao() {
        return this.dataRenovacao;
    }

    public void setDataRenovacao(Date dataRenovacao) {
        this.dataRenovacao = dataRenovacao;
    }

    public String getVerificaPropImovel() {
        return this.verificaPropImovel;
    }

    public String getMsgEmailDebito() {
        return this.msgEmailDebito;
    }

    public void setMsgEmailDebito(String msgEmailDebito) {
        this.msgEmailDebito = msgEmailDebito;
    }

    public String getMsgEmailHabitese() {
        return this.msgEmailHabitese;
    }

    public void setMsgEmailHabitese(String msgEmailHabitese) {
        this.msgEmailHabitese = msgEmailHabitese;
    }

    public Date getDataValidadeConsultaPrevia() {
        return this.dataValidadeConsultaPrevia;
    }

    public void setDataValidadeConsultaPrevia(Date dataValidadeConsultaPrevia) {
        this.dataValidadeConsultaPrevia = dataValidadeConsultaPrevia;
    }

    public void setVerificaPropImovel(String verificaPropImovel) {
        this.verificaPropImovel = verificaPropImovel;
    }

    public Date getDataConsultaPrevia() {
        return this.dataConsultaPrevia;
    }

    public void setDataConsultaPrevia(Date dataConsultaPrevia) {
        this.dataConsultaPrevia = dataConsultaPrevia;
    }

    public String getPossuiAcessibilidade() {
        return this.possuiAcessibilidade;
    }

    public void setPossuiAcessibilidade(String possuiAcessibilidade) {
        this.possuiAcessibilidade = possuiAcessibilidade;
    }

    public Date getDataValidadeAcessibilidade() {
        return this.dataValidadeAcessibilidade;
    }

    public void setDataValidadeAcessibilidade(Date dataValidadeAcessibilidade) {
        this.dataValidadeAcessibilidade = dataValidadeAcessibilidade;
    }

    public Integer getTaxaLocalizacao() {
        return this.taxaLocalizacao;
    }

    public void setTaxaLocalizacao(Integer taxaLocalizacao) {
        this.taxaLocalizacao = taxaLocalizacao;
    }

    public String getExigencias() {
        return this.exigencias;
    }

    public String getObsValidacaoDoc() {
        return this.obsValidacaoDoc;
    }

    public void setObsValidacaoDoc(String obsValidacaoDoc) {
        this.obsValidacaoDoc = obsValidacaoDoc;
    }

    public void setExigencias(String exigencias) {
        this.exigencias = exigencias;
    }

    public Long getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public String getRivGasAcima1560k() {
        return this.rivGasAcima1560k;
    }

    public void setRivGasAcima1560k(String rivGasAcima1560k) {
        this.rivGasAcima1560k = rivGasAcima1560k;
    }

    public String getRivNaveAcima500m() {
        return this.rivNaveAcima500m;
    }

    public void setRivNaveAcima500m(String rivNaveAcima500m) {
        this.rivNaveAcima500m = rivNaveAcima500m;
    }

    public String getGerarAlvara() {
        return this.gerarAlvara;
    }

    public void setGerarAlvara(String gerarAlvara) {
        this.gerarAlvara = gerarAlvara;
    }

    public void setSolicitacaoAlvara(Long solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public void setCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public Long getNumeroAlvara() {
        return this.numeroAlvara;
    }

    public void setNumeroAlvara(Long numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    public CadastroImobiliarioTestadaEntity getImobiliarioTestada() {
        return this.imobiliarioTestada;
    }

    public void setImobiliarioTestada(CadastroImobiliarioTestadaEntity imobiliarioTestada) {
        this.imobiliarioTestada = imobiliarioTestada;
    }

    public List<SolicitacaoAlvaraAtividadeEntity> getSolicitacaoAlvaraAtividades() {
        return this.solicitacaoAlvaraAtividades;
    }

    public void setSolicitacaoAlvaraAtividades(List<SolicitacaoAlvaraAtividadeEntity> solicitacaoAlvaraAtividades) {
        this.solicitacaoAlvaraAtividades = solicitacaoAlvaraAtividades;
    }

    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public void setNumeroSolicitacao(Long numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getNomeRazaoSocial() {
        return this.nomeRazaoSocial;
    }

    public void setNomeRazaoSocial(String nomeRazaoSocial) {
        this.nomeRazaoSocial = nomeRazaoSocial;
    }

    public String getFantasia() {
        return this.fantasia;
    }

    public void setFantasia(String fantasia) {
        this.fantasia = fantasia;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getTelefoneCelular() {
        return this.telefoneCelular;
    }

    public void setTelefoneCelular(String telefoneCelular) {
        this.telefoneCelular = telefoneCelular;
    }

    public String getDescricaoAtividades() {
        return this.descricaoAtividades;
    }

    public void setDescricaoAtividades(String descricaoAtividades) {
        if (!EloStringUtils.isEmpty((String)descricaoAtividades)) {
            this.descricaoAtividades = descricaoAtividades.length() > 4000 ? descricaoAtividades.substring(0, 3999) : descricaoAtividades;
        }
    }

    public PessoaMobiliarioEntity getPessoaMobiliario() {
        return this.pessoaMobiliario;
    }

    public void setPessoaMobiliario(PessoaMobiliarioEntity pessoaMobiliario) {
        this.pessoaMobiliario = pessoaMobiliario;
    }

    public Long getCodigoCmcResponsavel() {
        return this.codigoCmcResponsavel;
    }

    public void setCodigoCmcResponsavel(Long codigoCmcResponsavel) {
        this.codigoCmcResponsavel = codigoCmcResponsavel;
    }

    public String getNomeCmcResponsavel() {
        return this.nomeCmcResponsavel;
    }

    public void setNomeCmcResponsavel(String nomeCmcResponsavel) {
        this.nomeCmcResponsavel = nomeCmcResponsavel;
    }

    public String getCpfCnpjCmcResponsavel() {
        return this.cpfCnpjCmcResponsavel;
    }

    public void setCpfCnpjCmcResponsavel(String cpfCnpjCmcResponsavel) {
        this.cpfCnpjCmcResponsavel = cpfCnpjCmcResponsavel;
    }

    public BigDecimal getAreaUtilizada() {
        if (!EloNumberUtils.isBiggerThanZero((Number)this.areaUtilizada).booleanValue()) {
            this.areaUtilizada = this.getAreaConstruida() == null ? BigDecimal.ZERO : this.getAreaConstruida();
            this.areaUtilizada = this.areaUtilizada.add(this.getAreaPatio() == null ? BigDecimal.ZERO : this.getAreaPatio());
        }
        return this.areaUtilizada;
    }

    public void setAreaUtilizada(BigDecimal areaUtilizada) {
        this.areaUtilizada = areaUtilizada;
    }

    public String getLogradouroImobiliario() {
        return this.logradouroImobiliario;
    }

    public void setLogradouroImobiliario(String logradouroImobiliario) {
        this.logradouroImobiliario = logradouroImobiliario;
    }

    public String getNumeroImobiliario() {
        return this.numeroImobiliario;
    }

    public void setNumeroImobiliario(String numeroImobiliario) {
        this.numeroImobiliario = numeroImobiliario;
    }

    public String getComplementoImobiliario() {
        return this.complementoImobiliario;
    }

    public void setComplementoImobiliario(String complementoImobiliario) {
        this.complementoImobiliario = complementoImobiliario;
    }

    public String getBairroImobiliario() {
        return this.bairroImobiliario;
    }

    public void setBairroImobiliario(String bairroImobiliario) {
        this.bairroImobiliario = bairroImobiliario;
    }

    public String getQuadraImobiliario() {
        return this.quadraImobiliario;
    }

    public void setQuadraImobiliario(String quadraImobiliario) {
        this.quadraImobiliario = quadraImobiliario;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public String getFinalizado() {
        return this.finalizado;
    }

    public void setFinalizado(String finalizado) {
        this.finalizado = finalizado;
    }

    public String getTipoRequerente() {
        return this.tipoRequerente;
    }

    public void setTipoRequerente(String tipoRequerente) {
        this.tipoRequerente = tipoRequerente;
    }

    public String getGrauRisco() {
        return this.grauRisco;
    }

    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    public String getTextGrauRisco() {
        if (this.isGrauRiscoBaixo()) {
            return "Baixo";
        }
        if (this.isGrauRiscoAlto()) {
            return "Alto";
        }
        if (this.isGrauRiscoLiberdadeEconomica()) {
            return "Liberdade Econ\u00f4mica";
        }
        return "";
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public Date getDataValidadeSefaz() {
        return this.dataValidadeSefaz;
    }

    public void setDataValidadeSefaz(Date dataValidadeSefaz) {
        this.dataValidadeSefaz = dataValidadeSefaz;
    }

    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    public BigDecimal getAreaPatio() {
        return this.areaPatio;
    }

    public void setAreaPatio(BigDecimal areaPatio) {
        this.areaPatio = areaPatio;
    }

    public BigDecimal getArmazenamento() {
        return this.armazenamento;
    }

    public void setArmazenamento(BigDecimal armazenamento) {
        this.armazenamento = armazenamento;
    }

    public EnderecoCadastroGeralEntity getEnderecoImobiliarioPrincipal() {
        return this.enderecoImobiliarioPrincipal;
    }

    public void setEnderecoImobiliarioPrincipal(EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal) {
        this.enderecoImobiliarioPrincipal = enderecoImobiliarioPrincipal;
    }

    public String getDescNaturezasSelecionadas() {
        StringBuilder sbNaturezas = new StringBuilder();
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                sbNaturezas.append(natureza.getDescricao());
                sbNaturezas.append("; ");
            }
            sbNaturezas = sbNaturezas.delete(sbNaturezas.length() - 2, sbNaturezas.length());
        }
        return sbNaturezas.toString();
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getDocumentos() {
        return this.documentos;
    }

    public void setDocumentos(List<SolicitacaoAlvaraDocumentoEntity> documentos) {
        this.documentos = documentos;
    }

    public List<SolicitacaoAlvaraDebitoEntity> getDebitos() {
        return this.debitos;
    }

    public void setDebitos(List<SolicitacaoAlvaraDebitoEntity> debitos) {
        this.debitos = debitos;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezas() {
        if (this.naturezas == null) {
            this.naturezas = new ArrayList();
        }
        return this.naturezas;
    }

    public void setNaturezas(List<NaturezaSolicitacaoAlvaraEntity> naturezas) {
        this.naturezas = naturezas;
    }

    public String getCodAutenticidade() {
        return this.codAutenticidade;
    }

    public void setCodAutenticidade(String codAutenticidade) {
        this.codAutenticidade = codAutenticidade;
    }

    public String getAreaMaiorQueAtual() {
        return this.areaMaiorQueAtual;
    }

    public void setAreaMaiorQueAtual(String areaMaiorQueAtual) {
        this.areaMaiorQueAtual = areaMaiorQueAtual;
    }

    public ClassificacaoTipoInscricaoEntity getClassificacaoTipoInscricao() {
        return this.classificacaoTipoInscricao;
    }

    public void setClassificacaoTipoInscricao(ClassificacaoTipoInscricaoEntity classificacaoTipoInscricao) {
        this.classificacaoTipoInscricao = classificacaoTipoInscricao;
    }

    public SolicitacaoContratoSocialEntity getContratoSocial() {
        return this.contratoSocial;
    }

    public void setContratoSocial(SolicitacaoContratoSocialEntity contratoSocial) {
        this.contratoSocial = contratoSocial;
    }

    public List<String> getErrosValidacaoImobiliario() {
        return this.errosValidacaoImobiliario;
    }

    public String getUsuarioImpressao() {
        return this.usuarioImpressao;
    }

    public void setUsuarioImpressao(String usuarioImpressao) {
        this.usuarioImpressao = usuarioImpressao;
    }

    public boolean isNaturezaMudancaEndereco() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaAlteracaoSocio() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaAlteracaoAtividade() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaMudancaRazaoSocial() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaMudancaRazaoOuSocios() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue()) && !natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaMudancaArea() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNaturezaInicial() {
        if (this.naturezas != null) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
                if (!natureza.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SolicitacaoAlvaraEntity [naturezas=" + this.naturezas + "]";
    }

    public List<RestricaoAlvaraEntity> getRestricoes() {
        return this.restricoes;
    }

    public void setRestricoes(List<RestricaoAlvaraEntity> restricoes) {
        this.restricoes = restricoes;
    }

    public String getRestricoesString() {
        StringBuilder restricaoStr = new StringBuilder();
        if (this.restricoes != null) {
            for (RestricaoAlvaraEntity restricao : this.restricoes) {
                restricaoStr.append(restricao.getDescricao().concat(";\n"));
            }
        }
        return restricaoStr.toString();
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaInicial() {
        for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
            if (!natureza.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue())) continue;
            return natureza;
        }
        return null;
    }

    public NaturezaSolicitacaoAlvaraEntity getNatureza(NaturezaSolicitacaoAlvaraEnum naturezaEnum) {
        for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
            if (!natureza.getCodigo().equals(naturezaEnum.getValue())) continue;
            return natureza;
        }
        return null;
    }

    public boolean isSolicitacaoPJ() {
        return this.isSolicitacaoJuridicaNormal() || this.isSolicitacaoPrestadorServico();
    }

    public boolean isSolicitacaoJuridicaNormal() {
        return Objects.nonNull(this.tipoDeInscricao) && "N".equals(this.tipoDeInscricao.getSigla());
    }

    public boolean isSolicitacaoPrestadorServico() {
        return Objects.nonNull(this.tipoDeInscricao) && "P".equals(this.tipoDeInscricao.getSigla());
    }

    public boolean isObservacaoAtividadesDeferimentoGeo() {
        return this.isSolicitacaoPrestadorServico() || this.isNaturezaInicial() && !this.isSolicitacaoMEI();
    }

    public boolean isSolicitacaoMEI() {
        return this.isSolicitacaoMEINormal() || this.isSolicitacaoMEIPrestador();
    }

    public boolean isSolicitacaoMEINormal() {
        return Objects.nonNull(this.tipoDeInscricao) && "M".equals(this.tipoDeInscricao.getSigla());
    }

    public boolean isSolicitacaoMEIPrestador() {
        return Objects.nonNull(this.tipoDeInscricao) && "MP".equals(this.tipoDeInscricao.getSigla());
    }

    public boolean isSolicitacaoCBO() {
        return Objects.nonNull(this.tipoDeInscricao) && "C".equals(this.tipoDeInscricao.getSigla());
    }

    public boolean possuiAtividadeNova() {
        for (SolicitacaoAlvaraAtividadeEntity atividade : this.solicitacaoAlvaraAtividades) {
            if (!"I".equals(atividade.getSituacao())) continue;
            return true;
        }
        return false;
    }

    public String getTituloRelatorio() {
        if (this.isSolicitacaoJuridicaNormal() || this.isSolicitacaoCBO()) {
            return "ALVAR\u00c1 DE LOCALIZA\u00c7\u00c3O";
        }
        if (this.isSolicitacaoPrestadorServico()) {
            return "INSCRI\u00c7\u00c3O DE PRESTADORES DE SERVI\u00c7O";
        }
        if (this.isSolicitacaoMEI() && this.classificacaoTipoInscricao != null) {
            if (SimNaoEnum.equalSim((String)this.classificacaoTipoInscricao.getPontoReferencia()).booleanValue()) {
                return "LICEN\u00c7A PARA EMPREENDEDOR INDIVIDUAL - SEM ATIVIDADE NO LOCAL";
            }
            if ("R".equals(this.classificacaoTipoInscricao.getTipoClassificacao())) {
                return "LICEN\u00c7A PARA EMPREENDEDOR INDIVIDUAL - SEM ATIVIDADE DE MERC\u00c2NCIA NO LOCAL";
            }
            if ("C".equals(this.classificacaoTipoInscricao.getTipoClassificacao())) {
                return "ALVAR\u00c1 DE LICEN\u00c7A - EMPREENDEDOR INDIVIDUAL";
            }
        }
        return "";
    }

    public CadastroImobiliarioEntity getCadastroImobiliario() {
        if (this.isRedeSim()) {
            return this.cadastroImobiliario;
        }
        if (this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            return this.cadastroImobiliario;
        }
        return Optional.ofNullable(this.cadastroMobiliario).map(CadastroMobiliarioEntity::getCadastroImobiliario).orElse(null);
    }

    public CadastroImobiliarioEntity cadastroImobiliarioSolicitacao() {
        return this.cadastroImobiliario;
    }

    public boolean possuiUmaDasNaturezas(NaturezaSolicitacaoAlvaraEnum ... naturezas) {
        for (NaturezaSolicitacaoAlvaraEnum naturezaEnum : naturezas) {
            for (NaturezaSolicitacaoAlvaraEntity n : this.getNaturezas()) {
                if (!naturezaEnum.getValue().equalsIgnoreCase(n.getCodigo())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean possuiSomenteNatureza(NaturezaSolicitacaoAlvaraEnum natureza) {
        return this.getNaturezas().size() == 1 && this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{natureza});
    }

    public boolean possuiSomenteNaturezas(NaturezaSolicitacaoAlvaraEnum ... naturezas) {
        if (naturezas.length == this.getNaturezas().size()) {
            for (NaturezaSolicitacaoAlvaraEnum naturezaEnum : naturezas) {
                if (this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{naturezaEnum})) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSituacaoMobiliarioDesatualizadoOuVencido() {
        SituacaoMobiliarioEntity situacao = this.getCadastroMobiliario().getMobiliarioSituacaoAtual();
        boolean isSituacaoDesatualizadoOuVencido = situacao.hasSituacaoMobiliarioAlvara(new SituacaoMobiliarioAlvaraEnum[]{SituacaoMobiliarioAlvaraEnum.SITUACAO_DESATUALIZADO, SituacaoMobiliarioAlvaraEnum.SITUACAO_VENCIDO});
        return isSituacaoDesatualizadoOuVencido;
    }

    public boolean isSituacaoMobiliarioDesatualizado() {
        SituacaoMobiliarioEntity situacao = this.getCadastroMobiliario().getMobiliarioSituacaoAtual();
        boolean isDesatualizado = situacao.hasSituacaoMobiliarioAlvara(new SituacaoMobiliarioAlvaraEnum[]{SituacaoMobiliarioAlvaraEnum.SITUACAO_DESATUALIZADO});
        return isDesatualizado;
    }

    public boolean isSituacaoMobiliarioNormal() {
        SituacaoMobiliarioEntity situacao = this.getCadastroMobiliario().getMobiliarioSituacaoAtual();
        boolean isNormal = situacao.hasSituacaoMobiliarioAlvara(new SituacaoMobiliarioAlvaraEnum[]{SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL});
        return isNormal;
    }

    public boolean isSituacaoMobiliarioVencido() {
        SituacaoMobiliarioEntity situacao = this.getCadastroMobiliario().getMobiliarioSituacaoAtual();
        boolean isVencido = situacao.hasSituacaoMobiliarioAlvara(new SituacaoMobiliarioAlvaraEnum[]{SituacaoMobiliarioAlvaraEnum.SITUACAO_VENCIDO});
        return isVencido;
    }

    public boolean isAreaMaiorQueAtual() {
        BigDecimal areaAtual;
        BigDecimal bigDecimal = areaAtual = this.getCadastroMobiliario().getAreaUtilizada() == null ? BigDecimal.ZERO : this.getCadastroMobiliario().getAreaUtilizada();
        BigDecimal areaNova = this.getAreaConstruida() == null ? BigDecimal.ZERO : this.getAreaConstruida().add(this.getAreaPatio() == null ? BigDecimal.ZERO : this.getAreaPatio());
        return areaNova.compareTo(areaAtual) > 0;
    }

    public boolean isGrauRiscoBaixo() {
        return GrauDeRiscoEnum.isGrauRiscoBaixo((String)this.grauRisco);
    }

    public boolean isGrauRiscoAlto() {
        return GrauDeRiscoEnum.isGrauRiscoAlto((String)this.grauRisco);
    }

    public boolean isGrauRiscoLiberdadeEconomica() {
        return GrauDeRiscoEnum.isGrauRiscoLiberdadeEconomica((String)this.grauRisco);
    }

    public boolean exigeUploadDocumentos() {
        if (this.isSolicitacaoJuridicaNormal()) {
            return this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
        }
        if (this.isSolicitacaoPrestadorServico()) {
            return false;
        }
        if (this.isSolicitacaoMEI()) {
            return this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
        }
        if (this.isSolicitacaoCBO()) {
            return this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
        }
        return false;
    }

    public String getComplementoCadGeral() {
        return this.complementoCadGeral;
    }

    public void setComplementoCadGeral(String complementoCadGeral) throws SolicitacaoAlvaraException {
        if (!Strings.isEmpty((CharSequence)complementoCadGeral)) {
            try {
                int size = this.getClass().getDeclaredField("complementoCadGeral").getAnnotation(Column.class).length();
                int inLength = complementoCadGeral.length();
                if (inLength > size) {
                    complementoCadGeral = complementoCadGeral.substring(0, size);
                }
            }
            catch (NoSuchFieldException e) {
                throw new SolicitacaoAlvaraException("N\u00e3o foi encontrado o campo complementoCadGeral! Entre em contato com o suporte!");
            }
        }
        this.complementoCadGeral = complementoCadGeral;
    }

    public String montarComplementoMobiliarioEImobiliario() {
        StringBuilder complemento = new StringBuilder();
        if (this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            String juncao = "";
            if (!EloStringUtils.isEmpty((String)this.complementoCadGeral)) {
                complemento.append(this.complementoCadGeral.trim());
                juncao = " - ";
            }
            if (Objects.nonNull(this.cadastroImobiliario) && !EloStringUtils.isEmpty((String)this.cadastroImobiliario.getComplementoLote()) && !complemento.toString().equals(this.cadastroImobiliario.getComplementoLote())) {
                complemento.append(juncao).append(this.cadastroImobiliario.getComplementoLote().trim());
            }
        } else if (Objects.nonNull(this.cadastroImobiliario) && !EloStringUtils.isEmpty((String)this.cadastroMobiliario.getCadastroGeral().getComplemento())) {
            complemento.append(this.cadastroMobiliario.getCadastroGeral().getComplemento());
        }
        return complemento.toString().replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("\n", " ").toUpperCase().trim();
    }

    public String montarComplementoMobiliarioEImobiliarioRedeSim() {
        StringBuilder complemento = new StringBuilder();
        if (this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && Objects.nonNull(this.cadastroImobiliario)) {
            String juncao = "";
            if (!EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getComplemento())) {
                complemento.append(this.cadastroImobiliario.getCadastroGeral().getComplemento().trim());
                juncao = " | ";
            }
            if (!EloStringUtils.isEmpty((String)this.cadastroImobiliario.getComplementoLote()) && !complemento.toString().equals(this.cadastroImobiliario.getComplementoLote())) {
                complemento.append(juncao).append(this.cadastroImobiliario.getComplementoLote());
            }
        } else {
            complemento.append(this.cadastroMobiliario.getCadastroGeral().getComplemento());
        }
        return complemento.toString().replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("\n", " ").toUpperCase().trim();
    }

    public BigDecimal getAreaProcessamento() {
        BigDecimal areaProcessamento = null;
        if (!EloListUtils.safeIsEmpty((List)this.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : this.getSolicitacaoAlvaraAtividades()) {
                if (atividade.getAreaProcessamento() == null) continue;
                if (areaProcessamento == null || areaProcessamento.compareTo(BigDecimal.ZERO) == 0) {
                    areaProcessamento = atividade.getAreaProcessamento();
                    continue;
                }
                if (!EloNumberUtils.isBiggerThanZero((Number)atividade.getAreaProcessamento()).booleanValue() || atividade.getAreaProcessamento().compareTo(areaProcessamento) >= 0) continue;
                areaProcessamento = atividade.getAreaProcessamento();
            }
        }
        return areaProcessamento;
    }

    public String montarEnderecoCorretoDaSolicitacao() throws BaseException {
        StringBuilder endereco = new StringBuilder();
        if (this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
                endereco.append(this.cadastroImobiliario.getCadastroGeral().getLogradouro().getTipoLogradouro().getDescricao()).append(" ");
                endereco.append(this.cadastroImobiliario.getCadastroGeral().getLogradouro().getDescricao());
                if (this.cadastroImobiliario.getCadastroGeral().getNumero() != null) {
                    endereco.append(", ").append(this.cadastroImobiliario.getCadastroGeral().getNumero());
                }
            } else {
                Testada testada = this.getTestada();
                if (testada != null && testada.getLogradouro() != null) {
                    endereco.append(testada.getLogradouro().getTipoLogradouro().getDescricao()).append(" ");
                    endereco.append(testada.getLogradouro().getDescricao());
                    if (testada.getNumero() != null) {
                        endereco.append(", ").append(testada.getNumero());
                    } else if (this.cadastroImobiliario != null && this.cadastroImobiliario.getCadastroGeral().getNumero() != null) {
                        endereco.append(", ").append(this.cadastroImobiliario.getCadastroGeral().getNumero());
                    }
                }
            }
        } else if (this.cadastroMobiliario != null) {
            endereco.append(this.cadastroMobiliario.getCadastroGeral().getLogradouro().getTipoLogradouro().getDescricao()).append(" ");
            endereco.append(this.cadastroMobiliario.getCadastroGeral().getLogradouro().getDescricao()).append(", ");
            endereco.append(this.cadastroMobiliario.getCadastroGeral().getNumero());
        }
        return endereco.toString();
    }

    public boolean isAlteracaoRazaoOuRazaoESocio() {
        return this.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) || this.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
    }

    public boolean isAlteracaoRazao() {
        return this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
    }

    public boolean isAlteracaoNaturezaJuridica() {
        return this.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_NATUREZA_JURIDICA});
    }

    public boolean isAlteracaoRazaoOuSocioOuRazaoESocio() {
        return this.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) || this.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS}) || this.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
    }

    public boolean isAlterandoEnderecoSemAlterarAtividade() {
        return this.isNaturezaMudancaEndereco() && !this.isNaturezaAlteracaoAtividade();
    }

    public boolean possuiLaudoProvisorio() {
        if (!EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            for (LaudoAlvaraEntity laudo : this.getLaudos()) {
                if (!laudo.isLaudoLiberadoProvisorio()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean possuiLaudoVigilanciaSanitaria() {
        if (!EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return this.getLaudos().stream().anyMatch(laudoAlvaraEntity -> TipoLaudoEnum.VIGILANCIA_SANITARIA.equals((Object)laudoAlvaraEntity.getTipoLaudo().getCodigo()));
        }
        return false;
    }

    public boolean possuiTodosLaudosLiberadoDefinitivo() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().allMatch(LaudoAlvaraEntity::isLaudoLiberadoDefinitivo);
    }

    public boolean possuiTodosLaudosLiberadoDefinitivoOuLiberdadeEconomica() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().allMatch(LaudoAlvaraEntity::isLaudoLiberadoLiberdadeEconomica);
    }

    public boolean possuiTodosLaudosLiberado() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().allMatch(LaudoAlvaraEntity::isLaudoLiberadoDefinitivoOuProvisorio);
    }

    public boolean possuiAlgumLaudoNaoLiberado() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().anyMatch(LaudoAlvaraEntity::isLaudoNaoLiberado);
    }

    public boolean verificarLaudosLiberacaoAutomatica() {
        return EloListUtils.safeIsEmpty((List)this.getLaudos()) == false && this.possuiTodosLaudosLiberado();
    }

    public String getAreas() {
        BigDecimal areaProcessamento;
        StringBuilder areas = new StringBuilder();
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
        if (this.getAreaConstruida() != null) {
            areas.append("\u00c1rea Constru\u00edda: ");
            areas.append(df.format(this.getAreaConstruida()));
            areas.append("m\u00b2");
        } else if (this.getCadastroMobiliario() != null && this.getCadastroMobiliario().getAreaUtilizada() != null) {
            areas.append("\u00c1rea Utilizada: ");
            areas.append(df.format(this.getCadastroMobiliario().getAreaUtilizada()));
            areas.append("m\u00b2");
        }
        if (EloNumberUtils.isBiggerThanZero((Number)this.getAreaPatio()).booleanValue()) {
            areas.append(", \u00c1rea de P\u00e1tio: ");
            areas.append(df.format(this.getAreaPatio()));
            areas.append("m\u00b2");
        }
        if (EloNumberUtils.isBiggerThanZero((Number)(areaProcessamento = this.getAreaProcessamento())).booleanValue()) {
            areas.append(", \u00c1rea de Processamento: ");
            areas.append(df.format(areaProcessamento));
            areas.append("m\u00b2");
        }
        return areas.toString();
    }

    public String getObservacaoDasAtividades(boolean consultaPrevia) {
        StringBuilder obs = new StringBuilder();
        boolean introducaoSomenteEs = false;
        boolean introducaoSomenteEscrConc = false;
        boolean introducaoAtividadeConcResid = false;
        boolean areaMaxProcessamento = false;
        StringBuilder strSomenteEscr = new StringBuilder();
        StringBuilder strSomenteEscrConc = new StringBuilder();
        StringBuilder strAtividadeConc = new StringBuilder();
        StringBuilder strAreaMaxProcessamento = new StringBuilder();
        if (!EloListUtils.safeIsEmpty((List)this.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtiv : this.getSolicitacaoAlvaraAtividades()) {
                if (SimNaoEnum.equalSim((String)solicitacaoAtiv.getSomenteEscritorio()).booleanValue()) {
                    if (!introducaoSomenteEs) {
                        strSomenteEscr.append("<strong>ATIVIDADES SOMENTE ESCRIT\u00d3RIO (CNAE): </strong>").append("<br>");
                    }
                    strSomenteEscr.append(this.concatenarAtividade(solicitacaoAtiv, consultaPrevia));
                    introducaoSomenteEs = true;
                }
                if (SimNaoEnum.equalSim((String)solicitacaoAtiv.getSomenteEscrConcomitanteRes()).booleanValue()) {
                    if (!introducaoSomenteEscrConc) {
                        strSomenteEscrConc.append("<br><strong>ATIVIDADES SOMENTE ESCRIT\u00d3RIO CONCOMITANTE RESID\u00caNCIA (CNAE):</strong> <br>");
                    }
                    strSomenteEscrConc.append(this.concatenarAtividade(solicitacaoAtiv, consultaPrevia));
                    introducaoSomenteEscrConc = true;
                }
                if (SimNaoEnum.equalSim((String)solicitacaoAtiv.getAtividadeConcomitanteRes()).booleanValue()) {
                    if (!introducaoAtividadeConcResid) {
                        strAtividadeConc.append("<br><strong>ATIVIDADES CONCOMITANTE RESID\u00caNCIA (CNAE):</strong> <br>");
                    }
                    strAtividadeConc.append(this.concatenarAtividade(solicitacaoAtiv, consultaPrevia));
                    introducaoAtividadeConcResid = true;
                }
                if (!EloNumberUtils.isBiggerThanZero((Number)solicitacaoAtiv.getAreaProcessamento()).booleanValue()) continue;
                if (!areaMaxProcessamento) {
                    areaMaxProcessamento = true;
                    strAreaMaxProcessamento.append("<strong>ATIVIDADES (CNAE) COM \u00c1REA DE PROCESSAMENTO M\u00c1XIMA AT\u00c9 ").append(solicitacaoAtiv.getAreaProcessamento().toString()).append("m\u00b2 :</strong> <br>");
                }
                strAreaMaxProcessamento.append(this.concatenarAtividade(solicitacaoAtiv, consultaPrevia));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)strSomenteEscr.toString())) {
            obs.append(System.lineSeparator()).append(strSomenteEscr.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)strSomenteEscrConc.toString())) {
            obs.append(System.lineSeparator()).append(strSomenteEscrConc.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)strAtividadeConc.toString())) {
            obs.append(System.lineSeparator()).append(strAtividadeConc.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)strAreaMaxProcessamento.toString())) {
            obs.append(System.lineSeparator()).append(strAreaMaxProcessamento.toString());
        }
        return obs.toString();
    }

    private String concatenarAtividade(SolicitacaoAlvaraAtividadeEntity solicitacaoAtiv, boolean consultaPrevia) {
        StringBuilder strConcat = new StringBuilder();
        if (solicitacaoAtiv.getCnae() != null) {
            strConcat.append(consultaPrevia ? solicitacaoAtiv.getCnae().getCodigo() : solicitacaoAtiv.getCnae().getDescricao()).append("; ");
        } else if (solicitacaoAtiv.getAtividadeMei() != null) {
            strConcat.append(consultaPrevia ? solicitacaoAtiv.getAtividadeMei().getCodigo() : solicitacaoAtiv.getAtividadeMei().getDescricao()).append("; ");
        } else if (solicitacaoAtiv.getSequenciaCbo() != null) {
            strConcat.append((Object)(consultaPrevia ? solicitacaoAtiv.getSequenciaCbo().getCodigo() : solicitacaoAtiv.getSequenciaCbo())).append("; ");
        }
        return strConcat.toString();
    }

    public String getNumeroSolicitacaoExercicio() {
        return this.numeroSolicitacao + "/" + this.exercicio;
    }

    public boolean isRedeSim() {
        return this.protocoloRedeSim != null;
    }

    public boolean isTodosLaudosLiberadoDefinitivo() {
        for (LaudoAlvaraEntity laudo : this.getLaudos()) {
            if (laudo.isLaudoLiberadoDefinitivo()) continue;
            return false;
        }
        return true;
    }

    public boolean isTodosLaudosLiberados() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().allMatch(laudo -> laudo.isLaudoLiberadoDefinitivoOuProvisorio() || laudo.isLaudoLiberadoLiberdadeEconomica());
    }

    public boolean isRenovacao() {
        return !EloStringUtils.isEmpty((String)this.renovacao) && this.renovacao.equals(SimNaoEnum.SIM.getShortText());
    }

    public boolean isAcessoContribuinte() {
        return this.acessoWeb != null;
    }

    public UserDetails getUserDetails() {
        if (this.isAcessoContribuinte()) {
            return this.acessoWeb;
        }
        return this.usuario;
    }

    public void setUserDetails(UserDetails userDetails) {
        if (userDetails instanceof UsuarioEntity) {
            this.setUsuario((UsuarioEntity)userDetails);
        } else {
            this.setAcessoWeb((AcessoWebEntity)userDetails);
        }
    }

    public boolean isPossuiEixoNaTestada() {
        return this.imobiliarioTestada != null && this.imobiliarioTestada.getEixo() != null || this.imobiliarioTestadaGenerica != null && this.imobiliarioTestadaGenerica.getIdeixo() != null;
    }

    public boolean isPossuiZoneamentoNaTestada() {
        return this.imobiliarioTestada != null && this.imobiliarioTestada.getZoneamento() != null;
    }

    public boolean isPossuiPontoReferencia() {
        return this.classificacaoTipoInscricao != null && SimNaoEnum.equalSim((String)this.classificacaoTipoInscricao.getPontoReferencia()) != false;
    }

    public EixoEntity getEixo() {
        if (this.imobiliarioTestadaGenerica != null && this.imobiliarioTestadaGenerica.getIdeixo() != null) {
            return this.imobiliarioTestadaGenerica.getIdeixo();
        }
        if (this.imobiliarioTestada != null && this.imobiliarioTestada.getEixo() != null) {
            return this.imobiliarioTestada.getEixo();
        }
        return null;
    }

    public ZoneamentoEntity getZoneamento() {
        if (this.imobiliarioTestada != null && this.imobiliarioTestada.getZoneamento() != null) {
            return this.imobiliarioTestada.getZoneamento();
        }
        return null;
    }

    public Testada getTestada() {
        return this.imobiliarioTestadaGenerica == null ? this.imobiliarioTestada : this.imobiliarioTestadaGenerica;
    }

    public void setTestada(Testada testada) {
        if (testada instanceof CadastroImobiliarioTestadaEntity) {
            this.imobiliarioTestada = (CadastroImobiliarioTestadaEntity)testada;
        } else if (testada instanceof CadastroImobiliarioTestadaGenericaEntity) {
            this.imobiliarioTestadaGenerica = (CadastroImobiliarioTestadaGenericaEntity)testada;
        }
    }

    public String getDescricaoQuadra() {
        if (this.imobiliarioTestada == null) {
            return this.cadastroImobiliario.getQuadraDescr();
        }
        return this.imobiliarioTestada.getId().getLogradouroTestada().getQuadra();
    }

    public CadastroImobiliarioTestadaGenericaEntity getImobiliarioTestadaGenerica() {
        return this.imobiliarioTestadaGenerica;
    }

    public void setImobiliarioTestadaGenerica(CadastroImobiliarioTestadaGenericaEntity imobiliarioTestadaGenerica) {
        this.imobiliarioTestadaGenerica = imobiliarioTestadaGenerica;
    }

    public List<AtividadeCnaeVo> getAtividadesVo() {
        return this.atividadesVo;
    }

    public void setAtividadesVo(List<AtividadeCnaeVo> atividadesVo) {
        this.atividadesVo = atividadesVo;
    }

    public String getProcessoGerado() {
        return this.processoGerado;
    }

    public void setProcessoGerado(String processoGerado) {
        this.processoGerado = processoGerado;
    }

    public boolean contemDocumentoNaoValidado() {
        if (!EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : this.documentos) {
                if (!documento.isDocumentoNaoValidado()) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescricaoClassificacaoTipoInscricao() {
        if (Objects.nonNull(this.getClassificacaoTipoInscricao())) {
            if (Objects.nonNull(this.getClassificacaoTipoInscricao().getPontoReferencia()) && this.getClassificacaoTipoInscricao().isPontoRef()) {
                return " Ponto de Refer\u00eancia";
            }
            if (this.getClassificacaoTipoInscricao().isClassificacaoComercial()) {
                return "Classifica\u00e7\u00e3o Comercial";
            }
            if (this.getClassificacaoTipoInscricao().isClassificacaoResidencial()) {
                return "Classifica\u00e7\u00e3o Resid\u00eancial";
            }
        }
        return "";
    }

    public boolean isReponsavelPessoaFisica() {
        if (StringUtils.isNotBlank((CharSequence)this.cpfCnpjConsulta)) {
            String cnpjCpf = EloStringUtils.safeTrim((String)this.cpfCnpjConsulta);
            return (cnpjCpf = EloStringUtils.retiraChars((String)cnpjCpf, (String)"./-")).length() != 14;
        }
        return false;
    }

    public void setErrosValidacaoImobiliario(List<String> errosCadastroImobiliario) {
        this.errosValidacaoImobiliario = errosCadastroImobiliario;
    }

    public boolean possuiErrosValidacaoImobiliario() {
        return EloListUtils.safeIsEmpty((List)this.errosValidacaoImobiliario) == false;
    }

    public String descricaoInformacoesImobiliarias() {
        StringBuilder sb = new StringBuilder();
        if (this.possuiErrosValidacaoImobiliario()) {
            for (String erro : this.errosValidacaoImobiliario) {
                if (!EloStringUtils.isEmpty((String)sb.toString())) {
                    sb.append("</br>");
                }
                sb.append(erro);
            }
        }
        return sb.toString();
    }

    public void validarInformacoesImovel() throws BaseException {
        if (this.isNaturezaInicial()) {
            this.errosValidacaoImobiliario = new ArrayList();
            if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
                if (EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getNumero())) {
                    this.errosValidacaoImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'N\u00famero'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
                }
                if (this.cadastroImobiliario.getCadastroGeral().getLogradouro() == null || EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getLogradouro().getDescricao())) {
                    this.errosValidacaoImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'Logradouro'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
                }
            } else {
                if (EloStringUtils.isEmpty((String)this.getTestada().getNumero())) {
                    this.errosValidacaoImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'N\u00famero'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
                }
                if (this.getTestada().getLogradouro() == null || EloStringUtils.isEmpty((String)this.getTestada().getLogradouro().getDescricao())) {
                    this.errosValidacaoImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'Logradouro'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
                }
            }
            if (this.cadastroImobiliario.getCadastroGeral().getBairro() == null || EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getBairro().getDescricao())) {
                this.errosValidacaoImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'Bairro'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
            }
        }
    }

    public boolean isTodosDocumentosValidos() {
        boolean validado = Boolean.TRUE;
        List docsNaoValidados = this.getDocumentos().stream().filter(doc -> SituacaoDocumentoAlvaraEnum.NAO_VALIDADO.equals((Object)doc.getSituacao())).collect(Collectors.toList());
        if (this.possuiDocumentoEmAnalise()) {
            return false;
        }
        if (!EloListUtils.safeIsEmpty(docsNaoValidados).booleanValue()) {
            validado = Boolean.FALSE;
            for (SolicitacaoAlvaraDocumentoEntity docNaoValidado : docsNaoValidados) {
                validado = this.existeOutroDocumentoValidadoParaTipoDocumento(docNaoValidado);
                if (validado) continue;
                return validado;
            }
        }
        return validado;
    }

    public boolean possuiDocumentoEmAnalise() {
        return this.getDocumentos().stream().anyMatch(doc -> SituacaoDocumentoAlvaraEnum.EM_ANALISE.equals((Object)doc.getSituacao()));
    }

    public Boolean possuiAlgumLaudoEmAnalise() {
        if (EloListUtils.safeIsEmpty((List)this.getLaudos()).booleanValue()) {
            return false;
        }
        return this.getLaudos().stream().anyMatch(laudo -> StatusLaudoAlvara.EM_ANDAMENTO.equals((Object)laudo.getStatus()));
    }

    public boolean existeOutroDocumentoValidadoParaTipoDocumento(SolicitacaoAlvaraDocumentoEntity docNaoValidado) {
        if (!EloListUtils.safeIsEmpty((List)this.getDocumentos()).booleanValue() && this.getDocumentos().stream().anyMatch(doc -> SituacaoDocumentoAlvaraEnum.VALIDADO.equals((Object)doc.getSituacao()) && doc.getTipoDocumento().getTipoDocumento().equals(docNaoValidado.getTipoDocumento().getTipoDocumento()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean hasLaudoNaoLiberado(SolicitacaoAlvaraEntity solicitacao) {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                if (laudo.isLaudoLiberadoDefinitivoOuProvisorio()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean bloqueiaRestricao(CadastroRestricaoAlvaraEntity cadastroRestricao) {
        return this.isGrauRiscoBaixo() && SimNaoEnum.equalSim((String)cadastroRestricao.getBloqueiaSolicitacaoRiscoBaixo()) != false || this.isGrauRiscoAlto() && SimNaoEnum.equalSim((String)cadastroRestricao.getBloqueiaSolicitacaoRiscoAlto()) != false;
    }

    public boolean isSomenteMudancaAreaSemAreaUtilizada() {
        return this.isNaturezaMudancaArea() && this.getNaturezas().size() == 1 && (Objects.isNull(this.getCadastroMobiliario().getAreaUtilizada()) || this.getCadastroMobiliario().getAreaUtilizada().compareTo(BigDecimal.ZERO) <= 0);
    }

    public boolean naoPossuiNumeroAlvara() {
        return EloNumberUtils.isBiggerThanZero((Number)this.numeroAlvara) == false;
    }

    public boolean possuiNumeroAlvara() {
        return EloNumberUtils.isBiggerThanZero((Number)this.numeroAlvara);
    }

    public List<String> getAlteracoes() {
        ArrayList alteracoes = Lists.newArrayList();
        if (!EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            this.naturezas.stream().forEach(natureza -> {
                NaturezaSolicitacaoAlvaraEnum naturezaSolicitacaoAlvaraEnum = NaturezaSolicitacaoAlvaraEnum.fromValue((String)natureza.getCodigo());
                if (naturezaSolicitacaoAlvaraEnum != null) {
                    alteracoes.add(naturezaSolicitacaoAlvaraEnum.getAlteracao());
                }
            });
        }
        return alteracoes;
    }

    public SolicitacaoAlvaraAtividadeEntity getAtividadePrincipal() {
        for (SolicitacaoAlvaraAtividadeEntity atividade : this.solicitacaoAlvaraAtividades) {
            if (!SimNaoEnum.equalSim((String)atividade.getPrincipal()).booleanValue()) continue;
            return atividade;
        }
        return null;
    }

    public boolean isRenovacaoDeSolicitacao() {
        return SimNaoEnum.equalSim((String)this.renovacao);
    }

    public boolean isAlteracao() {
        return !this.isNaturezaInicial();
    }

    public String getTelefonePreenchido() {
        return !EloStringUtils.isEmpty((String)this.telefone) ? this.telefone : (!EloStringUtils.isEmpty((String)this.telefoneCelular) ? this.telefoneCelular : "");
    }

    public boolean nenhumTelefonePreenchido() {
        return EloStringUtils.isEmpty((String)this.telefone) && EloStringUtils.isEmpty((String)this.telefoneCelular);
    }

    public String getCodigoRazaoCadastro() {
        String codigoNome = new String();
        if (Objects.nonNull(this.cadastroMobiliario)) {
            codigoNome = this.cadastroMobiliario.getCadastroGeral().getId().getCodigo().toString();
            codigoNome = codigoNome.concat(" - ");
            codigoNome = codigoNome.concat(this.cadastroMobiliario.getCadastroGeral().getPessoa().getNome());
        }
        return codigoNome;
    }

    public boolean contemLaudosProvisorios() {
        for (LaudoAlvaraEntity laudo : this.laudos) {
            if (!laudo.getStatus().equals((Object)StatusLaudoAlvara.LIBERADO_PROVISORIO)) continue;
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public LaudoAlvaraEntity getLaudoSelecionado(Long tipoLaudo) {
        return this.laudos.stream().filter(p -> p.getTipoLaudo().getIdTipoLaudo().equals(tipoLaudo)).findAny().orElse(null);
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getDocumentosComSituacaoDiferenteDeValidado() {
        return this.documentos.stream().filter(p -> !p.isDocumentoValidado() && !this.existeOutroDocumentoValidadoParaTipoDocumento(p)).collect(Collectors.toList());
    }

    public SolicitacaoAlvaraDocumentoEntity getDocumentoSolicitacaoByTipo(Long tipo) {
        return this.documentos.stream().filter(p -> p.getTipoDocumento().getTipoDocumento().equals(tipo)).findAny().orElse(null);
    }

    public String montarComplementoCadastroGeral() {
        if (this.isRedeSim()) {
            return this.montarComplementoMobiliarioEImobiliarioRedeSim();
        }
        return this.montarComplementoMobiliarioEImobiliario();
    }

    public boolean possuiTodasRestricoesBloqueantesAutorizadas() {
        return this.getRestricoes().stream().filter(restricao -> restricao.isBloqueante()).allMatch(restricao -> restricao.getAutorizado().equals(SimNaoEnum.SIM.getShortText()));
    }

    public boolean possuiLaudoAmbiental() {
        return this.getLaudos() != null && this.getLaudos().stream().anyMatch(laudo -> TipoLaudoEnum.AMBIENTAL.equals((Object)laudo.getTipoLaudo().getCodigo()));
    }

    public void atribuirGrauRisco(List<Atividade> listaAtividade) {
        if (!EloListUtils.safeIsEmpty(listaAtividade).booleanValue()) {
            if (listaAtividade.stream().anyMatch(atividade -> GrauDeRiscoEnum.isGrauRiscoAlto((String)atividade.getGrauRisco()))) {
                this.setGrauRisco(GrauDeRiscoEnum.RISCO_ALTO.getSigla());
            } else if (listaAtividade.stream().anyMatch(atividade -> GrauDeRiscoEnum.isGrauRiscoBaixo((String)atividade.getGrauRisco()))) {
                this.setGrauRisco(GrauDeRiscoEnum.RISCO_BAIXO.getSigla());
            } else {
                this.setGrauRisco(GrauDeRiscoEnum.RISCO_LIBERDADE_ECONOMICA.getSigla());
            }
        }
    }

    public void atribuirGrauRiscoCadastroMobiliario() throws SolicitacaoAlvaraException {
        if (!EloListUtils.safeIsEmpty((List)this.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) {
            this.atribuirGrauRisco(this.getCadastroMobiliario().getMobiliarioCnaes().stream().map(mobCnae -> mobCnae.getId().getCnae()).collect(Collectors.toList()));
        } else if (!EloListUtils.safeIsEmpty((List)this.getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue()) {
            this.atribuirGrauRisco(this.getCadastroMobiliario().getMobiliarioAtividadeMeis().stream().map(mobMei -> mobMei.getAtividadeMei().getCnae()).collect(Collectors.toList()));
        } else if (!EloListUtils.safeIsEmpty((List)this.getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
            this.atribuirGrauRisco(this.getCadastroMobiliario().getMobiliarioCbos().stream().map(mobCbo -> mobCbo.getRhCbo()).collect(Collectors.toList()));
        } else if (this.isRedeSim()) {
            this.setGrauRisco(GrauDeRiscoEnum.RISCO_ALTO.getSigla());
        } else {
            throw new SolicitacaoAlvaraException("N\u00e3o foi encontrado nenhuma atividade no cadastro mobili\u00e1rio!\nPor gentileza, entrar em contato com o setor de alvar\u00e1 \"\" informando o cadastro da inscri\u00e7\u00e3o.");
        }
    }

    public String getDescricaoTipoInscricao() {
        if (this.tipoDeInscricao != null) {
            return this.tipoDeInscricao.getDescricao();
        }
        return "";
    }

    public boolean possuiAnexoNosLaudos() {
        return this.laudos.stream().anyMatch(laudo -> laudo.possuiAnexoNoLaudo());
    }

    public boolean isMeiInicial() {
        return this.isSolicitacaoMEI() && this.isNaturezaInicial();
    }

    public CadastroImobiliarioEntity carregarCadastroImobiliario() {
        return Objects.isNull(this.cadastroImobiliario) ? (CadastroImobiliarioEntity)Optional.ofNullable(this.cadastroMobiliario).map(CadastroMobiliarioEntity::getCadastroImobiliario).orElse(null) : this.cadastroImobiliario;
    }

    public Long getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    public Long getCidadeLogradouro() {
        return this.cidadeLogradouro;
    }

    public void setCidadeLogradouro(Long cidadeLogradouro) {
        this.cidadeLogradouro = cidadeLogradouro;
    }

    public Long getBairro() {
        return this.bairro;
    }

    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    public Long getCidadeBairro() {
        return this.cidadeBairro;
    }

    public void setCidadeBairro(Long cidadeBairro) {
        this.cidadeBairro = cidadeBairro;
    }

    public Long getCep() {
        return this.cep;
    }

    public void setCep(Long cep) {
        this.cep = cep;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplementoLogradouro() {
        return this.complementoLogradouro;
    }

    public void setComplementoLogradouro(String complementoLogradouro) {
        this.complementoLogradouro = complementoLogradouro;
    }

    public Date getDataValidadeProvisorio() {
        return this.dataValidadeProvisorio;
    }

    public void setDataValidadeProvisorio(Date dataValidadeProvisorio) {
        this.dataValidadeProvisorio = dataValidadeProvisorio;
    }
}

