/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.tributacao.domain.aise.AtividadeEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity(name="SolicitacaoAlvaraDocumento")
@Table(name="tribsolicitacaoalvaradocumento")
public class SolicitacaoAlvaraDocumentoEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Column(name="SOLALVARADOCUMENTO")
    @Id
    private Long solicitacaoAlvaraDocumento;
    @ManyToOne
    @JoinColumn(name="solicitacaoalvara", referencedColumnName="solicitacaoalvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private byte[] documento;
    @ManyToOne
    @JoinColumn(name="tipodocumento", referencedColumnName="tipodocumento")
    private TipoDocumentoEntity tipoDocumento;
    @Column(name="DESCRICAO", length=60)
    private String descricao;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataValidacao;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataInclusao;
    @ManyToOne
    @JoinColumn(name="usuario", referencedColumnName="usuario")
    private UsuarioEntity usuario;
    @Column(name="RENOVACAO", length=1)
    private String renovacao;
    @Enumerated(value=EnumType.STRING)
    private SituacaoDocumentoAlvaraEnum situacao;
    private String motivoInvalidacao;
    @Transient
    private String nomeArquivo;
    @Enumerated(value=EnumType.STRING)
    private TipoAtividadeEnum tipoAtividade;
    @ManyToOne
    @JoinColumn(name="idatividade", referencedColumnName="atividade")
    private AtividadeEntity atividade;

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Date getDataValidacao() {
        return this.dataValidacao;
    }

    public void setDataValidacao(Date dataValidacao) {
        this.dataValidacao = dataValidacao;
    }

    public UsuarioEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioEntity usuario) {
        this.usuario = usuario;
    }

    public Long getSolicitacaoAlvaraDocumento() {
        return this.solicitacaoAlvaraDocumento;
    }

    public void setSolicitacaoAlvaraDocumento(Long solicitacaoAlvaraDocumento) {
        this.solicitacaoAlvaraDocumento = solicitacaoAlvaraDocumento;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public byte[] getDocumento() {
        return this.documento;
    }

    public void setDocumento(byte[] documento) {
        this.documento = documento;
    }

    public TipoDocumentoEntity getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(TipoDocumentoEntity tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getRenovacao() {
        return this.renovacao;
    }

    public void setRenovacao(String renovacao) {
        this.renovacao = renovacao;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public SituacaoDocumentoAlvaraEnum getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoDocumentoAlvaraEnum situacao) {
        this.situacao = situacao;
    }

    public String getMotivoInvalidacao() {
        return this.motivoInvalidacao;
    }

    public void setMotivoInvalidacao(String motivoInvalidacao) {
        this.motivoInvalidacao = motivoInvalidacao;
    }

    public boolean isDocumentoValidado() {
        return SituacaoDocumentoAlvaraEnum.VALIDADO.equals((Object)this.situacao);
    }

    public boolean isDocumentoNaoValidado() {
        return SituacaoDocumentoAlvaraEnum.NAO_VALIDADO.equals((Object)this.situacao);
    }

    public boolean isDocumentoEmAnalise() {
        return SituacaoDocumentoAlvaraEnum.EM_ANALISE.equals((Object)this.situacao);
    }

    public TipoAtividadeEnum getTipoAtividade() {
        return this.tipoAtividade;
    }

    public void setTipoAtividade(TipoAtividadeEnum tipoAtividade) {
        this.tipoAtividade = tipoAtividade;
    }

    public AtividadeEntity getAtividade() {
        return this.atividade;
    }

    public void setAtividade(AtividadeEntity atividade) {
        this.atividade = atividade;
    }

    public boolean idIsNull() {
        return Objects.isNull(this.getSolicitacaoAlvaraDocumento());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataInclusao == null ? 0 : this.dataInclusao.hashCode());
        result = 31 * result + (this.dataValidacao == null ? 0 : this.dataValidacao.hashCode());
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + Arrays.hashCode(this.documento);
        result = 31 * result + (this.motivoInvalidacao == null ? 0 : this.motivoInvalidacao.hashCode());
        result = 31 * result + (this.nomeArquivo == null ? 0 : this.nomeArquivo.hashCode());
        result = 31 * result + (this.renovacao == null ? 0 : this.renovacao.hashCode());
        result = 31 * result + (this.situacao == null ? 0 : this.situacao.hashCode());
        result = 31 * result + (this.solicitacaoAlvara == null ? 0 : this.solicitacaoAlvara.hashCode());
        result = 31 * result + (this.solicitacaoAlvaraDocumento == null ? 0 : this.solicitacaoAlvaraDocumento.hashCode());
        result = 31 * result + (this.tipoDocumento == null ? 0 : this.tipoDocumento.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SolicitacaoAlvaraDocumentoEntity other = (SolicitacaoAlvaraDocumentoEntity)obj;
        if (this.dataInclusao == null ? other.dataInclusao != null : !this.dataInclusao.equals(other.dataInclusao)) {
            return false;
        }
        if (this.dataValidacao == null ? other.dataValidacao != null : !this.dataValidacao.equals(other.dataValidacao)) {
            return false;
        }
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (!Arrays.equals(this.documento, other.documento)) {
            return false;
        }
        if (this.motivoInvalidacao == null ? other.motivoInvalidacao != null : !this.motivoInvalidacao.equals(other.motivoInvalidacao)) {
            return false;
        }
        if (this.nomeArquivo == null ? other.nomeArquivo != null : !this.nomeArquivo.equals(other.nomeArquivo)) {
            return false;
        }
        if (this.renovacao == null ? other.renovacao != null : !this.renovacao.equals(other.renovacao)) {
            return false;
        }
        if (this.situacao != other.situacao) {
            return false;
        }
        if (this.solicitacaoAlvara == null ? other.solicitacaoAlvara != null : !this.solicitacaoAlvara.equals(other.solicitacaoAlvara)) {
            return false;
        }
        if (this.solicitacaoAlvaraDocumento == null ? other.solicitacaoAlvaraDocumento != null : !this.solicitacaoAlvaraDocumento.equals(other.solicitacaoAlvaraDocumento)) {
            return false;
        }
        return !(this.tipoDocumento == null ? other.tipoDocumento != null : !this.tipoDocumento.equals((Object)other.tipoDocumento));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SolicitacaoAlvaraDocumentoEntity [solicitacaoAlvaraDocumento=");
        builder.append(this.solicitacaoAlvaraDocumento);
        builder.append(", solicitacaoAlvara=");
        builder.append(this.solicitacaoAlvara);
        builder.append(", documento=");
        builder.append(Arrays.toString(this.documento));
        builder.append(", tipoDocumento=");
        builder.append(this.tipoDocumento);
        builder.append(", descricao=");
        builder.append(this.descricao);
        builder.append(", dataValidacao=");
        builder.append(this.dataValidacao);
        builder.append(", dataInclusao=");
        builder.append(this.dataInclusao);
        builder.append(", usuario=");
        builder.append(this.usuario);
        builder.append(", renovacao=");
        builder.append(this.renovacao);
        builder.append(", situacao=");
        builder.append(this.situacao);
        builder.append(", motivoInvalidacao=");
        builder.append(this.motivoInvalidacao);
        builder.append(", nomeArquivo=");
        builder.append(this.nomeArquivo);
        builder.append("]");
        return builder.toString();
    }
}

