/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.ValidationEntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity(name="SefazDocumento")
@Table(name="tribsefazdocumento")
public class SefazDocumentoEntity
implements ValidationEntityDef {
    @Id
    @Column(name="ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="solicitacaoAlvara", referencedColumnName="solicitacaoAlvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @ManyToOne
    @JoinColumn(name="tipodocumento", referencedColumnName="tipodocumento")
    private TipoDocumentoEntity tipoDocumento;
    private byte[] documento;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataInclusao;
    private String nomeArquivo;
    @ManyToOne
    @JoinColumn(name="solicitacaoAlvaraDocumento", referencedColumnName="solAlvaraDocumento")
    private SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento;

    public void validar() throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (Objects.isNull(this.tipoDocumento)) {
            ve.adicionarMensagem("Informe o tipo de documento.");
        }
        if (Objects.isNull(this.documento)) {
            ve.adicionarMensagem("Informe o documento.");
        }
        ve.lancarException();
    }

    public SolicitacaoAlvaraDocumentoEntity toSolicitacaoAlvaraDocumento(UsuarioEntity usuarioCriacao) {
        SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento = new SolicitacaoAlvaraDocumentoEntity();
        solicitacaoAlvaraDocumento.setSolicitacaoAlvara(this.solicitacaoAlvara);
        solicitacaoAlvaraDocumento.setDataInclusao(this.dataInclusao);
        solicitacaoAlvaraDocumento.setTipoDocumento(this.tipoDocumento);
        solicitacaoAlvaraDocumento.setDocumento(this.documento);
        solicitacaoAlvaraDocumento.setSituacao(SituacaoDocumentoAlvaraEnum.EM_ANALISE);
        solicitacaoAlvaraDocumento.setNomeArquivo(this.nomeArquivo);
        solicitacaoAlvaraDocumento.setUsuario(usuarioCriacao);
        return solicitacaoAlvaraDocumento;
    }

    public Long getId() {
        return this.id;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public TipoDocumentoEntity getTipoDocumento() {
        return this.tipoDocumento;
    }

    public byte[] getDocumento() {
        return this.documento;
    }

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public SolicitacaoAlvaraDocumentoEntity getSolicitacaoAlvaraDocumento() {
        return this.solicitacaoAlvaraDocumento;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public void setTipoDocumento(TipoDocumentoEntity tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public void setDocumento(byte[] documento) {
        this.documento = documento;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public void setSolicitacaoAlvaraDocumento(SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento) {
        this.solicitacaoAlvaraDocumento = solicitacaoAlvaraDocumento;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SefazDocumentoEntity)) {
            return false;
        }
        SefazDocumentoEntity other = (SefazDocumentoEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SefazDocumentoEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "SefazDocumentoEntity(id=" + this.getId() + ", nomeArquivo=" + this.getNomeArquivo() + ")";
    }
}

