/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.tributacao.domain.vo.RegimeFiscalVo;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity(name="RegimeFiscal")
@Table(name="TribRegimeFiscal")
public class RegimeFiscalEntity
implements EntityDef {
    private static final long serialVersionUID = -5524697232921791978L;
    @Id
    @Column(name="IdRegimeFiscal")
    private Long id;
    private String descricao;
    @Column(length=1)
    private String issGeraDebito;
    @Column(name="IDISSREGIMEXSD")
    private Long regimeFiscalXsd;
    @Column(length=1)
    private String simplesNacional;
    @Column(length=1)
    private String mei;
    @Column(length=1)
    private String aliqZero;

    public String getSimplesNacional() {
        return this.simplesNacional;
    }

    public void setSimplesNacional(String simplesNacional) {
        this.simplesNacional = simplesNacional;
    }

    public String getMei() {
        return this.mei;
    }

    public void setMei(String mei) {
        this.mei = mei;
    }

    public Long getRegimeFiscalXsd() {
        return this.regimeFiscalXsd;
    }

    public void setRegimeFiscalXsd(Long regimeFiscalXsd) {
        this.regimeFiscalXsd = regimeFiscalXsd;
    }

    public String getIssGeraDebito() {
        return this.issGeraDebito;
    }

    public void setIssGeraDebito(String issGeraDebito) {
        this.issGeraDebito = issGeraDebito;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Boolean isGeraDebito() {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.issGeraDebito);
    }

    public Boolean isSimplesNacional() {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.simplesNacional);
    }

    public Boolean isMei() {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.mei);
    }

    public String getAliqZero() {
        return this.aliqZero;
    }

    public void setAliqZero(String aliqZero) {
        this.aliqZero = aliqZero;
    }

    public RegimeFiscalVo toRegimeFiscalVo() {
        RegimeFiscalVo regimeFiscalVo = new RegimeFiscalVo();
        regimeFiscalVo.setId(this.getId());
        regimeFiscalVo.setDescricao(this.getDescricao());
        regimeFiscalVo.setGeraDebito(Boolean.valueOf("S".equals(this.getIssGeraDebito())));
        return regimeFiscalVo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegimeFiscalEntity other = (RegimeFiscalEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegimeFiscalEntity [id=");
        builder.append(this.id);
        builder.append(", descricao=");
        builder.append(this.descricao);
        builder.append(", issGeraDebito=");
        builder.append(this.issGeraDebito);
        builder.append(", regimeFiscalXsd=");
        builder.append(this.regimeFiscalXsd);
        builder.append(", simplesNacional=");
        builder.append(this.simplesNacional);
        builder.append(", mei=");
        builder.append(this.mei);
        builder.append(", aliqZero=");
        builder.append(this.aliqZero);
        builder.append("]");
        return builder.toString();
    }
}

