/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.ValidationEntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.tributacao.domain.IdEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity(name="NaturezaSolicitacaoTipoInscricaoAlvara")
@Table(name="TRIBNATUREZASOLTIPOINSCALVARA")
public class NaturezaSolicitacaoTipoInscricaoAlvaraEntity
implements ValidationEntityDef,
IdEntity {
    private static final long serialVersionUID = 7163743646559715384L;
    @Id
    private Long id;
    @ManyToOne
    @JoinColumn(name="naturezaSolicitacao", referencedColumnName="naturezaSolicitacao")
    private NaturezaSolicitacaoAlvaraEntity naturezaSolicitacao;
    @ManyToOne
    @JoinColumn(name="tipoInscricao", referencedColumnName="idTipoInscricaoAlvara")
    private TipoInscricaoAlvaraEntity tipoInscricao;
    @Column(nullable=false)
    @Type(type="org.hibernate.type.BooleanType")
    private boolean ativo = true;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean isNew() {
        return this.id == null;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaSolicitacao() {
        return this.naturezaSolicitacao;
    }

    public void setNaturezaSolicitacao(NaturezaSolicitacaoAlvaraEntity naturezaSolicitacao) {
        this.naturezaSolicitacao = naturezaSolicitacao;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricao() {
        return this.tipoInscricao;
    }

    public void setTipoInscricao(TipoInscricaoAlvaraEntity tipoInscricao) {
        this.tipoInscricao = tipoInscricao;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public void validar() throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (this.naturezaSolicitacao == null) {
            ve.adicionarMensagem("A Natureza da Solicita\u00e7\u00e3o \u00e9 obrigat\u00f3ria");
        }
        if (this.tipoInscricao == null) {
            ve.adicionarMensagem("O Tipo de Inscri\u00e7\u00e3o \u00e9 obrigat\u00f3rio");
        }
        ve.lancarException();
    }

    public boolean isPermiteAtivarInativar() {
        return !this.tipoInscricao.isMEI() || !this.naturezaSolicitacao.getCodigo().equalsIgnoreCase(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue());
    }
}

