/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.ValidationEntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@Entity(name="IndeferimentoRedeSim")
@Table(name="TRIBINDEFERIMENTOREDESIM")
public class IndeferimentoRedeSimEntity
implements ValidationEntityDef {
    private static final long serialVersionUID = 1L;
    private static final int TAMANHO_DESC_REDUZIDA = 110;
    @Id
    private Long codigo;
    private String descricao;
    private String ativo;
    @Transient
    private Boolean edicao;

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getAtivo() {
        return this.ativo;
    }

    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    public Boolean getEdicao() {
        return this.edicao;
    }

    public void setEdicao(Boolean edicao) {
        this.edicao = edicao;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndeferimentoRedeSimEntity that = (IndeferimentoRedeSimEntity)o;
        return Objects.equal((Object)this.codigo, (Object)that.codigo) && Objects.equal((Object)this.descricao, (Object)that.descricao);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.codigo, this.descricao});
    }

    public void validar() throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (this.codigo == null) {
            ve.adicionarMensagem("O c\u00f3digo \u00e9 obrigat\u00f3rio.");
        }
        if (EloStringUtils.isEmpty((String)this.descricao)) {
            ve.adicionarMensagem("A descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (EloStringUtils.isEmpty((String)this.ativo)) {
            ve.adicionarMensagem("O campo ativo n\u00e3o foi informado.");
        }
        if (this.descricao.length() > 350) {
            ve.adicionarMensagem("A descri\u00e7\u00e3o possui mais de 350 caracteres.");
        }
        ve.lancarException();
    }

    public String getDescricaoReduzida() {
        return StringUtils.abbreviate((String)(this.getCodigo().toString() + " - " + this.getDescricao()), (int)110);
    }

    public String getDescricaoBreakline() {
        StringBuilder descricaoBreakline = new StringBuilder();
        descricaoBreakline.append(this.getCodigo().toString() + " - ");
        String[] split = this.descricao.trim().split("\\s+");
        int size = descricaoBreakline.length();
        for (String word : split) {
            if (size + word.length() + 1 <= 110) {
                descricaoBreakline.append(" " + word);
                size += word.length() + 1;
                continue;
            }
            size = word.length();
            descricaoBreakline.append("<br/>" + word);
        }
        return descricaoBreakline.toString();
    }
}

