/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.ValidationEntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity(name="ExigenciaRedeSim")
@Table(name="TribexigenciaRedesim")
public class ExigenciaRedeSimEntity
implements ValidationEntityDef {
    private static final long serialVersionUID = 1L;
    private static final int TAMANHO_DESC_REDUZIDA = 110;
    @Id
    @GeneratedValue(generator="GEN_EXIGENCIAREDESIM", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="GEN_EXIGENCIAREDESIM", sequenceName="S40EXIGENCIAREDESIM")
    private Long idExigenciaRedeSim;
    private Long codigo;
    private String descricao;
    private String ativo;

    public Long getIdExigenciaRedeSim() {
        return this.idExigenciaRedeSim;
    }

    public void setIdExigenciaRedeSim(Long idExigenciaRedeSim) {
        this.idExigenciaRedeSim = idExigenciaRedeSim;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getAtivo() {
        return this.ativo;
    }

    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.idExigenciaRedeSim == null ? 0 : this.idExigenciaRedeSim.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExigenciaRedeSimEntity other = (ExigenciaRedeSimEntity)obj;
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        return !(this.idExigenciaRedeSim == null ? other.idExigenciaRedeSim != null : !this.idExigenciaRedeSim.equals(other.idExigenciaRedeSim));
    }

    public void validar() throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (this.codigo == null) {
            ve.adicionarMensagem("O c\u00f3digo \u00e9 obrigat\u00f3rio.");
        }
        if (EloStringUtils.isEmpty((String)this.descricao)) {
            ve.adicionarMensagem("A descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (EloStringUtils.isEmpty((String)this.ativo)) {
            ve.adicionarMensagem("O campo ativo n\u00e3o foi informado.");
        }
        ve.lancarException();
    }

    public String getDescricaoReduzida() {
        return StringUtils.abbreviate((String)(this.getCodigo().toString() + " - " + this.getDescricao()), (int)110);
    }

    public boolean isNovo() {
        return EloNumberUtils.isBiggerThanZero((Number)this.idExigenciaRedeSim) == false;
    }

    public String getDescricaoBreakline() {
        StringBuilder descricaoBreakline = new StringBuilder();
        descricaoBreakline.append(this.getCodigo().toString() + " - ");
        String[] split = this.descricao.trim().split("\\s+");
        int size = descricaoBreakline.length();
        for (String word : split) {
            if (size + word.length() + 1 <= 110) {
                descricaoBreakline.append(" " + word);
                size += word.length() + 1;
                continue;
            }
            size = word.length();
            descricaoBreakline.append("<br/>" + word);
        }
        return descricaoBreakline.toString();
    }
}

