/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.util.string.EloStringUtils;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity(name="eventoRedeSim")
@Table(name="TRIBEVENTOREDESIM")
public class EventoRedeSimEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    private Long evento;
    private String descricao;
    private String sigla;
    @Transient
    private Boolean edicao;

    public Boolean getEdicao() {
        return this.edicao;
    }

    public void setEdicao(Boolean edicao) {
        this.edicao = edicao;
    }

    public EventoRedeSimEntity() {
    }

    public EventoRedeSimEntity(Long evento) {
        this.evento = evento;
    }

    public Long getEvento() {
        return this.evento;
    }

    public void setEvento(Long evento) {
        this.evento = evento;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getSigla() {
        return this.sigla;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EventoRedeSimEntity [");
        if (this.evento != null) {
            builder.append("evento=");
            builder.append(this.evento);
            builder.append(", ");
        }
        if (this.descricao != null) {
            builder.append("descricao=");
            builder.append(this.descricao);
            builder.append(", ");
        }
        if (this.sigla != null) {
            builder.append("sigla=");
            builder.append(this.sigla);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.evento == null ? 0 : this.evento.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventoRedeSimEntity other = (EventoRedeSimEntity)obj;
        return !(this.evento == null ? other.evento != null : !this.evento.equals(other.evento));
    }

    public void validar() throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (this.evento == null) {
            ve.adicionarMensagem("O evento \u00e9 obrigat\u00f3rio.");
        }
        if (EloStringUtils.isEmpty((String)this.descricao)) {
            ve.adicionarMensagem("A descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (this.sigla.length() > 3) {
            ve.adicionarMensagem("O campo sigla n\u00e3o pode conter mais do que 3 caracteres.");
        }
        ve.lancarException();
    }
}

