/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity(name="ClassificacaoTipoInscricao")
@Table(name="tribclassificacaotipoinscricao")
public class ClassificacaoTipoInscricaoEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    public static final String TIPO_CLASSIFICACAO_RESIDENCIAL = "R";
    public static final String TIPO_CLASSIFICACAO_COMERCIAL = "C";
    @Id
    private Long idClassificacaoTipoInscricao;
    @OneToOne
    @JoinColumn(name="idsolicitacaoalvara")
    private SolicitacaoAlvaraEntity idSolicitacaoAlvara;
    private String pontoReferencia;
    private String tipoClassificacao;

    public ClassificacaoTipoInscricaoEntity() {
    }

    public ClassificacaoTipoInscricaoEntity(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.idSolicitacaoAlvara = solicitacaoAlvara;
    }

    public Long getIdClassificacaoTipoInscricao() {
        return this.idClassificacaoTipoInscricao;
    }

    public void setIdClassificacaoTipoInscricao(Long idClassificacaoTipoInscricao) {
        this.idClassificacaoTipoInscricao = idClassificacaoTipoInscricao;
    }

    public SolicitacaoAlvaraEntity getIdSolicitacaoAlvara() {
        return this.idSolicitacaoAlvara;
    }

    public void setIdSolicitacaoAlvara(SolicitacaoAlvaraEntity idSolicitacaoAlvara) {
        this.idSolicitacaoAlvara = idSolicitacaoAlvara;
    }

    public String getPontoReferencia() {
        return this.pontoReferencia;
    }

    public void setPontoReferencia(String pontoReferencia) {
        this.pontoReferencia = pontoReferencia;
    }

    public String getTipoClassificacao() {
        return this.tipoClassificacao;
    }

    public void setTipoClassificacao(String tipoClassificacao) {
        this.tipoClassificacao = tipoClassificacao;
    }

    public boolean isPontoRef() {
        return Objects.nonNull(this.pontoReferencia) && SimNaoEnum.SIM.getShortText().equals(this.pontoReferencia);
    }

    public boolean isClassificacaoResidencial() {
        return Objects.nonNull(this.tipoClassificacao) && this.tipoClassificacao.equals(TIPO_CLASSIFICACAO_RESIDENCIAL);
    }

    public boolean isClassificacaoComercial() {
        return Objects.nonNull(this.tipoClassificacao) && this.tipoClassificacao.equals(TIPO_CLASSIFICACAO_COMERCIAL);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.idClassificacaoTipoInscricao == null ? 0 : this.idClassificacaoTipoInscricao.hashCode());
        result = 31 * result + (this.idSolicitacaoAlvara == null ? 0 : this.idSolicitacaoAlvara.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassificacaoTipoInscricaoEntity other = (ClassificacaoTipoInscricaoEntity)obj;
        if (this.idClassificacaoTipoInscricao == null ? other.idClassificacaoTipoInscricao != null : !this.idClassificacaoTipoInscricao.equals(other.idClassificacaoTipoInscricao)) {
            return false;
        }
        return !(this.idSolicitacaoAlvara == null ? other.idSolicitacaoAlvara != null : !this.idSolicitacaoAlvara.equals(other.idSolicitacaoAlvara));
    }

    public boolean isPrestadorServico() {
        return SimNaoEnum.SIM.getShortText().equals(this.pontoReferencia);
    }
}

