/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.tributacao.domain.IdEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.math.EloNumberUtils;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity(name="AndamentoAlvaraProvisorio")
@Table(name="TribAndamentoAlvaraProvisorio")
public class AndamentoAlvaraProvisorioEntity
implements IdEntity {
    private static final long serialVersionUID = 1L;
    @Id
    private Long id;
    @ManyToOne
    @JoinColumn(name="idSolicitacaoRedeSim", referencedColumnName="id")
    private SolicitacaoRedeSimEntity solicitacaoRedeSim;
    @ManyToOne
    @JoinColumn(name="usuario", referencedColumnName="usuario")
    private UsuarioEntity usuario;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAndamento;
    private String gerouDebito;
    private String gerouAlvara;
    private String enviouAlvara;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoRedeSim() {
        return this.solicitacaoRedeSim;
    }

    public void setSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        this.solicitacaoRedeSim = solicitacaoRedeSim;
    }

    public UsuarioEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioEntity usuario) {
        this.usuario = usuario;
    }

    public Date getDataAndamento() {
        return this.dataAndamento;
    }

    public void setDataAndamento(Date dataAndamento) {
        this.dataAndamento = dataAndamento;
    }

    public String getGerouDebito() {
        return this.gerouDebito;
    }

    public void setGerouDebito(String gerouDebito) {
        this.gerouDebito = gerouDebito;
    }

    public String getGerouAlvara() {
        return this.gerouAlvara;
    }

    public void setGerouAlvara(String gerouAlvara) {
        this.gerouAlvara = gerouAlvara;
    }

    public String getEnviouAlvara() {
        return this.enviouAlvara;
    }

    public void setEnviouAlvara(String enviouAlvara) {
        this.enviouAlvara = enviouAlvara;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataAndamento == null ? 0 : this.dataAndamento.hashCode());
        result = 31 * result + (this.enviouAlvara == null ? 0 : this.enviouAlvara.hashCode());
        result = 31 * result + (this.gerouAlvara == null ? 0 : this.gerouAlvara.hashCode());
        result = 31 * result + (this.gerouDebito == null ? 0 : this.gerouDebito.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.solicitacaoRedeSim == null ? 0 : this.solicitacaoRedeSim.hashCode());
        result = 31 * result + (this.usuario == null ? 0 : this.usuario.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndamentoAlvaraProvisorioEntity other = (AndamentoAlvaraProvisorioEntity)obj;
        if (this.dataAndamento == null ? other.dataAndamento != null : !this.dataAndamento.equals(other.dataAndamento)) {
            return false;
        }
        if (this.enviouAlvara == null ? other.enviouAlvara != null : !this.enviouAlvara.equals(other.enviouAlvara)) {
            return false;
        }
        if (this.gerouAlvara == null ? other.gerouAlvara != null : !this.gerouAlvara.equals(other.gerouAlvara)) {
            return false;
        }
        if (this.gerouDebito == null ? other.gerouDebito != null : !this.gerouDebito.equals(other.gerouDebito)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.solicitacaoRedeSim == null ? other.solicitacaoRedeSim != null : !this.solicitacaoRedeSim.equals((Object)other.solicitacaoRedeSim)) {
            return false;
        }
        return !(this.usuario == null ? other.usuario != null : !this.usuario.equals((Object)other.usuario));
    }

    public Boolean isNew() {
        return EloNumberUtils.isBiggerThanZero((Number)this.getId()) == false;
    }

    public AndamentoAlvaraProvisorioEntity criarNovoAndamentoDebitoGerado() {
        AndamentoAlvaraProvisorioEntity novoAndamento = new AndamentoAlvaraProvisorioEntity();
        novoAndamento.setGerouDebito(SimNaoEnum.getSimShortText());
        novoAndamento.setGerouAlvara(this.getGerouAlvara());
        novoAndamento.setEnviouAlvara(this.getEnviouAlvara());
        novoAndamento.setSolicitacaoRedeSim(this.getSolicitacaoRedeSim());
        return novoAndamento;
    }

    public AndamentoAlvaraProvisorioEntity criarNovoAndamentoAlvaraGerado() {
        AndamentoAlvaraProvisorioEntity novoAndamento = new AndamentoAlvaraProvisorioEntity();
        novoAndamento.setGerouDebito(this.getGerouDebito());
        novoAndamento.setGerouAlvara(SimNaoEnum.getSimShortText());
        novoAndamento.setEnviouAlvara(this.getEnviouAlvara());
        novoAndamento.setSolicitacaoRedeSim(this.getSolicitacaoRedeSim());
        return novoAndamento;
    }

    public AndamentoAlvaraProvisorioEntity criarNovoAndamentoAlvaraEnviado() {
        AndamentoAlvaraProvisorioEntity novoAndamento = new AndamentoAlvaraProvisorioEntity();
        novoAndamento.setGerouDebito(this.getGerouDebito());
        novoAndamento.setGerouAlvara(this.getGerouAlvara());
        novoAndamento.setEnviouAlvara(SimNaoEnum.getSimShortText());
        novoAndamento.setSolicitacaoRedeSim(this.getSolicitacaoRedeSim());
        return novoAndamento;
    }
}

