/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryZoneamento;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.ZoneamentoEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryZoneamento")
public class DaoZoneamentoHibernate
extends DaoSequenciaHibernate<ZoneamentoPermitidoEntity, Long>
implements RepositoryZoneamento {
    private static final long serialVersionUID = 3133576522108237065L;

    public DaoZoneamentoHibernate() {
        super(ZoneamentoPermitidoEntity.class);
    }

    public List<ZoneamentoPermitidoEntity> carregarZoneamentosPermitidos(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ZoneamentoPermitidoEntity.class).add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)configuracaoAtividade));
        return this.findByCriteria(criteria);
    }

    public List<ZoneamentoEntity> carregarTodosZoneamentos() {
        return this.findByCriteriaAny(DetachedCriteria.forClass(ZoneamentoEntity.class));
    }

    public boolean zoneamentoNaoCadastrado(ZoneamentoPermitidoEntity zoneamentoPermitido) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ZoneamentoPermitidoEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)zoneamentoPermitido.getConfiguracaoAtividade()));
        criteria.add((Criterion)Restrictions.eq((String)"zoneamento", (Object)zoneamentoPermitido.getZoneamento()));
        return this.findByCriteriaUnique(criteria) == null;
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "zoneamentoPermitido");
    }
}

