/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.repository.RepositoryTipoInscricaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraGuiaEntity;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryTipoInscricaoAlvara")
public class DaoTipoInscricaoAlvaraHibernate
extends DaoSequenciaHibernate<TipoInscricaoAlvaraEntity, Long>
implements RepositoryTipoInscricaoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoTipoInscricaoAlvaraHibernate() {
        super(TipoInscricaoAlvaraEntity.class);
    }

    public TipoInscricaoAlvaraEntity getTipoInscricaoBySigla(String sigla) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoInscricaoAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"sigla", (Object)sigla));
        return (TipoInscricaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public List<TipoInscricaoAlvaraEntity> getMenus() {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoInscricaoAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.ne((String)"sigla", (Object)"MP"));
        criteria.addOrder(Order.asc((String)"tipoInscricaoAlvara"));
        return this.findByCriteria(criteria);
    }

    public List<TipoInscricaoAlvaraEntity> getTipoInscricaoAtivo() {
        String hql = "select distinct ti    from NaturezaSolicitacaoTipoInscricaoAlvara nsti  join nsti.tipoInscricao ti  where nsti.ativo = ? ";
        return this.findAnyByHql(hql, new Object[]{Boolean.TRUE});
    }

    public TipoInscricaoAlvaraGuiaEntity carregaTipoInscricaoAlvaraGuiaBySigla(String sigla, Long exercicio) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoInscricaoAlvaraGuiaEntity.class);
        criteria.createAlias("idTipoInscricaoAlvara", "tipoInscricaoAlvara");
        criteria.add((Criterion)Restrictions.eq((String)"tipoInscricaoAlvara.sigla", (Object)sigla));
        criteria.add((Criterion)Restrictions.eq((String)"guiaRecolhimento.id.entidadeTributacao.id.exercicioTributacao.exercicio", (Object)exercicio));
        return (TipoInscricaoAlvaraGuiaEntity)this.findByCriteriaUniqueAny(criteria);
    }
}

