/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryRestricaoAlvara")
public class DaoRestricaoAlvaraHibernate
extends DaoSequenciaHibernate<RestricaoAlvaraEntity, Long>
implements RepositoryRestricaoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoRestricaoAlvaraHibernate() {
        super(RestricaoAlvaraEntity.class);
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "restricaoalvara");
    }

    public Long getRestricao(Long entidade, Long exercicio) {
        return super.getSequence(Modulo.ALVARAONLINE, "restricaoalvara_" + entidade + "_" + exercicio);
    }

    public List<RestricaoAlvaraEntity> carregaRestricaoPorSolicitacao(Long idSolicitacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)idSolicitacao));
        return this.findByCriteria(criteria);
    }

    public boolean verificarLiberacaoSolicitacao(Long idSolicitacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)idSolicitacao));
        List restricoes = this.findByCriteria(criteria);
        if (restricoes == null || restricoes.isEmpty()) {
            return false;
        }
        boolean liberado = true;
        for (RestricaoAlvaraEntity restricao : restricoes) {
            if (!restricao.isBloqueante()) continue;
            if (restricao.isRestricaoAutorizada()) {
                liberado = true;
                continue;
            }
            liberado = false;
            break;
        }
        return liberado;
    }

    public List<RestricaoAlvaraEntity> carregaRestricaoParaLiberacao(Long idSolicitacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)idSolicitacao));
        return this.findByCriteria(criteria);
    }

    public boolean verificarLiberacaoSolicitacaoByCadRestricao(Long idSolicitacao, Long idCadRestricao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)idSolicitacao)).add((Criterion)Restrictions.eq((String)"cadastroRestricaoAlvara.idRestricao", (Object)idCadRestricao));
        RestricaoAlvaraEntity restricao = (RestricaoAlvaraEntity)this.findByCriteriaUnique(criteria);
        if (restricao == null) {
            return false;
        }
        boolean liberado = true;
        if (restricao.isBloqueante()) {
            liberado = restricao.isRestricaoAutorizada();
        }
        return liberado;
    }

    public RestricaoAlvaraEntity carregaRestricaoBySolicitacaoCadRestricao(Long solicitacao, Long cadastroRestricao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)solicitacao)).add((Criterion)Restrictions.eq((String)"cadastroRestricaoAlvara.idRestricao", (Object)cadastroRestricao));
        return (RestricaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public boolean possuiRestricaoDeResponsavelTecnicoBloqueante(Long idSolicitacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(RestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"solicitacaoAlvara.solicitacaoAlvara", (Object)idSolicitacao)).add((Criterion)Restrictions.eq((String)"autorizado", (Object)SimNaoEnum.NAO.getShortText()));
        criteria.createAlias("cadastroRestricaoAlvara", "c").add((Criterion)Restrictions.eq((String)"c.responsavelTecnico", (Object)SimNaoEnum.SIM.getShortText()));
        List restricoes = this.findByCriteria(criteria);
        return !restricoes.isEmpty();
    }
}

