/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoRelatorioSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioSolicitacaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryRelatorioSolicitacaoAlvara")
public class DaoRelatorioSolicitacaoAlvaraHibernate
extends DaoSequenciaHibernate<SolicitacaoAlvaraEntity, Long>
implements DaoRelatorioSolicitacaoAlvara,
RepositoryRelatorioSolicitacaoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoRelatorioSolicitacaoAlvaraHibernate() {
        super(SolicitacaoAlvaraEntity.class);
    }

    public List<SolicitacaoAlvaraEntity> carregaListaSolicitacoes(FiltroRelatorioSolicitacoesVo filtro) {
        StringBuilder hql = new StringBuilder();
        hql.append("select distinct s");
        hql.append(" from SolicitacaoAlvara s ");
        hql.append(" left join s.cadastroMobiliario cadMob ");
        hql.append(" left join s.cadastroImobiliario cadImob ");
        hql.append(" left join s.solicitacaoAlvaraAtividades saa ");
        hql.append(" left join cadImob.cadastroGeral.bairro bairro ");
        hql.append(" left join cadImob.cadastroGeral.logradouro logradouro  ");
        hql.append(this.montaCondicao(filtro));
        hql.append(" order by s.exercicio asc, s.numeroSolicitacao asc");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        List solicitacoes = query.list();
        for (SolicitacaoAlvaraEntity s : solicitacoes) {
            Hibernate.initialize((Object)s.getNaturezas());
            Hibernate.initialize((Object)s.getSolicitacaoAlvaraAtividades());
            Hibernate.initialize((Object)s.getCadastroImobiliario());
            if (s.getCadastroMobiliario() != null && s.getCadastroMobiliario().getId() != null) {
                Hibernate.initialize((Object)s.getCadastroMobiliario().getMobiliarioCnaes());
                Hibernate.initialize((Object)s.getCadastroMobiliario().getMobiliarioAtividadeMeis());
                Hibernate.initialize((Object)s.getCadastroMobiliario().getMobiliarioCbos());
            }
            for (SolicitacaoAlvaraAtividadeEntity sa : s.getSolicitacaoAlvaraAtividades()) {
                Hibernate.initialize((Object)sa.getNumerosConselho());
            }
        }
        return solicitacoes;
    }

    private String montaCondicao(FiltroRelatorioSolicitacoesVo filtro) {
        StringBuilder condicao = new StringBuilder();
        this.montarFiltroTipoInscricao(filtro, condicao);
        this.montarFiltroTipoRelatorio(filtro, condicao);
        this.montarFiltroNumeroSolicitacaoExercicio(filtro, condicao);
        this.montarFiltroCpfCnpjResponsavel(filtro, condicao);
        this.montarFiltroCpfCnpjMobiliario(filtro, condicao);
        this.montarFiltroCadastroImobiliario(filtro, condicao);
        this.montarFiltroPeriodo(filtro, condicao);
        this.montarFiltroCnae(filtro, condicao);
        this.montarFiltroEndereco(filtro, condicao);
        this.montarFiltroZonaQuadraLote(filtro, condicao);
        this.montarFiltroConcluidas(filtro, condicao);
        this.montarFiltroDocumentosEmitidos(filtro, condicao);
        this.montarFiltroProtocoloRedeSim(filtro, condicao);
        return condicao.toString();
    }

    private void montarFiltroProtocoloRedeSim(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getProtocoloRedeSim())) {
            condicao.append(" and s.protocoloRedeSim = '").append(filtro.getProtocoloRedeSim()).append("' ");
        }
    }

    private void montarFiltroDocumentosEmitidos(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (filtro.getDocumentosEmitidos() != null) {
            condicao.append(" and s.numeroAlvara is ");
            condicao.append(filtro.getDocumentosEmitidos() != false ? " not null " : " null ");
        }
    }

    private void montarFiltroConcluidas(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (filtro.getConcluidas() != null) {
            if (filtro.getConcluidas().booleanValue()) {
                condicao.append(" and not exists (select 1 from SolicitacaoAlvaraDocumento doc where doc.solicitacaoAlvara = s and doc.situacao != '");
                condicao.append(SituacaoDocumentoAlvaraEnum.VALIDADO.name()).append("') ");
                condicao.append(" and not exists (select 1 from LaudoAlvara laudo where laudo.idSolicitacaoAlvara = s ");
                condicao.append("                                                   and laudo.status not in ('").append(StatusLaudoAlvara.LIBERADO_PROVISORIO.getCodigo()).append("', '").append(StatusLaudoAlvara.LIBERADO_DEFINITIVO.getCodigo()).append("')) ");
            } else {
                condicao.append(" and (exists (select 1 from SolicitacaoAlvaraDocumento doc where doc.solicitacaoAlvara = s and doc.situacao != '");
                condicao.append(SituacaoDocumentoAlvaraEnum.VALIDADO.name()).append("') ");
                condicao.append(" or exists (select 1 from LaudoAlvara laudo where laudo.idSolicitacaoAlvara = s ");
                condicao.append("                                                   and laudo.status not in ('").append(StatusLaudoAlvara.LIBERADO_PROVISORIO.getCodigo()).append("', '").append(StatusLaudoAlvara.LIBERADO_DEFINITIVO.getCodigo()).append("'))) ");
            }
        }
    }

    private void montarFiltroTipoInscricao(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        String tipoInscricao = filtro.getTipoInscricao().getSigla().equals("M") ? "(3,5)" : "(" + filtro.getTipoInscricao().getIdTipoInscricaoAlvara().toString() + ")";
        condicao.append(" where s.tipoDeInscricao in ").append(tipoInscricao);
    }

    private void montarFiltroTipoRelatorio(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (filtro.isConsultaPrevia()) {
            condicao.append(" and (s.finalizado is null or s.finalizado = 'N') ");
        } else {
            condicao.append(" and s.finalizado = 'S' ");
        }
    }

    private void montarFiltroNumeroSolicitacaoExercicio(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getNumeroSolicitacao())) {
            String[] consulta = filtro.getNumeroSolicitacao().split("/");
            Long numeroSolicitacao = Long.valueOf(consulta[0]);
            Long exercicio = Long.valueOf(consulta[1]);
            condicao.append(" and s.numeroSolicitacao = ").append(numeroSolicitacao);
            condicao.append(" and s.exercicio = ").append(exercicio);
        }
    }

    private void montarFiltroCpfCnpjResponsavel(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCpfCnpjResponsavel())) {
            condicao.append(" and s.cpfCnpjConsulta = '").append(filtro.getCpfCnpjResponsavel()).append("'");
        }
    }

    private void montarFiltroCpfCnpjMobiliario(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCpfCnpjMobiliario())) {
            condicao.append(" and s.cpfCnpj = '").append(filtro.getCpfCnpjMobiliario()).append("'");
        }
    }

    private void montarFiltroCadastroImobiliario(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCadastroImobiliario())) {
            condicao.append(" and cadImob.id.codigo = '").append(filtro.getCadastroImobiliario()).append("'");
        }
    }

    private void montarFiltroPeriodo(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        String nomeColunaData;
        String string = nomeColunaData = filtro.isConsultaPrevia() ? "dataConsultaPrevia" : "dataSolicitacao";
        if (filtro.getPeriodoInicial() != null && filtro.getPeriodoFinal() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy 23:59:59");
            condicao.append(" and s.").append(nomeColunaData).append(" between ").append(" to_timestamp('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoInicial())).append("', 'dd/MM/yyyy HH24:MI:SS')").append(" and ").append(" to_timestamp('").append(sdf.format(filtro.getPeriodoFinal())).append("', 'dd/MM/yyyy HH24:MI:SS')");
        } else if (filtro.getPeriodoInicial() != null) {
            condicao.append(" and s.").append(nomeColunaData).append(" >= to_timestamp('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoInicial())).append("', 'dd/MM/yyyy')");
        } else if (filtro.getPeriodoFinal() != null) {
            condicao.append(" and s.").append(nomeColunaData).append(" <= to_timestamp('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoFinal())).append("', 'dd/MM/yyyy')");
        }
    }

    private void montarFiltroCnae(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCodigoAtividade())) {
            condicao.append(" and ").append(filtro.getCodigoAtividade().trim()).append(" = saa.cnae.codigo ");
        }
        if (filtro.getAtividadeSelecionada() != null) {
            condicao.append(" and ").append(filtro.getAtividadeSelecionada().getCodigo()).append(" = saa.cnae.codigo ");
        }
    }

    private void montarFiltroEndereco(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCodigoEndereco())) {
            condicao.append(" and logradouro.id.logradouro = ").append(filtro.getCodigoEndereco().trim());
        }
        if (filtro.getEndereco() != null) {
            condicao.append(" and logradouro.id.logradouro = ").append(filtro.getEndereco().getId().getLogradouro());
        }
    }

    private void montarFiltroZonaQuadraLote(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getZona())) {
            condicao.append(" and cadImob.setorDescr = '").append(filtro.getZona().trim()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getQuadra())) {
            condicao.append(" and cadImob.quadraDescr = '").append(filtro.getQuadra().trim()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getLote())) {
            condicao.append(" and cadImob.loteDescr = '").append(filtro.getLote().trim()).append("'");
        }
    }
}

