/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.domain.vo.QuantidadeConsultaSolicitacaoVo;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioQuantidadeConsultaSolicitacao;
import br.com.elotech.util.sql.EloSqlUtils;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryRelatorioQuantidadeConsultaSolicitacao")
public class DaoRelatorioQuantidadeConsultaSolicitacaoHibernate
implements RepositoryRelatorioQuantidadeConsultaSolicitacao {
    private static final long serialVersionUID = 1L;

    public List<QuantidadeConsultaSolicitacaoVo> carregaListaQuantidade(FiltroRelatorioSolicitacoesVo filtro) {
        Query query = EloSqlUtils.createQuery((String)this.getSqlConsulta(filtro));
        query.setParameter("periodoInicial", (Object)filtro.getPeriodoInicial());
        query.setParameter("periodoFinal", (Object)filtro.getPeriodoFinal());
        return query.list();
    }

    private String getSqlConsulta(FiltroRelatorioSolicitacoesVo filtro) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT new br.com.elotech.portalarrecadacao.domain.vo.QuantidadeConsultaSolicitacaoVo(");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NULL ");
        sb.append(" THEN EXTRACT(MONTH FROM sol.dataConsultaPrevia) ");
        sb.append(" ELSE EXTRACT(MONTH FROM sol.dataSolicitacao) ");
        sb.append(" END AS mes, ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NULL ");
        sb.append(" THEN EXTRACT(YEAR FROM sol.dataConsultaPrevia) ");
        sb.append(" ELSE EXTRACT(YEAR FROM sol.dataSolicitacao) ");
        sb.append(" END AS ano, ");
        sb.append(" SUM( ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NULL ");
        sb.append(" THEN 1 ");
        sb.append(" ELSE 0 ");
        sb.append(" END ) AS consultaPrevia, ");
        sb.append(" SUM( ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NOT NULL ");
        sb.append(" THEN 1 ");
        sb.append(" ELSE 0 ");
        sb.append(" END ) AS solicitacao, ");
        sb.append(" SUM( ");
        sb.append(" CASE ");
        sb.append(" WHEN (sol.dataSolicitacao IS NOT NULL ");
        sb.append(" AND sol.grauRisco = 'A') ");
        sb.append(" THEN 1 ");
        sb.append(" ELSE 0 ");
        sb.append(" END ) AS riscoA, ");
        sb.append(" SUM( ");
        sb.append(" CASE ");
        sb.append(" WHEN (sol.dataSolicitacao IS NOT NULL ");
        sb.append(" AND sol.grauRisco = 'C') ");
        sb.append(" THEN 1 ");
        sb.append(" ELSE 0 ");
        sb.append(" END ) AS riscoC, ");
        sb.append(" SUM( ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.numeroAlvara IS NOT NULL ");
        sb.append(" THEN 1 ");
        sb.append(" ELSE 0 ");
        sb.append(" END ) AS alvaraEmitido ) ");
        sb.append(" FROM SolicitacaoAlvara sol ");
        sb.append(" WHERE ");
        sb.append(this.montarFiltroTipoInscricao(filtro));
        sb.append(" and (trunc(sol.dataSolicitacao) BETWEEN :periodoInicial AND :periodoFinal ");
        sb.append(" OR trunc(sol.dataConsultaPrevia) BETWEEN :periodoInicial AND :periodoFinal) ");
        sb.append(" GROUP BY ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NULL ");
        sb.append(" THEN EXTRACT(MONTH FROM sol.dataConsultaPrevia) ");
        sb.append(" ELSE EXTRACT(MONTH FROM sol.dataSolicitacao) ");
        sb.append(" END, ");
        sb.append(" CASE ");
        sb.append(" WHEN sol.dataSolicitacao IS NULL ");
        sb.append(" THEN EXTRACT(YEAR FROM sol.dataConsultaPrevia) ");
        sb.append(" ELSE EXTRACT(YEAR FROM sol.dataSolicitacao) ");
        sb.append(" END ");
        sb.append(" ORDER BY ano asc, mes asc");
        return sb.toString();
    }

    private String montarFiltroTipoInscricao(FiltroRelatorioSolicitacoesVo filtro) {
        String tipoInscricao = filtro.getTipoInscricao().getSigla().equals("M") ? "(3,5)" : "(" + filtro.getTipoInscricao().getIdTipoInscricaoAlvara().toString() + ")";
        return " sol.tipoDeInscricao in " + tipoInscricao;
    }
}

