/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoRelatorioLaudo;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.exception.RelatorioException;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioLaudo;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryRelatorioLaudo")
public class DaoRelatorioLaudoHibernate
extends DaoSequenciaHibernate<LaudoAlvaraEntity, Long>
implements DaoRelatorioLaudo,
RepositoryRelatorioLaudo {
    private static final long serialVersionUID = 1L;

    public DaoRelatorioLaudoHibernate() {
        super(LaudoAlvaraEntity.class);
    }

    public List<LaudoAlvaraEntity> carregaListaLaudos(FiltroRelatorioLaudoVo filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoAlvaraEntity.class);
        criteria.createAlias("idSolicitacaoAlvara", "s");
        criteria.createAlias("tipoLaudo", "tl");
        this.montaCondicao(filtro, criteria);
        criteria.addOrder(Order.desc((String)"s.exercicio"));
        criteria.addOrder(Order.desc((String)"s.numeroSolicitacao"));
        return this.findByCriteria(criteria);
    }

    private void montaCondicao(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        this.montarFiltroPeriodo(filtro, criteria);
        this.montarFiltroSituacao(filtro, criteria);
        this.montarFiltroNumeroSolicitacaoExercicio(filtro, criteria);
        this.montarFiltroPeriodoValidade(filtro, criteria);
        this.montarFiltroTipoLaudo(filtro, criteria);
        this.montarFiltroProtocoloRedeSim(filtro, criteria);
    }

    private void montarFiltroProtocoloRedeSim(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (!EloStringUtils.isEmpty((String)filtro.getProtocoloRedeSim())) {
            criteria.add((Criterion)Restrictions.eq((String)"s.protocoloRedeSim", (Object)filtro.getProtocoloRedeSim()));
        }
    }

    private void montarFiltroPeriodo(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (filtro.getPeriodoInicial() != null && filtro.getPeriodoFinal() != null) {
            criteria.add(Restrictions.between((String)"s.dataSolicitacao", (Object)filtro.getPeriodoInicial(), (Object)filtro.getPeriodoFinal()));
        }
    }

    private void montarFiltroNumeroSolicitacaoExercicio(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (!EloStringUtils.isEmpty((String)filtro.getNumeroSolicitacao())) {
            String[] consulta = filtro.getNumeroSolicitacao().split("/");
            Long numeroSolicitacao = Long.valueOf(consulta[0]);
            Long exercicio = Long.valueOf(consulta[1]);
            criteria.add((Criterion)Restrictions.eq((String)"s.numeroSolicitacao", (Object)numeroSolicitacao));
            criteria.add((Criterion)Restrictions.eq((String)"s.exercicio", (Object)exercicio));
        }
    }

    private void montarFiltroSituacao(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (filtro.getSituacaoLaudo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"status", (Object)filtro.getSituacaoLaudo()));
        }
    }

    private void montarFiltroPeriodoValidade(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (filtro.getValidadeInicial() != null && filtro.getValidadeFinal() != null) {
            criteria.add(Restrictions.between((String)"dataValidade", (Object)filtro.getValidadeInicial(), (Object)filtro.getValidadeFinal()));
        } else if (filtro.getValidadeInicial() != null) {
            criteria.add((Criterion)Restrictions.ge((String)"dataValidade", (Object)filtro.getValidadeInicial()));
        } else if (filtro.getValidadeFinal() != null) {
            criteria.add((Criterion)Restrictions.le((String)"dataValidade", (Object)filtro.getValidadeFinal()));
        }
    }

    private void montarFiltroTipoLaudo(FiltroRelatorioLaudoVo filtro, DetachedCriteria criteria) {
        if (filtro.getTipoLaudo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"tl.codigo", (Object)filtro.getTipoLaudo()));
        }
    }

    public List<LaudoAlvaraEntity> carregarLaudosVencidos(FiltroRelatorioLaudoVo filtro) throws RelatorioException {
        if (filtro == null) {
            throw new RelatorioException();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoAlvaraEntity.class);
        if (!EloListUtils.safeIsEmpty((List)filtro.getTiposInscricao()).booleanValue()) {
            criteria.createAlias("idSolicitacaoAlvara", "solicitacao");
            criteria.add(Restrictions.in((String)"solicitacao.tipoDeInscricao", (Collection)filtro.getTiposInscricao()));
        }
        if (!EloListUtils.safeIsEmpty((List)filtro.getTiposLaudo()).booleanValue()) {
            criteria.add(Restrictions.in((String)"tipoLaudo", (Collection)filtro.getTiposLaudo()));
        }
        if (filtro.getValidadeFinal() != null) {
            criteria.add((Criterion)Restrictions.le((String)"dataValidade", (Object)filtro.getValidadeFinal()));
        }
        criteria.addOrder(Order.asc((String)"dataValidade"));
        return this.findByCriteria(criteria);
    }
}

