/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoRelatorioSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioAlvarasEmitidos;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Date;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryRelatorioAlvarasEmitidos")
public class DaoRelatorioAlvarasEmitidosHibernate
extends DaoSequenciaHibernate<SolicitacaoAlvaraEntity, Long>
implements DaoRelatorioSolicitacaoAlvara,
RepositoryRelatorioAlvarasEmitidos {
    private static final long serialVersionUID = 1L;

    public DaoRelatorioAlvarasEmitidosHibernate() {
        super(SolicitacaoAlvaraEntity.class);
    }

    public List<SolicitacaoAlvaraEntity> carregaListaAlvarasEmitidos(FiltroRelatorioSolicitacoesVo filtro) {
        StringBuilder hql = new StringBuilder();
        hql.append("select distinct s");
        hql.append(" from SolicitacaoAlvara s ");
        hql.append(" left join s.cadastroMobiliario cadMob ");
        hql.append(" left join s.cadastroImobiliario cadImob ");
        hql.append(" left join s.solicitacaoAlvaraAtividades saa ");
        hql.append(" left join cadImob.cadastroGeral.bairro bairro ");
        hql.append(" left join cadImob.cadastroGeral.logradouro logradouro  ");
        hql.append(this.montaCondicao(filtro));
        hql.append(" order by s.exercicio asc, s.numeroSolicitacao asc");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        List solicitacoes = query.list();
        for (SolicitacaoAlvaraEntity s : solicitacoes) {
            Hibernate.initialize((Object)s.getNaturezas());
            Hibernate.initialize((Object)s.getSolicitacaoAlvaraAtividades());
            for (SolicitacaoAlvaraAtividadeEntity sa : s.getSolicitacaoAlvaraAtividades()) {
                Hibernate.initialize((Object)sa.getNumerosConselho());
            }
        }
        return solicitacoes;
    }

    private String montaCondicao(FiltroRelatorioSolicitacoesVo filtro) {
        StringBuilder condicao = new StringBuilder();
        condicao.append(" where s.numeroAlvara is not null ");
        this.montarFiltroTipoInscricao(filtro, condicao);
        this.montarFiltroCpfCnpjResponsavel(filtro, condicao);
        this.montarFiltroCadastroMobiliario(filtro, condicao);
        this.montarFiltroCpfCnpjMobiliario(filtro, condicao);
        this.montarFiltroCadastroImobiliario(filtro, condicao);
        this.montarFiltroPeriodo(filtro, condicao);
        this.montarFiltroDataExpedicao(filtro, condicao);
        this.montarFiltroGrauRisco(filtro, condicao);
        this.montarFiltroCnae(filtro, condicao);
        this.montarFiltroEndereco(filtro, condicao);
        this.montarFiltroZonaQuadraLote(filtro, condicao);
        return condicao.toString();
    }

    private void montarFiltroDataExpedicao(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        String nomeColunaData = "cadMob.dataAlvara";
        if (filtro.getInicioDataExpedicao() != null && filtro.getFimDataExpedicao() != null) {
            condicao.append(" and ").append(nomeColunaData).append(" between ").append(" to_date('").append(EloDateUtils.toDateString((Date)filtro.getInicioDataExpedicao())).append("', 'dd/MM/yyyy')").append(" and ").append(" to_date('").append(EloDateUtils.toDateString((Date)filtro.getFimDataExpedicao())).append("', 'dd/MM/yyyy')");
        } else if (filtro.getInicioDataExpedicao() != null) {
            condicao.append(" and ").append(nomeColunaData).append(" >= to_date('").append(EloDateUtils.toDateString((Date)filtro.getInicioDataExpedicao())).append("', 'dd/MM/yyyy')");
        } else if (filtro.getFimDataExpedicao() != null) {
            condicao.append(" and ").append(nomeColunaData).append(" <= to_date('").append(EloDateUtils.toDateString((Date)filtro.getFimDataExpedicao())).append("', 'dd/MM/yyyy')");
        }
    }

    private void montarFiltroCadastroMobiliario(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCadastroMobiliario())) {
            condicao.append(" and cadMob.id.codigo = '").append(filtro.getCadastroMobiliario()).append("'");
        }
    }

    private void montarFiltroTipoInscricao(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (filtro.getTipoInscricao() != null) {
            String tipoInscricao = "M".equals(filtro.getTipoInscricao().getSigla()) ? "(3,5)" : "(" + filtro.getTipoInscricao().getIdTipoInscricaoAlvara().toString() + ")";
            condicao.append(" and s.tipoDeInscricao in ").append(tipoInscricao);
        }
    }

    private void montarFiltroCpfCnpjResponsavel(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCpfCnpjResponsavel())) {
            condicao.append(" and s.cpfCnpjConsulta = '").append(filtro.getCpfCnpjResponsavel()).append("'");
        }
    }

    private void montarFiltroCpfCnpjMobiliario(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCpfCnpjMobiliario())) {
            condicao.append(" and s.cpfCnpj = '").append(filtro.getCpfCnpjMobiliario()).append("'");
        }
    }

    private void montarFiltroCadastroImobiliario(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCadastroImobiliario())) {
            condicao.append(" and cadImob.id.codigo = '").append(filtro.getCadastroImobiliario()).append("'");
        }
    }

    private void montarFiltroPeriodo(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        String nomeColunaData = "dataSolicitacao";
        if (filtro.getPeriodoInicial() != null && filtro.getPeriodoFinal() != null) {
            condicao.append(" and s.").append(nomeColunaData).append(" between ").append(" to_date('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoInicial())).append("', 'dd/MM/yyyy')").append(" and ").append(" to_date('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoFinal())).append("', 'dd/MM/yyyy')");
        } else if (filtro.getPeriodoInicial() != null) {
            condicao.append(" and s.").append(nomeColunaData).append(" >= to_date('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoInicial())).append("', 'dd/MM/yyyy')");
        } else if (filtro.getPeriodoFinal() != null) {
            condicao.append(" and s.").append(nomeColunaData).append(" <= to_date('").append(EloDateUtils.toDateString((Date)filtro.getPeriodoFinal())).append("', 'dd/MM/yyyy')");
        }
    }

    private void montarFiltroGrauRisco(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getGrauRisco())) {
            condicao.append(" and s.grauRisco = '").append(filtro.getGrauRisco().trim()).append("'");
        }
    }

    private void montarFiltroCnae(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCodigoAtividade())) {
            condicao.append(" and ").append(filtro.getCodigoAtividade().trim()).append(" = saa.cnae.codigo ");
        }
        if (filtro.getAtividadeSelecionada() != null) {
            condicao.append(" and ").append(filtro.getAtividadeSelecionada().getCodigo()).append(" = saa.cnae.codigo ");
        }
    }

    private void montarFiltroEndereco(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getCodigoEndereco())) {
            condicao.append(" and logradouro.id.logradouro = ").append(filtro.getCodigoEndereco().trim());
        }
        if (filtro.getEndereco() != null) {
            condicao.append(" and logradouro.id.logradouro = ").append(filtro.getEndereco().getId().getLogradouro());
        }
    }

    private void montarFiltroZonaQuadraLote(FiltroRelatorioSolicitacoesVo filtro, StringBuilder condicao) {
        if (!EloStringUtils.isEmpty((String)filtro.getZona())) {
            condicao.append(" and cadImob.setorDescr = '").append(filtro.getZona().trim()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getQuadra())) {
            condicao.append(" and cadImob.quadraDescr = '").append(filtro.getQuadra().trim()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getLote())) {
            condicao.append(" and cadImob.loteDescr = '").append(filtro.getLote().trim()).append("'");
        }
    }
}

