/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadePK;
import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryProibicaoAtividade;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryProibicao")
public class DaoProibicaoHibernate
extends DaoSequenciaHibernate<ProibicaoAtividadeEntity, ProibicaoAtividadePK>
implements RepositoryProibicaoAtividade {
    private static final long serialVersionUID = -8153096470873396444L;

    public DaoProibicaoHibernate() {
        super(ProibicaoAtividadeEntity.class);
    }

    public List<ProibicaoEntity> carregarProibicoesAtivas() {
        DetachedCriteria criteria = DetachedCriteria.forClass(ProibicaoEntity.class).add((Criterion)Restrictions.eq((String)"ativo", (Object)SimNaoEnum.SIM.getShortText())).addOrder(Order.asc((String)"descricao"));
        return this.findByCriteriaAny(criteria);
    }

    public List<ProibicaoAtividadeEntity> carregarProibicoesAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ProibicaoAtividadeEntity.class).add((Criterion)Restrictions.eq((String)"id.configuracaoAtividade", (Object)configuracaoAtividade));
        return this.findByCriteria(criteria);
    }

    public boolean proibicaoNaoCadastrada(ProibicaoAtividadeEntity proibicaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ProibicaoAtividadeEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"id.configuracaoAtividade", (Object)proibicaoAtividade.getId().getConfiguracaoAtividade()));
        criteria.add((Criterion)Restrictions.eq((String)"id.proibicao", (Object)proibicaoAtividade.getId().getProibicao()));
        return this.findByCriteriaUnique(criteria) == null;
    }
}

