/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.daoLayer.hibernate.DaoHibernate;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvaraNatureza;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryParametroAlvaraNatureza")
public class DaoParametroAlvaraNaturezaHibernate
extends DaoHibernate<ParametroAlvaraNaturezaEntity, Long>
implements RepositoryParametroAlvaraNatureza {
    private static final long serialVersionUID = 1L;

    public DaoParametroAlvaraNaturezaHibernate() {
        super(ParametroAlvaraNaturezaEntity.class);
    }

    public ParametroAlvaraNaturezaEntity getParametroAlvaraNatureza(NaturezaSolicitacaoAlvaraEntity natureza, ParametroAlvaraNaturezaEnum param, TipoInscricaoAlvaraEntity tipoInscricao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ParametroAlvaraNaturezaEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"naturezaSolicitacao.naturezaSolicitacao", (Object)natureza.getNaturezaSolicitacao()));
        criteria.add((Criterion)Restrictions.eq((String)"tipoInscricao.idTipoInscricaoAlvara", (Object)tipoInscricao.getIdTipoInscricaoAlvara()));
        criteria.add((Criterion)Restrictions.eq((String)"parametro", (Object)param));
        return (ParametroAlvaraNaturezaEntity)this.findByCriteriaUnique(criteria);
    }

    public List<ParametroAlvaraNaturezaEntity> getParametrosAlvaraNatureza(SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraNaturezaEnum param) {
        ArrayList<ParametroAlvaraNaturezaEntity> parametros = new ArrayList<ParametroAlvaraNaturezaEntity>();
        for (NaturezaSolicitacaoAlvaraEntity natureza : solicitacao.getNaturezas()) {
            DetachedCriteria criteria = DetachedCriteria.forClass(ParametroAlvaraNaturezaEntity.class);
            criteria.add((Criterion)Restrictions.eq((String)"naturezaSolicitacao.naturezaSolicitacao", (Object)natureza.getNaturezaSolicitacao()));
            criteria.add((Criterion)Restrictions.eq((String)"tipoInscricao.idTipoInscricaoAlvara", (Object)solicitacao.getTipoDeInscricao().getIdTipoInscricaoAlvara()));
            criteria.add((Criterion)Restrictions.eq((String)"parametro", (Object)param));
            ParametroAlvaraNaturezaEntity resultado = (ParametroAlvaraNaturezaEntity)this.findByCriteriaUnique(criteria);
            if (resultado == null) continue;
            parametros.add(resultado);
        }
        return parametros;
    }
}

