/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoExigido;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryLaudoExigido")
public class DaoLaudoExigidoHibernate
extends DaoSequenciaHibernate<LaudoExigidoEntity, Long>
implements RepositoryLaudoExigido {
    private static final long serialVersionUID = -8003893357757763331L;

    public DaoLaudoExigidoHibernate() {
        super(LaudoExigidoEntity.class);
    }

    public List<LaudoExigidoEntity> getLaudoPorAtividade(List<SolicitacaoAlvaraAtividadeEntity> listaAtividade) throws AtividadeNaoConfiguradaException {
        ArrayList<LaudoExigidoEntity> lista = new ArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : listaAtividade) {
            ConfiguracaoAtividadeEntity configuracaoAtividade = atividade.getConfiguracaoAtividade();
            StringBuilder query = new StringBuilder();
            query.append("Select l FROM LaudoExigido l ");
            query.append(" WHERE l.configuracaoAtividade.idConfiguracaoAtividade = ");
            query.append(configuracaoAtividade.getIdConfiguracaoAtividade());
            lista.addAll(this.findByHql(query.toString()));
        }
        lista = this.removeRepetidos(lista, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return lista;
    }

    public List<LaudoExigidoEntity> removeRepetidos(List<LaudoExigidoEntity> laudos, Comparator<LaudoExigidoEntity> comparator) {
        TreeSet<LaudoExigidoEntity> t = new TreeSet<LaudoExigidoEntity>(comparator);
        t.addAll(laudos);
        LinkedList<LaudoExigidoEntity> laudosClone = new LinkedList<LaudoExigidoEntity>(t);
        return laudosClone;
    }

    public List<LaudoExigidoEntity> carregarLaudosExigidosPorConfiguracaoAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade == null) {
            throw new IllegalArgumentException("Configura\u00e7\u00e3o de Atividade inv\u00e1lida para consultar os Laudos Exigidos");
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoExigidoEntity.class).add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)configuracaoAtividade));
        return this.findByCriteria(criteria);
    }

    public Long getSequence() {
        return this.getSequence(Modulo.ALVARAONLINE, "laudoExigido");
    }

    public boolean laudoExigidoNaoCadastrado(LaudoExigidoEntity laudoExigido) {
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoExigidoEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)laudoExigido.getConfiguracaoAtividade()));
        criteria.add((Criterion)Restrictions.eq((String)"tipoLaudo", (Object)laudoExigido.getTipoLaudo()));
        return this.findByCriteriaUnique(criteria) == null;
    }
}

