/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroIndeferimentoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryIndeferimentoRedeSim;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryIndeferimentoRedeSim")
public class DaoIndeferimentoRedeSimHibernate
extends DaoSequenciaHibernate<IndeferimentoRedeSimEntity, Long>
implements RepositoryIndeferimentoRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoIndeferimentoRedeSimHibernate() {
        super(IndeferimentoRedeSimEntity.class);
    }

    public List<IndeferimentoRedeSimEntity> carregarListaMotivosIndeferimentoRedeSim(FiltroIndeferimentoRedeSim filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(IndeferimentoRedeSimEntity.class);
        if (filtro.getCodigo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)filtro.getCodigo()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            String[] params;
            for (String param : params = filtro.getDescricao().split(" ")) {
                criteria.add(Restrictions.ilike((String)"descricao", (String)param, (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (!EloStringUtils.isEmpty((String)filtro.getSituacao())) {
            criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)filtro.getSituacao()));
        }
        criteria.addOrder(Order.asc((String)"codigo"));
        return this.findByCriteria(criteria);
    }

    public List<IndeferimentoRedeSimEntity> carregaIndeferimentosAtivos() {
        DetachedCriteria criteria = DetachedCriteria.forClass(IndeferimentoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)SimNaoEnum.SIM.getShortText()));
        return this.findByCriteria(criteria);
    }

    public Boolean existeCodigoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) {
        DetachedCriteria criteria = DetachedCriteria.forClass(IndeferimentoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)motivoIndeferimento.getCodigo()));
        return EloListUtils.safeIsEmpty((List)this.findByCriteria(criteria)) == false;
    }

    public List<IndeferimentoRedeSimEntity> getDescricoes(String query) {
        String[] params = query.split(" ");
        DetachedCriteria criteria = DetachedCriteria.forClass(IndeferimentoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)SimNaoEnum.SIM.getShortText()));
        for (String param : params) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)param, (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.addOrder(Order.asc((String)"codigo"));
        return this.findByCriteria(criteria, 0, 15);
    }
}

