/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoHistoricoExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaRedeSim;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryHistoricoExigenciaRedeSim")
public class DaoHistoricoExigenciaRedeSimHibernate
extends DaoSequenciaHibernate<HistoricoExigenciaRedeSimEntity, Long>
implements DaoHistoricoExigenciaRedeSim,
RepositoryHistoricoExigenciaRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoHistoricoExigenciaRedeSimHibernate() {
        super(HistoricoExigenciaRedeSimEntity.class);
    }

    public List<HistoricoExigenciaRedeSimEntity> findBySolicitacaoId(Long id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(HistoricoExigenciaRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"solicitacaoRedeSim.id", (Object)id));
        criteria.addOrder(Order.desc((String)"dataAndamento"));
        return this.findByCriteria(criteria);
    }

    public boolean existsSolicitacaoRedeSimAndSituacao(String protocolo, SituacaoConsultaPreviaRedeSimEnum situacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(HistoricoExigenciaRedeSimEntity.class);
        criteria.createAlias("solicitacaoRedeSim", "solicitacao");
        criteria.add((Criterion)Restrictions.eq((String)"solicitacao.protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"situacao", (Object)situacao.getSigla()));
        criteria.add((Criterion)Restrictions.eq((String)"solicitacao.tipo", (Object)TipoSolicitacaoRedeSimEnum.SOLICITACAO.getSigla()));
        return EloListUtils.safeIsEmpty((List)this.findByCriteria(criteria)) == false;
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "historicoexigenciaredesim");
    }
}

