/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.daoLayer.hibernate.DaoHibernate;
import br.com.elotech.portalarrecadacao.dao.DaoExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryExigenciaRedeSim;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryExigenciaRedeSim")
public class DaoExigenciaRedeSimHibernate
extends DaoHibernate<ExigenciaRedeSimEntity, Long>
implements DaoExigenciaRedeSim,
RepositoryExigenciaRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoExigenciaRedeSimHibernate() {
        super(ExigenciaRedeSimEntity.class);
    }

    public List<ExigenciaRedeSimEntity> getDescricoes(String query) {
        String[] params = query.split(" ");
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaRedeSimEntity.class);
        for (String param : params) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)param, (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.addOrder(Order.asc((String)"codigo"));
        return this.findByCriteria(criteria, 0, 15);
    }

    public ExigenciaRedeSimEntity findByCodigo(Long codigo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigo));
        return (ExigenciaRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public List<ExigenciaRedeSimEntity> carregarExigenciasRedeSim(FiltroExigenciaRedeSim filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaRedeSimEntity.class);
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getAtivo())) {
            criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)filtro.getAtivo()));
        }
        if (filtro.getCodigo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)filtro.getCodigo()));
        }
        criteria.addOrder(Order.asc((String)"codigo"));
        return this.findByCriteria(criteria);
    }

    public List<ExigenciaRedeSimEntity> carregarExigenciasRedeSimAtivas() {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaRedeSimEntity.class);
        criteria.addOrder(Order.asc((String)"codigo"));
        criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)SimNaoEnum.SIM.getShortText()));
        return this.findByCriteria(criteria);
    }
}

