/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryExigencia;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryExigencia")
public class DaoExigenciaHibernate
extends DaoSequenciaHibernate<ExigenciaEntity, Long>
implements RepositoryExigencia {
    private static final long serialVersionUID = -8153096470873396444L;

    public DaoExigenciaHibernate() {
        super(ExigenciaEntity.class);
    }

    public List<TipoExigenciaEntity> buscarTiposExigencia(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)configuracaoAtividade));
        criteria.setProjection((Projection)Projections.property((String)"tipoExigencia"));
        return this.findByCriteriaAny(criteria);
    }

    public List<ExigenciaEntity> consultarExigenciasPorConfiguracaoAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)configuracaoAtividade));
        return this.findByCriteriaAny(criteria);
    }

    public boolean exigenciaNaoCadastrada(ExigenciaEntity exigencia) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExigenciaEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)exigencia.getConfiguracaoAtividade()));
        criteria.add((Criterion)Restrictions.eq((String)"tipoExigencia", (Object)exigencia.getTipoExigencia()));
        return this.findByCriteriaUnique(criteria) == null;
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "exigencia");
    }
}

