/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.EixoPermitidoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryEixo;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryEixo")
public class DaoEixoHibernate
extends DaoSequenciaHibernate<EixoPermitidoEntity, Long>
implements RepositoryEixo {
    private static final long serialVersionUID = -5587838628380490544L;

    public DaoEixoHibernate() {
        super(EixoPermitidoEntity.class);
    }

    public List<EixoPermitidoEntity> carregarEixosPermitidos(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EixoPermitidoEntity.class).add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)configuracaoAtividade));
        return this.findByCriteria(criteria);
    }

    public List<EixoEntity> carregarTodosEixos() {
        return this.findByCriteriaAny(DetachedCriteria.forClass(EixoEntity.class));
    }

    public boolean eixoNaoCadastrado(EixoPermitidoEntity eixoPermitido) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EixoPermitidoEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"configuracaoAtividade", (Object)eixoPermitido.getConfiguracaoAtividade()));
        criteria.add((Criterion)Restrictions.eq((String)"eixo", (Object)eixoPermitido.getEixo()));
        return this.findByCriteriaUnique(criteria) == null;
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "eixoPermitido");
    }
}

