/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.domain.Page;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryConsultaRedeSim")
public class DaoConsultaRedeSimHibernate
extends DaoSequenciaHibernate<SolicitacaoRedeSimEntity, Long>
implements RepositoryConsultaRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoConsultaRedeSimHibernate() {
        super(SolicitacaoRedeSimEntity.class);
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "consultaredesim");
    }

    public SolicitacaoRedeSimEntity getConsultaByProtocolo(String protocolo, String situacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"situacao", (Object)situacao));
        criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla()));
        return (SolicitacaoRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public SolicitacaoRedeSimEntity getConsultaByProtocoloWithoutSituacao(String protocolo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla()));
        return (SolicitacaoRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public SolicitacaoRedeSimEntity getSolicitacaoByProtocolo(String protocolo, Optional<String> tipo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        if (tipo.isPresent()) {
            criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)tipo.get()));
        }
        return (SolicitacaoRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public List<SolicitacaoRedeSimEntity> carregarListaConsultaRedeSim(FiltroConsultaRedeSim filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        if (!EloStringUtils.isEmpty((String)filtro.getTipo())) {
            criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)filtro.getTipo()));
        }
        if (!EloListUtils.safeIsEmpty((List)filtro.getSituacao()).booleanValue()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (String situacao : filtro.getSituacao()) {
                disjunction.add((Criterion)Restrictions.eq((String)"situacao", (Object)situacao));
            }
            criteria.add((Criterion)disjunction);
        }
        if (filtro.getDataInicial() != null && filtro.getDataFinal() != null) {
            criteria.add(Restrictions.between((String)"dataSolicitacao", (Object)filtro.getDataInicial(), (Object)filtro.getDataFinal()));
        }
        if (filtro.getDataInicial() == null && filtro.getDataFinal() != null) {
            criteria.add((Criterion)Restrictions.le((String)"dataSolicitacao", (Object)filtro.getDataFinal()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getProtocolo())) {
            criteria.add(Restrictions.ilike((String)"protocolo", (Object)filtro.getProtocolo()));
        }
        if (this.exigeJoinComSolicitacaoAlvara(filtro)) {
            criteria.createAlias("solicitacoesAlvara", "s");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getGrauRisco())) {
            criteria.add((Criterion)Restrictions.eq((String)"s.grauRisco", (Object)filtro.getGrauRisco()));
        }
        if (filtro.getEvento() != null) {
            criteria.createAlias("eventos", "e");
            criteria.add((Criterion)Restrictions.eq((String)"e.evento", (Object)filtro.getEvento()));
        }
        if (filtro.getTipoInscricao() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"s.tipoDeInscricao", (Object)filtro.getTipoInscricao()));
        }
        if (Objects.nonNull(filtro.getAlvaraEnviado())) {
            if (Boolean.TRUE.equals(filtro.getAlvaraEnviado())) {
                criteria.add(Restrictions.isNotNull((String)"alvaraEnviado"));
            } else {
                criteria.add(Restrictions.isNull((String)"alvaraEnviado"));
            }
        }
        if (Objects.nonNull(filtro.getRedeSim())) {
            criteria.add(Restrictions.isNotNull((String)"s.protocoloRedeSim"));
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.desc((String)"dataSolicitacao"));
        return this.findByCriteria(criteria);
    }

    public SolicitacaoRedeSimEntity getConsultaByTipo(String protocolo, TipoSolicitacaoRedeSimEnum tipo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)tipo.getSigla()));
        return (SolicitacaoRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public List<SolicitacaoRedeSimEntity> getSolicitacoesConcluidasNaoRespondidas() {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"situacao", (Object)SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla()));
        criteria.add((Criterion)Restrictions.eq((String)"resposta", (Object)SimNaoEnum.getNaoShortText()));
        return this.findByCriteria(criteria);
    }

    public Page<SolicitacaoRedeSimEntity> getSolicitacoesRedeSimPaginadas(FiltroConsultaRedeSim filtro, Integer pagina, Integer tamanhoPagina) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class, (String)"srs");
        DetachedCriteria criteriaCount = DetachedCriteria.forClass(SolicitacaoRedeSimEntity.class, (String)"srs").setProjection((Projection)Projections.count((String)"id"));
        if (filtro == null) {
            throw new IllegalArgumentException("Filtro de consulta inv\u00e1lido!");
        }
        criteria.add((Criterion)Restrictions.eq((String)"srs.tipo", (Object)filtro.getTipo()));
        criteriaCount.add((Criterion)Restrictions.eq((String)"srs.tipo", (Object)filtro.getTipo()));
        if (!EloListUtils.safeIsEmpty((List)filtro.getSituacao()).booleanValue()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (String situacao : filtro.getSituacao()) {
                disjunction.add((Criterion)Restrictions.eq((String)"srs.situacao", (Object)situacao));
            }
            criteria.add((Criterion)disjunction);
            criteriaCount.add((Criterion)disjunction);
        }
        if (!EloStringUtils.isEmpty((String)filtro.getSituacaoSolicitacao())) {
            criteria.add((Criterion)Restrictions.eq((String)"srs.situacao", (Object)filtro.getSituacaoSolicitacao()));
            criteriaCount.add((Criterion)Restrictions.eq((String)"srs.situacao", (Object)filtro.getSituacaoSolicitacao()));
        }
        if (filtro.getDataInicial() != null && filtro.getDataFinal() != null) {
            criteria.add(Restrictions.between((String)"srs.dataSolicitacao", (Object)filtro.getDataInicial(), (Object)filtro.getDataFinal()));
            criteriaCount.add(Restrictions.between((String)"srs.dataSolicitacao", (Object)filtro.getDataInicial(), (Object)filtro.getDataFinal()));
        }
        if (filtro.getDataInicial() == null && filtro.getDataFinal() != null) {
            criteria.add((Criterion)Restrictions.le((String)"srs.dataSolicitacao", (Object)filtro.getDataFinal()));
            criteriaCount.add((Criterion)Restrictions.le((String)"srs.dataSolicitacao", (Object)filtro.getDataFinal()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getProtocolo())) {
            criteria.add(Restrictions.ilike((String)"srs.protocolo", (Object)filtro.getProtocolo()));
            criteriaCount.add(Restrictions.ilike((String)"srs.protocolo", (Object)filtro.getProtocolo()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getCnpjEmpresa())) {
            criteria.add(Restrictions.ilike((String)"srs.cnpjEmpresa", (String)filtro.getCnpjEmpresa(), (MatchMode)MatchMode.ANYWHERE));
            criteriaCount.add(Restrictions.ilike((String)"srs.cnpjEmpresa", (String)filtro.getCnpjEmpresa(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getCpfSolicitante())) {
            criteria.add(Restrictions.ilike((String)"srs.cpfSolicitante", (String)filtro.getCpfSolicitante(), (MatchMode)MatchMode.ANYWHERE));
            criteriaCount.add(Restrictions.ilike((String)"srs.cpfSolicitante", (String)filtro.getCpfSolicitante(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (this.exigeJoinComSolicitacaoAlvara(filtro)) {
            criteria.createAlias("solicitacoesAlvara", "s");
            criteriaCount.createAlias("solicitacoesAlvara", "s");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getGrauRisco())) {
            criteria.add((Criterion)Restrictions.eq((String)"s.grauRisco", (Object)filtro.getGrauRisco()));
            criteriaCount.add((Criterion)Restrictions.eq((String)"s.grauRisco", (Object)filtro.getGrauRisco()));
        }
        if (Objects.nonNull(filtro.getNumeroSolicitacao()) && Objects.nonNull(filtro.getExercicioSolicitacao())) {
            criteria.add((Criterion)Restrictions.eq((String)"s.numeroSolicitacao", (Object)filtro.getNumeroSolicitacao()));
            criteriaCount.add((Criterion)Restrictions.eq((String)"s.numeroSolicitacao", (Object)filtro.getNumeroSolicitacao()));
            criteria.add((Criterion)Restrictions.eq((String)"s.exercicio", (Object)filtro.getExercicioSolicitacao()));
            criteriaCount.add((Criterion)Restrictions.eq((String)"s.exercicio", (Object)filtro.getExercicioSolicitacao()));
        }
        if (filtro.getTipoInscricao() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"s.tipoDeInscricao", (Object)filtro.getTipoInscricao()));
            criteriaCount.add((Criterion)Restrictions.eq((String)"s.tipoDeInscricao", (Object)filtro.getTipoInscricao()));
        }
        if (filtro.getNaturezaSolicitacao() != null) {
            criteria.createCriteria("s.naturezas", "natureza");
            criteria.add((Criterion)Restrictions.eq((String)"natureza.naturezaSolicitacao", (Object)filtro.getNaturezaSolicitacao().getNaturezaSolicitacao()));
            criteriaCount.createCriteria("s.naturezas", "natureza");
            criteriaCount.add((Criterion)Restrictions.eq((String)"natureza.naturezaSolicitacao", (Object)filtro.getNaturezaSolicitacao().getNaturezaSolicitacao()));
        }
        if (Objects.nonNull(filtro.getLaudosLiberados()) && filtro.getLaudosLiberados().booleanValue()) {
            criteria.createCriteria("s.laudos", "laudo");
            criteriaCount.createCriteria("s.laudos", "laudo");
            criteria.add((Criterion)Restrictions.eq((String)"laudo.status", (Object)StatusLaudoAlvara.LIBERADO_DEFINITIVO));
            criteriaCount.add((Criterion)Restrictions.eq((String)"laudo.status", (Object)StatusLaudoAlvara.LIBERADO_DEFINITIVO));
        }
        if (Objects.nonNull(filtro.getDebitosEnviados()) && filtro.getDebitosEnviados().booleanValue()) {
            DetachedCriteria subQueryHistoricoExigencia = DetachedCriteria.forClass(HistoricoExigenciaRedeSimEntity.class, (String)"historicoExigenciaRedeSim").add((Criterion)Restrictions.eq((String)"historicoExigenciaRedeSim.situacao", (Object)SituacaoConsultaPreviaRedeSimEnum.DEBITOS_ENVIADOS.getSigla())).add((Criterion)Restrictions.eqProperty((String)"historicoExigenciaRedeSim.solicitacaoRedeSim.id", (String)"srs.id")).setProjection((Projection)Projections.property((String)"historicoExigenciaRedeSim.idHistorico"));
            criteria.add(Subqueries.exists((DetachedCriteria)subQueryHistoricoExigencia));
            criteriaCount.add(Subqueries.exists((DetachedCriteria)subQueryHistoricoExigencia));
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteriaCount.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (filtro.isMaisAntigas()) {
            criteria.addOrder(Order.asc((String)"srs.dataSolicitacao")).addOrder(Order.asc((String)"srs.id"));
        } else {
            criteria.addOrder(Order.desc((String)"srs.dataSolicitacao")).addOrder(Order.desc((String)"srs.id"));
        }
        if (!filtro.getAtivo().isEmpty()) {
            if (filtro.getAtivo().equals("true")) {
                criteria.add((Criterion)Restrictions.eq((String)"srs.ativo", (Object)Boolean.TRUE));
                criteriaCount.add((Criterion)Restrictions.eq((String)"srs.ativo", (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"srs.ativo", (Object)Boolean.FALSE));
                criteriaCount.add((Criterion)Restrictions.eq((String)"srs.ativo", (Object)Boolean.FALSE));
            }
        }
        if (!filtro.getInscricaoEnviada().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"srs.inscricaoEnviada", (Object)SimNaoEnum.toShortText((Boolean)filtro.getInscricaoEnviada().equals("true"))));
            criteriaCount.add((Criterion)Restrictions.eq((String)"srs.inscricaoEnviada", (Object)SimNaoEnum.toShortText((Boolean)filtro.getInscricaoEnviada().equals("true"))));
        }
        Long count = (Long)this.findByCriteriaUniqueAny(criteriaCount);
        List solicitacoes = this.findByCriteria(criteria, pagina.intValue(), tamanhoPagina.intValue());
        return new Page(solicitacoes, count.longValue());
    }

    private boolean exigeJoinComSolicitacaoAlvara(FiltroConsultaRedeSim filtro) {
        return !EloStringUtils.isEmpty((String)filtro.getGrauRisco()) || Objects.nonNull(filtro.getNumeroSolicitacao()) && Objects.nonNull(filtro.getExercicioSolicitacao()) || Objects.nonNull(filtro.getTipoInscricao()) || Objects.nonNull(filtro.getNaturezaSolicitacao()) || Objects.nonNull(filtro.getRedeSim()) || Objects.nonNull(filtro.getLaudosLiberados()) && filtro.getLaudosLiberados() != false;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoBySolicitacaoAlvara(Long solicitacaoAlvara) {
        StringBuilder hql = new StringBuilder();
        hql.append("Select rs from SolicitacaoRedeSim rs ");
        hql.append("join rs.solicitacoesAlvara sol ");
        hql.append("where rs.tipo='S' ");
        hql.append("and sol.solicitacaoAlvara = ").append(solicitacaoAlvara);
        return (SolicitacaoRedeSimEntity)this.findUniqueByHql(hql.toString(), null);
    }

    public List<SolicitacaoRedeSimEntity> getSolicitacaoComDebitoPago() {
        StringBuilder hql = new StringBuilder();
        hql.append(" Select rs from SolicitacaoRedeSim rs , Debito deb ");
        hql.append(" join rs.solicitacoesAlvara sol");
        hql.append(" join sol.debitos solDeb");
        hql.append(" where solDeb.solicitacaoAlvara.solicitacaoAlvara = sol.solicitacaoAlvara");
        hql.append(" and deb.idDebito = solDeb.idDebito");
        hql.append(" and not exists (");
        hql.append(" select 1");
        hql.append(" from DebitoParcela dp");
        hql.append(" join dp.situacaoDebito sp");
        hql.append(" where sp.tipoSituacaoParcela.tipoSituacaoParcela <> 2");
        hql.append(" and deb.id.cadastroGeral.id.tipo = dp.id.debito.id.cadastroGeral.id.tipo");
        hql.append(" and deb.id.cadastroGeral.id.codigo = dp.id.debito.id.cadastroGeral.id.codigo");
        hql.append(" and deb.id.guiaRecolhimento.id.entidadeTributacao.id.exercicioTributacao.exercicio = dp.id.debito.id.guiaRecolhimento.id.entidadeTributacao.id.exercicioTributacao.exercicio");
        hql.append(" and deb.id.guiaRecolhimento.id.guiaRecolhimento = dp.id.debito.id.guiaRecolhimento.id.guiaRecolhimento");
        hql.append(" and deb.id.subdivida = dp.id.debito.id.subdivida)");
        hql.append(" and exists (Select he from HistoricoExigencia he ");
        hql.append(" where he.solicitacaoRedeSim = rs.id and ");
        hql.append(" he.situacao = 'DG' )");
        hql.append(" and not exists (Select he from HistoricoExigencia he ");
        hql.append(" where he.solicitacaoRedeSim = rs.id and ");
        hql.append(" he.situacao in ('DP', 'AV'))");
        return this.findByHql(hql.toString());
    }

    public SolicitacaoRedeSimEntity buscarProtocoloComMesmoCnpj(SolicitacaoRedeSimEntity solicitacaoSelecionada) {
        StringBuilder hql = new StringBuilder();
        hql.append(" Select rs from SolicitacaoRedeSim rs");
        hql.append(" join rs.solicitacoesAlvara sol");
        hql.append(" join sol.cadastroMobiliario mob");
        hql.append(" join mob.cadastroGeral cg");
        hql.append(" join cg.pessoa p");
        hql.append(" where rs.tipo = 'S'");
        hql.append(" and p.cnpjCpf = '");
        hql.append(solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        hql.append("'");
        hql.append(" and rs.situacao <> 'ANU'");
        hql.append(" and rs.protocolo <> '" + solicitacaoSelecionada.getProtocolo() + "'");
        return (SolicitacaoRedeSimEntity)this.findUniqueByHql(hql.toString(), null);
    }
}

