/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.converter;

import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value="proibicaoConverter")
public class ProibicaoConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (!EloStringUtils.isEmpty((String)value)) {
            return this.getAttributesFrom(component).get(value);
        }
        return null;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        ProibicaoEntity entity;
        if (value != null && !"".equals(value) && value instanceof ProibicaoEntity && (entity = (ProibicaoEntity)value).getDescricao() != null) {
            this.addAttribute(component, entity);
            String codigo = entity.getIdProibicao().toString();
            if (codigo != null) {
                return String.valueOf(codigo);
            }
        }
        return "";
    }

    protected void addAttribute(UIComponent component, ProibicaoEntity o) {
        if (o.getIdProibicao() != null) {
            String key = o.getIdProibicao().toString();
            this.getAttributesFrom(component).put(key, o);
        }
    }

    protected Map<String, Object> getAttributesFrom(UIComponent component) {
        return component.getAttributes();
    }
}

