/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.daoSupport.EloDaoSupport;
import br.com.elotech.exception.common.ParametroException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.MotivoIndeferimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ConsultaPreviaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeParametro;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.enumerator.UsuarioMasterTecnicoEnum;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.util.string.Strings;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.Session;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.context.RequestContext;
import org.primefaces.event.TabChangeEvent;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.integration.history.MessageHistory;
import org.springframework.messaging.Message;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@EloController(value="utilsController")
@Scope(value="session")
public class UtilsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TAG_EVENTO_DEMP_MR_AS = "nu_seq_evento";
    public static final String TAG_PROTOCOLO_SCPR0_SDCO = "co_protocolo";
    public static final String TAG_PROTOCOLO_DEMP = "co_protocolo_consulta_previa";
    public static final String BLOQUEIA_SOLICITACAO = "ATEN\u00c7\u00c3O! - Com o advento da Lei n\u00ba 13.874/2019, denominada de Lei da Liberdade Econ\u00f4mica, as empresas com atividades somente com CNAE's elencados nas RESOLU\u00c7\u00d5ES CGSIM N\u00bas. 57 e 59/2020 est\u00e3o dispensadas de Licen\u00e7a para Localiza\u00e7\u00e3o. Favor verificar se todos os CNAES inseridos na consulta pr\u00e9via est\u00e3o nas resolu\u00e7\u00f5es supracitadas. Caso sim, dever\u00e1 fazer apenas a inscri\u00e7\u00e3o municipal via pra\u00e7a de atendimento. Caso n\u00e3o, solicitar alvar\u00e1 atrav\u00e9s do sistema antigo. D\u00favidas: 3221-1321.";
    private static final String INITIAL_INDEX = "0";
    @Value(value="${version}")
    private String numeroVersao;
    private static Log logger = LogFactory.getLog((String)"UtilsController");
    private String tituloMensagemIndisponivel = "Desculpe!";
    private static String mensagemServicoIndisponivel;
    public static final String MENSAGEM_ERRO_NUMERO_SOLICITACAO = "Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015";
    private static final String PROP_TYPE = "type";
    private static final String PROP_VALUE = "channel";
    private static final String PROP_NAME = "name";
    private String index = "0";
    private SimNaoEnum[] simNaoEnum;

    public String getTituloMensagemIndisponivel() {
        return this.tituloMensagemIndisponivel;
    }

    public void setTituloMensagemIndisponivel(String tituloMensagemIndisponivel) {
        this.tituloMensagemIndisponivel = tituloMensagemIndisponivel;
    }

    public String getMensagemServicoIndisponivel() {
        return mensagemServicoIndisponivel;
    }

    public static void setMensagemServicoIndisponivel(String mensagemServicoIndisponivel) {
        UtilsController.mensagemServicoIndisponivel = mensagemServicoIndisponivel;
    }

    public SimNaoEnum[] getSimNaoEnum() {
        if (this.simNaoEnum == null) {
            this.simNaoEnum = SimNaoEnum.values();
        }
        return this.simNaoEnum;
    }

    public void setSimNaoEnum(SimNaoEnum[] simNaoEnum) {
        this.simNaoEnum = simNaoEnum;
    }

    public String getNumeroVersao() {
        return this.numeroVersao;
    }

    public void setNumeroVersao(String numeroVersao) {
        this.numeroVersao = numeroVersao;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String formatarCnpjCpf(String doc) throws FormatError {
        if (doc != null && doc.length() >= 11) {
            return EloStringUtils.formatCpfCnpj((String)doc);
        }
        return "";
    }

    public static Boolean isNumeroSolicitacaoValido(String numeroSolicitacao) {
        block3: {
            try {
                if (EloStringUtils.isEmpty((String)numeroSolicitacao)) break block3;
                String[] numerosSeparados = numeroSolicitacao.split("/");
                if (numerosSeparados.length == 2) {
                    Long.valueOf(numerosSeparados[0]);
                    Long.valueOf(numerosSeparados[1]);
                    break block3;
                }
                throw new Exception();
            }
            catch (Exception e) {
                ShowMessage.addWarnMessage((String)"validacao", (String)"Verifique o n\u00famero da Solicita\u00e7\u00e3o. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
                return false;
            }
        }
        return true;
    }

    public static EntidadeTributacaoEntity getEntidadeTributacao() {
        try {
            return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade();
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getEmailSetorAlvara() throws SolicitacaoAlvaraException {
        try {
            ParametroAlvaraEntity param = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(UtilsController.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.EMAILSETORCADASTROALVARA);
            if (param != null) {
                return param.getValor();
            }
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", ParametroAlvaraEnum.EMAILSETORCADASTROALVARA));
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao carregar o par\u00e2metro %s.", ParametroAlvaraEnum.EMAILSETORCADASTROALVARA));
        }
    }

    public String parseDate(Date data) {
        if (data != null) {
            return EloDateUtils.toDateString((Date)data);
        }
        return null;
    }

    public String parseDateTime(Date data) {
        if (data != null) {
            return EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy HH:mm");
        }
        return null;
    }

    public static boolean desabilitaSolicitacaoAlvara() {
        try {
            ParametroAlvaraEntity parametro = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(UtilsController.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.DESABILITAR_SOLICITACAO);
            if (parametro != null && parametro.getValor().equals(SimNaoEnum.SIM.getShortText())) {
                return true;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Par\u00e2metro DESABILITAR_SOLICITACAO n\u00e3o encontrado.");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String recuperaParametroMensagemServicoIndisponivel() {
        try {
            ParametroAlvaraEntity parametro = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(UtilsController.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.MENSAGEM_SERVICO_INDISPONIVEL);
            if (parametro != null && parametro.getIdParametroAlvara() != null) {
                return parametro.getValor();
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Par\u00e2metro MENSAGEM_SERVICO_INDISPONIVEL n\u00e3o encontrado.");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static boolean desabilitaImpressaoTaxasAlvara() {
        try {
            ParametroAlvaraEntity parametro = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(UtilsController.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.DESABILITAR_IMPRESSAO_TAXAS);
            if (parametro != null && parametro.getValor().equals(SimNaoEnum.SIM.getShortText())) {
                return true;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Par\u00e2metro DESABILITAR_IMPRESSAO_TAXAS n\u00e3o encontrado.");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean validaEmail(String email) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public String formataData(Date data) {
        if (data != null) {
            return EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy");
        }
        return null;
    }

    public String formataDataHora(Date data) {
        if (data != null) {
            return EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy HH:mm");
        }
        return null;
    }

    public static Long[] separarNumeroExercicioSolicitacao(String numeroExercicioSolicitacao) {
        try {
            String[] consulta = numeroExercicioSolicitacao.split("/");
            Long numero = Long.valueOf(consulta[0]);
            Long exercicio = Long.valueOf(consulta[1]);
            Long[] retorno = new Long[]{numero, exercicio};
            return retorno;
        }
        catch (Exception e) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            return null;
        }
    }

    public String recuperarTipoAtividade(TipoInscricaoAlvaraEntity tipoInscricao) {
        if (tipoInscricao.getSigla().equals("N") || tipoInscricao.getSigla().equals("P")) {
            return "CNAE";
        }
        if (tipoInscricao.getSigla().equals("C")) {
            return "CBO";
        }
        if (tipoInscricao.getSigla().equals("M") || tipoInscricao.getSigla().equals("MP")) {
            return "MEI";
        }
        return "";
    }

    public static String formatXml(String xml) {
        if (!EloStringUtils.isEmpty((String)xml)) {
            StringWriter sw;
            try {
                OutputFormat format = OutputFormat.createPrettyPrint();
                Document document = DocumentHelper.parseText((String)xml);
                sw = new StringWriter();
                XMLWriter writer = new XMLWriter((Writer)sw, format);
                writer.write(document);
            }
            catch (Exception e) {
                throw new RuntimeException("Error pretty printing xml:\n" + xml, e);
            }
            return sw.toString();
        }
        return "";
    }

    public static String retrieveXmlTagValue(File file, String tag) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName(tag);
            return nList.item(0).getFirstChild().getNodeValue();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static org.w3c.dom.Document retrieveDocumentFromFile(File file) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        org.w3c.dom.Document doc = dBuilder.parse(file);
        return doc;
    }

    public static String getParametroGeralValor(Modulo modulo, ParametroGeralEnum parametroEnum) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getParamentroGeral(modulo.toString(), parametroEnum.name());
    }

    public static ParametroAlvaraEntity getParametroAlvara(ParametroAlvaraEnum parametroEnum) throws BaseException {
        ParametroAlvaraEntity parametroAlvara = UtilsController.getParametro((ParametroAlvaraEnum)parametroEnum);
        if (parametroAlvara == null) {
            throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o foi encontrado", parametroEnum.name()));
        }
        return parametroAlvara;
    }

    public static String getValorParametroAlvara(ParametroAlvaraEnum parametroEnum) throws BaseException {
        ParametroAlvaraEntity parametroAlvara = UtilsController.getParametroAlvara((ParametroAlvaraEnum)parametroEnum);
        if (EloStringUtils.isEmpty((String)parametroAlvara.getValor())) {
            throw new ParametroNaoConfiguradoException("O parametro " + parametroAlvara.getParametro().name() + " n\u00e3o est\u00e1 configurado. ");
        }
        return parametroAlvara.getValor();
    }

    public static ParametroAlvaraEntity getParametro(ParametroAlvaraEnum parametroEnum) throws BaseException {
        EntidadeAiseEntity entidade = UtilsController.getEntidadeTributacao().getId().getEntidade();
        return ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(entidade, parametroEnum);
    }

    public static ParametroAlvaraNaturezaEntity getParametroAlvaraNatureza(NaturezaSolicitacaoAlvaraEntity natureza, ParametroAlvaraNaturezaEnum param, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        ParametroAlvaraNaturezaEntity parametroAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getParametroAlvaraNatureza(natureza, param, tipoInscricao);
        if (parametroAlvara == null) {
            throw new SolicitacaoAlvaraException(String.format("O par\u00e2metro %s n\u00e3o foi encontrado", param.name()));
        }
        return parametroAlvara;
    }

    public static String lastChannel(Message<?> message) {
        MessageHistory messageHistory = (MessageHistory)message.getHeaders().get((Object)"history");
        String lastChannel = null;
        for (Properties prop : messageHistory) {
            if (!prop.getProperty("type").equals("channel")) continue;
            lastChannel = prop.getProperty("name");
        }
        return lastChannel;
    }

    public static boolean hasChannel(Message<?> message, String channel) {
        MessageHistory messageHistory = (MessageHistory)message.getHeaders().get((Object)"history");
        for (Properties prop : messageHistory) {
            if (!prop.getProperty("name").equals(channel)) continue;
            return true;
        }
        return false;
    }

    public static String getMensagemObservacaoRecibos(ParametroAlvaraEnum parametro) throws BaseException {
        ParametroAlvaraEntity parametroMensagemObservacao = UtilsController.getParametroAlvara((ParametroAlvaraEnum)parametro);
        if (parametroMensagemObservacao != null && !EloStringUtils.isEmpty((String)parametroMensagemObservacao.getValor())) {
            return parametroMensagemObservacao.getValor();
        }
        return "";
    }

    public static boolean isValorSimParaAlgumaNaturezaDaSolicitacao(SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraNaturezaEnum parametroEnum) throws BaseException {
        List naturezas = solicitacao.getNaturezas();
        for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
            ParametroAlvaraNaturezaEntity parametroAlvaraNatureza = UtilsController.getParametroAlvaraNatureza((NaturezaSolicitacaoAlvaraEntity)natureza, (ParametroAlvaraNaturezaEnum)parametroEnum, (TipoInscricaoAlvaraEntity)solicitacao.getTipoDeInscricao());
            if (EloStringUtils.isEmpty((String)parametroAlvaraNatureza.getValor())) {
                throw new ParametroNaoEncontradoException("O par\u00e2metro " + parametroEnum.name() + " n\u00e3o est\u00e1 configurado.");
            }
            if (!parametroAlvaraNatureza.getValor().equals(SimNaoEnum.SIM.getShortText())) continue;
            return true;
        }
        return false;
    }

    public static EntidadeAiseEntity getEntidade() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade().getId().getEntidade();
    }

    public static boolean isConsultaPrevia(SolicitacaoRedeSimEntity consultaRedeSim) {
        return consultaRedeSim.getTipo().equals(TipoSolicitacaoAlvaraEnum.CONSULTA.getShortText());
    }

    public static boolean isDadosEmpresaOrSolicitacao(SolicitacaoRedeSimEntity consultaRedeSim) {
        return consultaRedeSim.getTipo().equals(TipoSolicitacaoAlvaraEnum.DADOS_EMPRESA.getShortText()) || consultaRedeSim.getTipo().equals(TipoSolicitacaoAlvaraEnum.SOLICITACAO.getShortText());
    }

    public static SolicitacaoRedeSimEntity carregaConsultaRedeSimDoSDCOByFile(File file) {
        String protocolo = UtilsController.retrieveXmlTagValue((File)file, (String)"co_protocolo");
        SolicitacaoRedeSimEntity crs = null;
        try {
            crs = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            return crs;
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SolicitacaoRedeSimEntity carregaConsultaPreviaDoScprOuSdcoByFile(File file) {
        String protocolo = UtilsController.retrieveXmlTagValue((File)file, (String)"co_protocolo");
        return UtilsController.carregaConsultaPreviaByProtocolo((String)protocolo);
    }

    public static SolicitacaoRedeSimEntity carregaConsultaPreviaDoDempByFile(File file) {
        String protocolo = UtilsController.retrieveXmlTagValue((File)file, (String)"co_protocolo_consulta_previa");
        return UtilsController.carregaConsultaPreviaByProtocolo((String)protocolo);
    }

    public static SolicitacaoRedeSimEntity carregaConsultaPreviaByProtocolo(String protocolo) {
        SolicitacaoRedeSimEntity crs = null;
        try {
            crs = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.CONSULTA);
            return crs;
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getUrlServer() {
        ArrayList<String> endPoints = new ArrayList<String>();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objs = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            String hostname = InetAddress.getLocalHost().getHostName();
            InetAddress addresses = InetAddress.getByName(hostname);
            for (ObjectName obj : objs) {
                String scheme = mbs.getAttribute(obj, "scheme").toString();
                String port = obj.getKeyProperty("port");
                String host = addresses.getHostAddress();
                String ep = scheme + "://" + host + ":" + port;
                endPoints.add(ep);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return (String)endPoints.stream().findFirst().get();
    }

    public static File getFileDempByString(String arquivo) throws IOException, FileNotFoundException {
        File f = File.createTempFile("DEMP", ".xml");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
        bos.write(arquivo.getBytes());
        bos.close();
        return f;
    }

    public static boolean possuiDebitosAPagar(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Long quantidadeParcelasEmAberto = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificaQtdeParcelasEmAberto(UtilsController.getExercicio(), UtilsController.getGuiaRecolhimento((SolicitacaoAlvaraEntity)solicitacao).getId().getGuiaRecolhimento(), solicitacao.getCadastroMobiliario().getCadastroGeral().getId());
        return quantidadeParcelasEmAberto > 0L;
    }

    public static Boolean possuiDebitoExercicioAtual(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificarDebitoExercicioAtual(UtilsController.getGuiaRecolhimento((SolicitacaoAlvaraEntity)solicitacao), solicitacao.getCadastroMobiliario().getId(), UtilsController.getExercicio());
    }

    public static GuiaRecolhimentoEntity getGuiaRecolhimento(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaGuiaRecolhimentoPorSolicitacao(UtilsController.getExercicio(), solicitacao);
    }

    public static Long getExercicio() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade().getId().getExercicioTributacao().getExercicio();
    }

    public static boolean permiteRenovacaoAnual(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            if (!solicitacao.isSolicitacaoMEI()) {
                boolean permite = UtilsController.isValidadeAlvaraAnual() && UtilsController.possuiDebitoExercicioAtual((SolicitacaoAlvaraEntity)solicitacao) != false && !UtilsController.possuiDebitosAPagar((SolicitacaoAlvaraEntity)solicitacao);
                return permite;
            }
            return Boolean.TRUE;
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public static boolean isValidadeAlvaraAnual() throws BaseException {
        ParametroAlvaraEntity parametro = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDADE_ALVARA_ANUAL);
        return !EloStringUtils.isEmpty((String)parametro.getValor());
    }

    public static boolean validarAreaUtilizadaCBO() throws BaseException {
        ParametroAlvaraEntity parametroAlvara = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDA_AREA_UTILIZADA_CBO);
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametroAlvara.getValor());
    }

    public static boolean isTestadaGenerica() throws BaseException {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.USA_TESTADA_GENERICA).getValor());
    }

    public static boolean isUtilizaEnderecoCadastroGeral() throws BaseException {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.UTILIZA_ENDERECO_CADASTRO_GERAL));
    }

    public static boolean parametroCriaRegimeFiscalAtivo() throws BaseException {
        String parametroCriaRegimeFiscal = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CRIA_REGIME_FISCAL);
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametroCriaRegimeFiscal);
    }

    public static void abrirLinkNovaAba(String url) throws IOException {
        if (!EloStringUtils.isEmpty((String)url)) {
            if (!url.startsWith("http")) {
                url = "http://" + url;
            }
            ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
            externalContext.redirect(url);
        }
    }

    public static String getNomeSecretaria() {
        try {
            return UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.NOME_SECRETARIA);
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static Date montarDataValidadeAlvaraAnual() throws BaseException {
        Date dataValidadeAnual = null;
        try {
            ParametroAlvaraEntity parametroValidadeAlvara = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDADE_ALVARA_ANUAL);
            if (parametroValidadeAlvara != null && !EloStringUtils.isEmpty((String)parametroValidadeAlvara.getValor())) {
                Long exercicioAtual = UtilsController.getExercicio();
                String dataValidade = null;
                dataValidade = parametroValidadeAlvara.getValor() + "/" + exercicioAtual;
                Date dataValidadeAnualVigente = EloDateUtils.fromDateString((String)dataValidade);
                if (dataValidadeAnualVigente.compareTo(new Date()) > 0) {
                    dataValidadeAnual = dataValidadeAnualVigente;
                } else {
                    dataValidade = parametroValidadeAlvara.getValor() + "/" + (exercicioAtual + 1L);
                    dataValidadeAnual = EloDateUtils.fromDateString((String)dataValidade);
                }
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel montar a data de validade anual do alvar\u00e1. " + e.getMessage());
        }
        return dataValidadeAnual;
    }

    public static IndeferimentoRedeSimEntity getIndeferimentoByCodigo(MotivoIndeferimentoRedeSimEnum indeferimento) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getIndeferimentoByCodigo(indeferimento.getCodigo());
    }

    public static void imprimirRelatorio(byte[] relatorio) throws IOException {
        ServletOutputStream outputStream = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("application/pdf");
        response.setHeader("Content-disposition", "inline; filename=\"relatorio.pdf\"");
        response.setContentLength(relatorio.length);
        outputStream = response.getOutputStream();
        outputStream.write(relatorio, 0, relatorio.length);
        outputStream.flush();
        outputStream.close();
        facesContext.responseComplete();
    }

    public static boolean isBloqueiaTramiteDepoisAlvaraEmitido(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        if (Objects.nonNull(solicitacao)) {
            try {
                String param = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.BLOQUEIA_TRAMITES_DEPOIS_DE_ALVARA_EMITIDO).getValor();
                return SimNaoEnum.equalSim((String)param) != false && Objects.nonNull(solicitacao.getNumeroAlvara());
            }
            catch (BaseException e) {
                throw new SolicitacaoAlvaraException("Falha ao verificar par\u00e2metro BLOQUEIA_TRAMITES_DEPOIS_DE_ALVARA_EMITIDO");
            }
        }
        return Boolean.FALSE;
    }

    public void redirecionarParaNovidadesVersao() throws IOException, BaseException {
        try {
            String url = String.format("%s%s%s", "window.open('", "https://atendimento.elotech.com.br/hc/pt-br/sections/360004483033-ARW-Alvar%C3%A1-Online", "', '_newtab')");
            RequestContext.getCurrentInstance().execute(url);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException("Ocorreu um erro ao tentar redirecionar para as novidades da vers\u00e3o");
        }
    }

    private String carregarParametroNovidadesDaVersao() throws Exception {
        ParametroGeralEntity parametroLinkNovidades = ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).carregarParametroGeral("LINK_NOVIDADES_VERSAO", Modulo.CONFIGURACAO);
        if (parametroLinkNovidades == null || EloStringUtils.isEmpty((String)parametroLinkNovidades.getValor())) {
            throw new ParametroException("Par\u00e2metro com link das Novidades de Vers\u00e3o n\u00e3o configurado!");
        }
        String valorParametro = parametroLinkNovidades.getValor();
        if (!valorParametro.startsWith("http")) {
            return "https://" + valorParametro;
        }
        return valorParametro;
    }

    public static Long getProtocoloInicialRedeSim() throws ConsultaPreviaRedeSimException {
        try {
            String parametro = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PROTOCOLO_INICIAL_REDESIM).getValor();
            if (EloStringUtils.isEmpty((String)parametro)) {
                return 0L;
            }
            parametro = parametro.replaceAll("[^\\d.]", "");
            return Long.parseLong(parametro);
        }
        catch (BaseException e) {
            throw new ConsultaPreviaRedeSimException(String.format("%s", "Ocorreu uma Falha ao validar o par\u00e2metro ", ParametroAlvaraEnum.PROTOCOLO_INICIAL_REDESIM.name()));
        }
    }

    public void onTabChange(TabChangeEvent event) {
        this.index = ((AccordionPanel)event.getSource()).getActiveIndex();
    }

    public void resetIndex() {
        this.index = "0";
    }

    public static boolean possuiIntegracaoRedeSim() {
        try {
            String parametro = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRADO_REDESIM);
            if (SimNaoEnum.getSimShortText().equals(parametro)) {
                return true;
            }
        }
        catch (ParametroNaoConfiguradoException e) {
            ShowMessage.addInfoMessage((String)"msgCentro", (String)("Observa\u00e7\u00e3o: " + e.getMessage() + " Ser\u00e1 utilizado o valor 'N'"));
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgCentro", (String)"Ocorreu um erro ao buscar o par\u00e2metro INTEGRADO_REDESIM.");
        }
        return false;
    }

    public static UsuarioEntity usuarioAutenticado() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() instanceof UsuarioEntity) {
            return (UsuarioEntity)auth.getPrincipal();
        }
        return new UsuarioEntity();
    }

    public static boolean isUsuarioTecnicoOuMaster() {
        return UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)UtilsController.usuarioAutenticado().getUsuario());
    }

    public static String getRestricaoCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        StringBuilder obs = new StringBuilder();
        if (solicitacao.isSolicitacaoJuridicaNormal() && !solicitacao.isGrauRiscoLiberdadeEconomica()) {
            RestricaoAlvaraVo restricaoAlvaraVo = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificarRestricaoCadastroAlvara(solicitacao);
            if (!EloStringUtils.isEmpty((String)restricaoAlvaraVo.getDescricaoRestricao())) {
                obs.append(restricaoAlvaraVo.getDescricaoRestricao()).append("-");
            }
            obs.append(Objects.isNull(restricaoAlvaraVo.getObservacao()) ? "" : restricaoAlvaraVo.getObservacao());
        }
        return obs.toString();
    }

    public static String montarObservacaoGeral() throws SolicitacaoAlvaraException {
        try {
            String valor = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.OBSERVACAO_GERAL_CONSULTA_PREVIA).getValor();
            return EloStringUtils.isEmpty((String)valor) ? "" : valor;
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Ocorreu uma falha ao carregar o par\u00e2metro OBSERVACAO_GERAL_CONSULTA_PREVIA");
        }
    }

    public static boolean jaFoiGeradoAlvaraProvisorio(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        return Objects.nonNull(solicitacaoRedeSim.getAlvaraEnviado()) && TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)solicitacaoRedeSim.getAlvaraEnviado());
    }

    public static boolean existeHistoricoAlvaraProvisorioEnviado(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        String textoDeProcura = "ALVAR\u00c1 PROVIS\u00d3RIO ENVIADO";
        return solicitacaoRedeSim.getHistoricosExigencias().stream().anyMatch(historico -> SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO_ENVIADO.getSigla().equalsIgnoreCase(historico.getSituacao()) || SituacaoConsultaPreviaRedeSimEnum.ALVARA_ENVIADO.getSigla().equalsIgnoreCase(historico.getSituacao()) && !EloStringUtils.isEmpty((String)historico.getObservacoes()) && historico.getObservacoes().toUpperCase().contains(textoDeProcura));
    }

    public static boolean isImpressaoDispensaLicencaAmbientalConfigurada() throws BaseException {
        ParametroAlvaraEntity parametro = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.CODIGO_RELATORIO_DISPENSA_LICENCA_AMBIENTAL);
        return parametro != null && !EloStringUtils.isEmpty((String)parametro.getValor());
    }

    public String formatCpfCnpjReport(String cpfCnpj) throws FormatError {
        return EloStringUtils.formatCpfCnpjReport((String)cpfCnpj);
    }

    public void copiarTextoParaClipboard(String text) {
        if (EloStringUtils.isEmpty((String)text)) {
            text = "N\u00e3o foi poss\u00edvel copiar o texto.";
        }
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static boolean isIntegracaoSimplificadaRedeSim() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRADO_REDESIM_SIMPLIFICADO));
    }

    public static boolean isBloqueiaSolicitacaoLiberdadeEconomicaSemIntegracao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        String bloqueia = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.BLOQUEIA_SOLICITACAO_LIBERDADE_SEM_INTEGRACAO);
        if (Objects.nonNull(bloqueia) && SimNaoEnum.SIM.getShortText().equals(bloqueia) && solicitacao.isGrauRiscoLiberdadeEconomica()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean areAllEventosAptos(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) throws BaseException {
        ParametroAlvaraEntity parametroEventosAptos = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.EVENTOS_REDE_SIM_APTOS_PROCESSO_AUTOMATICO);
        if (solicitacaoRedeSimEntity.isMei()) {
            parametroEventosAptos = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.EVENTOS_REDE_SIM_APTOS_PROCESSO_AUTOMATICO_MEI);
        }
        if (!Strings.isEmpty((CharSequence)parametroEventosAptos.getValor())) {
            List<String> eventosParametrizados = Arrays.asList(parametroEventosAptos.getValor().split(","));
            List eventosSolicitacao = solicitacaoRedeSimEntity.getEventos().stream().map(EventoRedeSimEntity::getEvento).map(String::valueOf).collect(Collectors.toList());
            return eventosParametrizados.containsAll(eventosSolicitacao);
        }
        return true;
    }

    public static boolean isAutenticacaoKeyCloak() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.UTILIZA_AUTENTICACAO_KEYCLOAK));
    }

    public static boolean isImovelRuralUsaCadastroImobiliario() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.IMOVEL_RURAL_USA_CADASTRO_IMOBILIARIO));
    }

    private static Session commitAndGetSession() {
        boolean txActive;
        EloDaoSupport eloDaoSupport = (EloDaoSupport)SpringContext.getBean(EloDaoSupport.class);
        if (Objects.isNull(eloDaoSupport)) {
            return null;
        }
        Session session = eloDaoSupport.getSession();
        if (Objects.isNull(session)) {
            return null;
        }
        if (session.isOpen()) {
            session.flush();
        }
        if (txActive = session.getTransaction().isActive()) {
            eloDaoSupport.getSession().getTransaction().commit();
        }
        return session;
    }

    public static boolean commitTransaction() {
        Session session = UtilsController.commitAndGetSession();
        return !Objects.isNull(session);
    }

    public static void commitAndRestartTransaction() {
        Session session = UtilsController.commitAndGetSession();
        if (Objects.nonNull(session)) {
            session.beginTransaction();
        }
    }

    public static void startTransaction() {
        boolean txActive;
        EloDaoSupport eloDaoSupport = (EloDaoSupport)SpringContext.getBean(EloDaoSupport.class);
        boolean bl = txActive = Objects.nonNull(eloDaoSupport) && eloDaoSupport.getSession().getTransaction().isActive();
        if (!txActive) {
            eloDaoSupport.getSession().getTransaction().begin();
        }
    }

    public static void rollBackAndRestartTransaction() {
        EloDaoSupport eloDaoSupport = (EloDaoSupport)SpringContext.getBean(EloDaoSupport.class);
        if (Objects.nonNull(eloDaoSupport)) {
            boolean txActive = eloDaoSupport.getSession().getTransaction().isActive();
            if (txActive) {
                eloDaoSupport.getSession().getTransaction().rollback();
            }
            eloDaoSupport.getSession().getTransaction().begin();
        }
    }

    public static <T> T refreshEntity(T entity) {
        EloDaoSupport eloDaoSupport = (EloDaoSupport)SpringContext.getBean(EloDaoSupport.class);
        if (Objects.nonNull(eloDaoSupport)) {
            return (T)eloDaoSupport.refresh(entity);
        }
        return entity;
    }
}

