/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaMobiliarioEntity;
import br.com.elotech.tributacao.filter.FiltroTipoPessoaNaturezaJuridica;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Scope;

@EloController(value="tipoPessoaPorNaturezaJuridicaRedeSimController")
@Scope(value="flow")
public class TipoPessoaPorNaturezaJuridicaRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<NaturezaJuridicaEntity> naturezas;
    private List<PessoaMobiliarioEntity> tipoPessoas;
    private FiltroTipoPessoaNaturezaJuridica filtro;

    public List<NaturezaJuridicaEntity> getNaturezas() {
        return this.naturezas;
    }

    public void setNaturezas(List<NaturezaJuridicaEntity> naturezas) {
        this.naturezas = naturezas;
    }

    public List<PessoaMobiliarioEntity> getTipoPessoas() {
        return this.tipoPessoas;
    }

    public void setTipoPessoas(List<PessoaMobiliarioEntity> tipoPessoas) {
        this.tipoPessoas = tipoPessoas;
    }

    public FiltroTipoPessoaNaturezaJuridica getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroTipoPessoaNaturezaJuridica filtro) {
        this.filtro = filtro;
    }

    public List<NaturezaJuridicaEntity> pesquisarNaturezas() throws BaseException {
        this.naturezas = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getListaNaturezaJuridicaRedeSim(this.filtro);
        return this.naturezas;
    }

    public List<PessoaMobiliarioEntity> carregarTiposPessoa() throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaTipoPessoaMobiliario();
    }

    public void salvarNaturezaJuridica(NaturezaJuridicaEntity naturezaJuridica) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarNaturezaJuridicaRedeSim(naturezaJuridica);
            ShowMessage.addInfoMessage((String)"message", (String)"Registro alterado com sucesso.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"message", (String)"Falha ao salvar o registro.");
        }
    }

    public void iniciar() throws BaseException {
        this.limparCampos();
        this.tipoPessoas = this.carregarTiposPessoa();
    }

    public void limparCampos() throws BaseException {
        this.filtro = new FiltroTipoPessoaNaturezaJuridica();
        this.naturezas = new ArrayList();
    }
}

