/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.TipoDocumentoRedeSimLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroTipoDocumentoPorTipoLaudoRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="tipoDocumentoPorTipoLaudoRedeSimController")
public class TipoDocumentoPorTipoLaudoRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<TipoDocumentoRedeSimLaudoAlvaraEntity> tipoDocumentosRedeSimLaudoAlvara;
    private List<TipoLaudoEntity> tiposLaudo;
    private FiltroTipoDocumentoPorTipoLaudoRedeSim filtro;

    public List<TipoDocumentoRedeSimLaudoAlvaraEntity> getTipoDocumentosRedeSimLaudoAlvara() {
        return this.tipoDocumentosRedeSimLaudoAlvara;
    }

    public void setTipoDocumentosRedeSimLaudoAlvara(List<TipoDocumentoRedeSimLaudoAlvaraEntity> tipoDocumentosRedeSimLaudoAlvara) {
        this.tipoDocumentosRedeSimLaudoAlvara = tipoDocumentosRedeSimLaudoAlvara;
    }

    public List<TipoLaudoEntity> getTiposLaudo() {
        return this.tiposLaudo;
    }

    public void setTiposLaudo(List<TipoLaudoEntity> tiposLaudo) {
        this.tiposLaudo = tiposLaudo;
    }

    public FiltroTipoDocumentoPorTipoLaudoRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroTipoDocumentoPorTipoLaudoRedeSim filtro) {
        this.filtro = filtro;
    }

    private List<TipoLaudoEntity> carregarTiposLaudo() throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroTipoDocumentoPorTipoLaudoRedeSim();
        this.filtro.setDescricao("");
        this.tiposLaudo = this.carregarTiposLaudo();
        this.tipoDocumentosRedeSimLaudoAlvara = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscaTipoDocumentosRedeSimLaudoAlvara(this.filtro);
    }

    public void pesquisarTipoDocumentosPorLaudo() {
        try {
            this.tipoDocumentosRedeSimLaudoAlvara = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscaTipoDocumentosRedeSimLaudoAlvara(this.filtro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    public void salvarTipoDocumentoPorLaudo(TipoDocumentoRedeSimLaudoAlvaraEntity tipoDocumentoPorLaudo) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarTipoDocumentoPorLaudo(tipoDocumentoPorLaudo);
            ShowMessage.addInfoMessage((String)"growl", (String)"Registro alterado com sucesso!");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"growl", (String)e.getMessage());
        }
    }
}

