/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.agendamento.job.JobIniciaProcessoIntegracaoMeiRedeSim;
import br.com.elotech.portalarrecadacao.controller.ConsultaCadastroImobiliarioController;
import br.com.elotech.portalarrecadacao.controller.ConsultaEnderecoCadastroGeralController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoRedeSimController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoRedeSimDataModel;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.AnexoSolicitacaoRedeSimVo;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoWebVo;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.domain.vo.ReceitaVo;
import br.com.elotech.portalarrecadacao.enumerator.EnquadramentoEmpresaEnum;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SolicitacaoRedeSimMenuActionEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeCategoriaMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeDebitos;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeNaturezaSolicitacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.integration.transformer.ProcessaConsulta;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraRedeSimImpl;
import br.com.elotech.portalarrecadacao.utils.faces.FacesUtil;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AppWebConfEntity;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CategoriaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.enumerator.TipoDocumentoRedeSimEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.tributacao.filter.GuiaRecolhimentoReceitaFiltro;
import br.com.elotech.tributacao.interfaces.Testada;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import org.primefaces.event.SelectEvent;
import org.quartz.JobExecutionException;
import org.springframework.context.annotation.Scope;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@EloController(value="solicitacaoRedeSimController")
@Scope(value="flow")
public class SolicitacaoRedeSimController
extends EloLogger
implements Serializable {
    @Resource
    private AuthenticationProviderAise authenticationProviderAise;
    final String dadosSolicitacao = "dados_solicitacao";
    final String solicitante = "solicitante";
    final String dsNome = "ds_nome";
    private static final long serialVersionUID = 7809900820490092087L;
    public static final int NUMERO_PARCELA = 1;
    public Date vencimentoPrimeiraParcela;
    public String observacaoDebito;
    public String totalReceitas;
    public Integer numeroParcela;
    public List<ReceitaVo> receitasSelecionadas = new ArrayList();
    public List<ReceitaVo> receitas = new ArrayList();
    public List<GuiaRecolhimentoEntity> guiasRecolhimento = new ArrayList();
    private GuiaRecolhimentoEntity guiaRecolhimentoSelecionado;
    private List<SolicitacaoRedeSimEntity> consultasRedeSim;
    private FiltroConsultaRedeSim filtro;
    private SolicitacaoRedeSimEntity solicitacaoSelecionada;
    private SolicitacaoRedeSimEntity solicitacaoCancelar;
    private SolicitacaoAlvaraRedeSimDTO arquivoEmpresa;
    private String observacaoExigencia;
    private ExigenciaRedeSimEntity exigenciaSelecionada;
    private Long codigoExigencia;
    private CadastroMobiliarioEntity cadastroMobiliarioGerado;
    private List<LaudoAlvaraEntity> laudosGerados = new ArrayList();
    private List<CadastroMobiliarioEntity> listagemCadastrosMobiliario;
    private CadastroMobiliarioEntity cadastroMobiliarioSelecionado;
    private List<ExigenciaRedeSimEntity> exigencias;
    private List<String> tiposSituacoes;
    private String tipoSituacaoSelecionada;
    private String protocolo;
    private Date dataInicial;
    private Date dataFinal;
    private HistoricoExigenciaRedeSimEntity andamentoSelecionado;
    private SolicitacaoRedeSimDataModel solicitacaoRedeSimDataModel;
    private Date dataAlvaraProvisorio;
    private List<HistoricoExigenciaRedeSimEntity> exigenciasAdicionadas;
    private List<HistoricoExigenciaRedeSimEntity> exigenciasSolicitacaoSelecionada;
    private List<AnexoSolicitacaoRedeSimVo> anexosSolicitacaoSelecionada;
    private List<String> listaObservacoes;
    private Boolean mostraExigencia;
    private Boolean exibeMotivoIndeferimentoRedeSim;
    private String motivoIndeferimento;
    private List<DebitoEntity> listaDebitos = new ArrayList();
    private SolicitacaoRedeSimMenuActionEnum menuAction = SolicitacaoRedeSimMenuActionEnum.NONE;
    private ModeloDocumentoRedeSimEnum modeloDocumentoAnulacao;
    private List<DebitoEntity> listaDebitosSelecionadosParaEnvio = new ArrayList();
    private String numeroSolicitacaoExercicio;
    private List<CategoriaMobiliarioEntity> categoriasMobiliario;
    private CategoriaMobiliarioEntity categoriaSelecionada;
    @Resource
    private ConsultaCadastroImobiliarioController consultaCadastroImobiliarioController;
    @Resource
    private ConsultaEnderecoCadastroGeralController consultaEnderecoCadastroGeralController;
    @Resource
    private EntidadeController entidadeController;
    private List<TipoInscricaoAlvaraEntity> tiposInscricao;
    private List<NaturezaSolicitacaoAlvaraEntity> naturezasSolicitacao;
    private boolean modoSimplificado;
    private boolean geraCadastroLaudoRedeSim = false;
    private boolean todosEventosAptos = false;
    private CidadeEntity cidadeSelecionada;
    private BairroEntity bairroSelecionado;
    private LogradouroEntity logradouroSelecionado;
    private String complementoRural;
    private String cepRural;
    private String numeroLogradouro;

    public String getNumeroLogradouro() {
        return this.numeroLogradouro;
    }

    public void setNumeroLogradouro(String numeroLogradouro) {
        this.numeroLogradouro = numeroLogradouro;
    }

    public String getCepRural() {
        return this.cepRural;
    }

    public void setCepRural(String cepRural) {
        this.cepRural = cepRural;
    }

    public static long getSerialversionuid() {
        return 7809900820490092087L;
    }

    private FacadeRedeSim facadeRedeSim() {
        return FacadeRedeSim.facade();
    }

    public void iniciar(LocalParameterMap requestParameters, ExternalContext context) {
        try {
            this.modoSimplificado = UtilsController.isIntegracaoSimplificadaRedeSim();
            if (!this.modoSimplificado && SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_LAUDO_VIA_INTEGRACAO_REDESIM))) {
                this.atualizaSituacaoDebitoPago();
            }
            this.limparCampos();
            this.instanciarFiltroSolicitacaoRedeSim();
            this.mostraExigencia = false;
            this.exibeMotivoIndeferimentoRedeSim = Boolean.FALSE;
            this.getTiposSituacoesRedeSim();
            this.pesquisar();
            this.listaDebitos.clear();
            this.listaDebitosSelecionadosParaEnvio.clear();
            this.buscarCategoriasMobiliario();
            this.carregarTiposInscricaoAlvara();
            this.carregarNaturezasSolicitacao();
            this.consultaEnderecoCadastroGeralController.loadCidadeAtual();
            this.protocolo = requestParameters.get("protocolo");
            if (!EloStringUtils.isEmpty((String)this.protocolo)) {
                this.solicitacaoSelecionada = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
                this.redirectToConsultaIndividual();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private void carregarNaturezasSolicitacao() throws BaseException {
        this.naturezasSolicitacao = ((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).carregarNaturezasSolicitacaoAtivas();
    }

    private void instanciarFiltroSolicitacaoRedeSim() {
        this.filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().tipo(SimNaoEnum.getSimShortText()).build();
    }

    private void carregarTiposInscricaoAlvara() throws BaseException {
        this.tiposInscricao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }

    public void limparFiltro() throws BaseException {
        this.tipoSituacaoSelecionada = null;
        this.dataInicial = null;
        this.dataFinal = null;
        this.instanciarFiltroSolicitacaoRedeSim();
        this.pesquisar();
    }

    public List<DebitoEntity> getListaDebitos() {
        return this.listaDebitos;
    }

    public void setListaDebitos(List<DebitoEntity> listaDebitos) {
        this.listaDebitos = listaDebitos;
    }

    public List<SolicitacaoRedeSimEntity> getConsultasRedeSim() {
        return this.consultasRedeSim;
    }

    public void setConsultasRedeSim(List<SolicitacaoRedeSimEntity> consultasRedeSim) {
        this.consultasRedeSim = consultasRedeSim;
    }

    public FiltroConsultaRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroConsultaRedeSim filtro) {
        this.filtro = filtro;
    }

    public SolicitacaoAlvaraRedeSimDTO getArquivoEmpresa() {
        return this.arquivoEmpresa;
    }

    public void setArquivoEmpresa(SolicitacaoAlvaraRedeSimDTO arquivoEmpresa) {
        this.arquivoEmpresa = arquivoEmpresa;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoSelecionada() {
        return this.solicitacaoSelecionada;
    }

    public void setSolicitacaoSelecionada(SolicitacaoRedeSimEntity solicitacaoSelecionada) {
        this.solicitacaoSelecionada = solicitacaoSelecionada;
    }

    public Boolean getMostraExigencia() {
        return this.mostraExigencia;
    }

    public HistoricoExigenciaRedeSimEntity getAndamentoSelecionado() {
        return this.andamentoSelecionado;
    }

    public void setAndamentoSelecionado(HistoricoExigenciaRedeSimEntity andamentoSelecionado) {
        this.andamentoSelecionado = andamentoSelecionado;
    }

    public void setMostraExigencia(Boolean mostraExigencia) {
        this.mostraExigencia = mostraExigencia;
    }

    public List<SolicitacaoRedeSimEntity> carregarListaConsultasRedeSim() throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarListaConsultaRedesim(this.filtro);
    }

    public ExigenciaRedeSimEntity getExigenciaSelecionada() {
        return this.exigenciaSelecionada;
    }

    public void setExigenciaSelecionada(ExigenciaRedeSimEntity exigenciaSelecionada) {
        this.exigenciaSelecionada = exigenciaSelecionada;
    }

    public String getObservacaoExigencia() {
        return this.observacaoExigencia;
    }

    public void setObservacaoExigencia(String observacaoExigencia) {
        this.observacaoExigencia = observacaoExigencia;
    }

    public List<String> getListaObservacoes() {
        return this.listaObservacoes;
    }

    public void setListaObservacoes(List<String> listaObservacoes) {
        this.listaObservacoes = listaObservacoes;
    }

    public List<HistoricoExigenciaRedeSimEntity> getExigenciasAdicionadas() {
        return this.exigenciasAdicionadas;
    }

    public void setExigenciasAdicionadas(List<HistoricoExigenciaRedeSimEntity> exigenciasAdicionadas) {
        this.exigenciasAdicionadas = exigenciasAdicionadas;
    }

    public Long getCodigoExigencia() {
        return this.codigoExigencia;
    }

    public void setCodigoExigencia(Long codigoExigencia) {
        this.codigoExigencia = codigoExigencia;
    }

    public List<HistoricoExigenciaRedeSimEntity> getExigenciasSolicitacaoSelecionada() {
        return this.exigenciasSolicitacaoSelecionada;
    }

    public CadastroMobiliarioEntity getCadastroMobiliarioGerado() {
        return this.cadastroMobiliarioGerado;
    }

    public void setCadastroMobiliarioGerado(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliarioGerado = cadastroMobiliario;
    }

    public List<CadastroMobiliarioEntity> getListagemCadastrosMobiliario() {
        return this.listagemCadastrosMobiliario;
    }

    public void setListagemCadastrosMobiliario(List<CadastroMobiliarioEntity> listagemCadastrosMobiliario) {
        this.listagemCadastrosMobiliario = listagemCadastrosMobiliario;
    }

    public CadastroMobiliarioEntity getCadastroMobiliarioSelecionado() {
        return this.cadastroMobiliarioSelecionado;
    }

    public boolean possuiCadastroMobiliario() {
        return Objects.nonNull(this.cadastroMobiliarioSelecionado);
    }

    public boolean isSolicitacaoBaixada() {
        return Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoBaixaRedeSim()) && SimNaoEnum.equalSim((String)this.solicitacaoSelecionada.getSolicitacaoBaixaRedeSim().getBaixado()) != false;
    }

    public void processarSolicitacaoBaixa() throws BaseException {
        try {
            String prefix = "Baixa";
            String token = UUID.randomUUID().toString();
            if (this.facadeRedeSim().processaSolicitacaoBaixaRedeSim(prefix, token, this.solicitacaoSelecionada.getProtocolo())) {
                this.recarregarSolicitacao();
                FacesUtil.execute((String)"PF('dlgBaixaSuccess').show();");
            }
        }
        catch (Exception e) {
            this.recarregarSolicitacao();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public String getCadastroMobiliarioSelecionadoCodigo() {
        return Optional.ofNullable(this.cadastroMobiliarioSelecionado).map(CadastroMobiliarioEntity::getId).map(CadastroGeralAisePK::getCodigo).map(String::valueOf).orElse("");
    }

    public void setCadastroMobiliarioSelecionado(CadastroMobiliarioEntity cadastroMobiliarioSelecionado) {
        this.cadastroMobiliarioSelecionado = cadastroMobiliarioSelecionado;
    }

    public List<String> getTiposSituacoes() {
        return this.tiposSituacoes;
    }

    public void setTiposSituacoes(List<String> tiposSituacoes) {
        this.tiposSituacoes = tiposSituacoes;
    }

    public String getTipoSituacaoSelecionada() {
        return this.tipoSituacaoSelecionada;
    }

    public void setTipoSituacaoSelecionada(String tipoSituacaoSelecionada) {
        this.tipoSituacaoSelecionada = tipoSituacaoSelecionada;
    }

    public void getTiposSituacoesRedeSim() throws BaseException {
        ArrayList<String> tiposSituacoes = new ArrayList<String>();
        for (SituacaoConsultaPreviaRedeSimEnum situacaoEnums : SituacaoConsultaPreviaRedeSimEnum.getSituacoesSolicitacaoRedeSim()) {
            tiposSituacoes.add(situacaoEnums.getTexto());
        }
        this.tiposSituacoes = tiposSituacoes;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public CidadeEntity getCidadeSelecionada() {
        return this.cidadeSelecionada;
    }

    public void setCidadeSelecionada(CidadeEntity cidadeSelecionada) {
        this.cidadeSelecionada = cidadeSelecionada;
    }

    public BairroEntity getBairroSelecionado() {
        return this.bairroSelecionado;
    }

    public void setBairroSelecionado(BairroEntity bairroSelecionado) {
        this.bairroSelecionado = bairroSelecionado;
    }

    public LogradouroEntity getLogradouroSelecionado() {
        return this.logradouroSelecionado;
    }

    public void setLogradouroSelecionado(LogradouroEntity logradouroSelecionado) {
        this.logradouroSelecionado = logradouroSelecionado;
    }

    public String getComplementoRural() {
        return this.complementoRural;
    }

    public void setComplementoRural(String complementoRural) {
        this.complementoRural = complementoRural;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public Date getDataAlvaraProvisorio() {
        return this.dataAlvaraProvisorio;
    }

    public void setDataAlvaraProvisorio(Date dataAlvaraProvisorio) {
        this.dataAlvaraProvisorio = dataAlvaraProvisorio;
    }

    public List<ExigenciaRedeSimEntity> getExigencias() {
        return this.exigencias;
    }

    public void setExigencias(List<ExigenciaRedeSimEntity> exigencias) {
        this.exigencias = exigencias;
    }

    public String getNumeroSolicitacaoExercicio() {
        return this.numeroSolicitacaoExercicio;
    }

    public void setNumeroSolicitacaoExercicio(String numeroSolicitacaoExercicio) {
        this.numeroSolicitacaoExercicio = numeroSolicitacaoExercicio;
    }

    public String getNomeSolicitante(SolicitacaoRedeSimEntity solicitacao) throws SolicitacaoAlvaraRedeSimException {
        try {
            JsonNode jsonNode = null;
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonInString = solicitacao.getArquivoDadosEmpresa();
            jsonNode = objectMapper.readTree(jsonInString);
            if (Objects.nonNull(jsonNode) && Objects.nonNull(jsonNode.get("dados_solicitacao").get("solicitante")) && Objects.nonNull(jsonNode.get("dados_solicitacao").get("solicitante").get("ds_nome"))) {
                return jsonNode.get("dados_solicitacao").get("solicitante").get("ds_nome").toString();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Ocorreu uma falha ao carregar o nome do solicitante", e.getCause());
            throw new SolicitacaoAlvaraRedeSimException(e.getMessage());
        }
        return "";
    }

    public void setExigenciasSolicitacaoSelecionada(List<HistoricoExigenciaRedeSimEntity> exigenciasSolicitacaoSelecionada) {
        this.exigenciasSolicitacaoSelecionada = exigenciasSolicitacaoSelecionada;
    }

    public List<AnexoSolicitacaoRedeSimVo> getAnexosSolicitacaoSelecionada() {
        return this.anexosSolicitacaoSelecionada;
    }

    public void setAnexosSolicitacaoSelecionada(List<AnexoSolicitacaoRedeSimVo> anexosSolicitacaoSelecionada) {
        this.anexosSolicitacaoSelecionada = anexosSolicitacaoSelecionada;
    }

    public List<CategoriaMobiliarioEntity> getCategoriasMobiliario() {
        return this.categoriasMobiliario;
    }

    public void setCategoriasMobiliario(List<CategoriaMobiliarioEntity> categoriasMobiliario) {
        this.categoriasMobiliario = categoriasMobiliario;
    }

    public CategoriaMobiliarioEntity getCategoriaSelecionada() {
        return this.categoriaSelecionada;
    }

    public void setCategoriaSelecionada(CategoriaMobiliarioEntity categoriaSelecionada) {
        this.categoriaSelecionada = categoriaSelecionada;
    }

    public List<TipoInscricaoAlvaraEntity> getTiposInscricao() {
        return this.tiposInscricao;
    }

    public void setTiposInscricao(List<TipoInscricaoAlvaraEntity> tiposInscricao) {
        this.tiposInscricao = tiposInscricao;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezasSolicitacao() {
        return this.naturezasSolicitacao;
    }

    public void setNaturezasSolicitacao(List<NaturezaSolicitacaoAlvaraEntity> naturezasSolicitacao) {
        this.naturezasSolicitacao = naturezasSolicitacao;
    }

    public List<ExigenciaRedeSimEntity> complete(String query) {
        List exigencias = null;
        try {
            exigencias = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getListaDescExigenciaRedeSim(query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return exigencias;
    }

    public String arquivoEmpresaGetDescNatJur(String id) throws BaseException {
        id = id.replace("-", "");
        NaturezaJuridicaEntity naturezaJuridica = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getNaturezaJuridica(id);
        if (naturezaJuridica != null) {
            return naturezaJuridica.getDescricao();
        }
        return null;
    }

    public String arquivoEmpresaGetDescricaoEventoRedeSim(Long eventoCodigo) throws BaseException {
        EventoRedeSimEntity evento = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getEventoRedeSim(eventoCodigo);
        if (evento != null) {
            return evento.getDescricao();
        }
        return null;
    }

    public String arquivoEmpresaGetDescricaoCnae(String codigoAtividade) throws BaseException {
        codigoAtividade = codigoAtividade.replace("/", "").replace("-", "");
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getDescricaoCnae(codigoAtividade);
    }

    public String arquivoEmpresaGetNomeCidade(long codigo, boolean comDigitoVerificador) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getNomeCidade(codigo, comDigitoVerificador);
    }

    public ExigenciaRedeSimEntity getExigenciaRedeSimPorCodigo(long codigo) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getExigenciaRedeSimPorCodigo(Long.valueOf(codigo));
    }

    public void salvarHistoricoExigenciasRedeSim(SolicitacaoRedeSimEntity solicitacao, List<HistoricoExigenciaRedeSimEntity> historico) throws BaseException {
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarHistoricoExigenciasRedeSim(solicitacao, historico);
    }

    public void pesquisar() throws SolicitacaoAlvaraException {
        try {
            if (!this.filtro.isFiltroValido().booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Filtro inv\u00e1lido.");
            }
            if (this.filtro.getDataInicial() != null && this.filtro.getDataInicial().compareTo(this.filtro.getDataFinal()) > 0) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"A data inicial n\u00e3o pode ser maior que a data final.");
                return;
            }
            this.filtro.setDataFinal(EloDateUtils.getEnd((Date)this.filtro.getDataFinal()));
            if (!EloStringUtils.isEmpty((String)this.filtro.getNumeroExercicioSolicitacao())) {
                Long[] solicitacaoExercicio = UtilsController.separarNumeroExercicioSolicitacao((String)this.filtro.getNumeroExercicioSolicitacao());
                if (Objects.nonNull(solicitacaoExercicio)) {
                    this.filtro.setNumeroSolicitacao(solicitacaoExercicio[0]);
                    this.filtro.setExercicioSolicitacao(solicitacaoExercicio[1]);
                } else {
                    return;
                }
            }
            this.setSolicitacaoRedeSimDataModel(new SolicitacaoRedeSimDataModel(this.filtro));
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("%s%s", "Ocorreu uma falha na pesquisa", e.getMessage()));
            throw new SolicitacaoAlvaraException("Falha ao fazer pesquisa na rotina inicial ", e.getCause());
        }
    }

    public void redirectToConsultaIndividual() throws SolicitacaoAlvaraException {
        try {
            if (this.solicitacaoSelecionada.getSituacao().equals(SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla())) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Essa solicita\u00e7\u00e3o deve ser corrigida e processada novamente!");
                return;
            }
            String numeroSolicitacao = this.getNumeroSolicitacao(this.solicitacaoSelecionada);
            if (EloStringUtils.isEmpty((String)numeroSolicitacao)) {
                FacesUtil.execute((String)"dlgSolicitacaoNaoEncontrada.show()");
                return;
            }
            if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoBaixaRedeSim())) {
                this.getCadastroMobiliario();
                return;
            }
            SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaByProtocolo(this.solicitacaoSelecionada.getProtocolo());
            if (Objects.nonNull(solicitacaoRedeSim) && SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equals(solicitacaoRedeSim.getSituacao())) {
                FacesUtil.execute((String)"dlgConsultaEmAnalise.show()");
                return;
            }
            this.getCadastroMobiliario();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma Falha, Entre em contato o Suporte! ");
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void getCadastroMobiliario() throws BaseException {
        this.arquivoEmpresa = PortalUtils.normalizeJson((String)this.solicitacaoSelecionada.getArquivoDadosEmpresa());
        this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
        this.montarAnexosSolicitacaoVo();
        String cnpjCpf = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCpfCnpj();
        this.logger.info((Object)String.format("Sol %d/%s - buscando cadastros mobili\u00e1rios para o cnpj %s", this.solicitacaoSelecionada.getId(), this.solicitacaoSelecionada.getProtocolo(), cnpjCpf));
        this.listagemCadastrosMobiliario = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getCadastroMobiliarioPorCpfCnpj(cnpjCpf);
        this.cadastroMobiliarioSelecionado = null;
        this.cadastroMobiliarioGerado = null;
        if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario())) {
            this.cadastroMobiliarioSelecionado = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario();
            this.logger.info((Object)String.format("Sol %d/%s - cadastro mobili\u00e1rio selecionado: %s", this.solicitacaoSelecionada.getId(), this.solicitacaoSelecionada.getProtocolo(), this.cadastroMobiliarioSelecionado.getId().getCodigo()));
        } else {
            Optional.ofNullable(this.listagemCadastrosMobiliario).orElse(Collections.emptyList()).forEach(cadastroMobiliario -> {
                this.logger.info((Object)String.format("Sol %d/%s - cadastro mobili\u00e1rio encontrado: %d", this.solicitacaoSelecionada.getId(), this.solicitacaoSelecionada.getProtocolo(), cadastroMobiliario.getId().getCodigo()));
                if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario()) && cadastroMobiliario.getCadastroGeral().getId().getCodigo().equals(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario().getId().getCodigo())) {
                    this.logger.info((Object)String.format("Sol %d/%s - cadastro mobili\u00e1rio selecionado: %s", this.solicitacaoSelecionada.getId(), this.solicitacaoSelecionada.getProtocolo(), cadastroMobiliario.getId().getCodigo()));
                    this.cadastroMobiliarioSelecionado = cadastroMobiliario;
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setCadastroMobiliario(cadastroMobiliario);
                }
            });
        }
        try {
            RequestContext requestContext = RequestContextHolder.getRequestContext();
            RequestControlContext rec = (RequestControlContext)requestContext;
            if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoBaixaRedeSim())) {
                rec.handleEvent(new Event((Object)this, "toSolicitacaoBaixaRedeSim"));
                return;
            }
            rec.handleEvent(new Event((Object)this, "toSolicitacaoIndividualRedeSim"));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro mobili\u00e1rio.");
        }
    }

    public String getPorteEmpresa(int codigo) {
        return EnquadramentoEmpresaEnum.fromCodigo((Integer)codigo).getDescricao();
    }

    public void limparCampos() {
        this.filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        this.filtro.limpar();
        this.inicializarListaSolicitacoes();
        this.observacaoExigencia = null;
        this.cadastroMobiliarioSelecionado = null;
        this.exigenciasAdicionadas = new ArrayList();
        this.listaObservacoes = new ArrayList();
        this.tipoSituacaoSelecionada = null;
        this.categoriaSelecionada = null;
    }

    public void inicializarListaSolicitacoes() {
        this.arquivoEmpresa = new SolicitacaoAlvaraRedeSimDTO();
        if (this.consultasRedeSim == null) {
            this.consultasRedeSim = new ArrayList();
        } else {
            this.consultasRedeSim.clear();
        }
    }

    public String getTextFromSituacao(String sigla) {
        for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!situacao.getSigla().equals(sigla)) continue;
            return situacao.getTexto();
        }
        return sigla;
    }

    public void alterarSituacaoParaAnalise() {
        try {
            ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).alterarSituacaoMobiliario(this.solicitacaoSelecionada.getSolicitacaoAlvara(), SituacaoMobiliarioAlvaraEnum.SITUACAO_INICIAL_MOBILIARIO);
            this.cadastroMobiliarioGerado = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario();
            this.logger.info((Object)String.format("alterado situacao para analisa n\u00famero cadastro %d ", this.cadastroMobiliarioGerado.getId().getCodigo()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void gerarAtualizarCadastro() {
        try {
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() && this.solicitacaoSelecionada.isSituacaoInconsistente() && this.listagemCadastrosMobiliario.size() == 0) {
                FacesUtil.execute((String)"PF('dlgGeracaoCadastroMobiliarioSolicitacaoDeAlteracaoInconsistente').show();");
                return;
            }
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() && this.listagemCadastrosMobiliario.size() > 1 && this.cadastroMobiliarioSelecionado == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um Cadastro Mobili\u00e1rio!");
            } else {
                if (this.solicitacaoSelecionada.isRuralArquivoEmpresa()) {
                    FacesUtil.execute((String)"PF('dlgDadosEnderecoRural').show();");
                    return;
                }
                if (this.solicitacaoSelecionada.isSolicitacaoBaixa() || !this.isSolicitacaoMeiSemConsultaPrevia(this.solicitacaoSelecionada)) {
                    this.saveOrUpdateCadastroMobiliario();
                } else if (this.isRealizaConsultaViabilidadeNaSolicitacao()) {
                    FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaComAnaliseViabilidade').show();");
                } else {
                    FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaSemAnaliseViabilidade').show();");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void verificarCadastroImobiliarioSolicitacaoMeiSemConsultaPrevia() throws BaseException {
        try {
            boolean enviaInscricaoMunicipalDadosAtualizados;
            if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isMeiInicial() && Objects.isNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario()) && !Optional.ofNullable(this.solicitacaoSelecionada).map(SolicitacaoRedeSimEntity::isInscricaoEnviada).orElse(false).booleanValue() && UtilsController.isUsuarioTecnicoOuMaster() && (enviaInscricaoMunicipalDadosAtualizados = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue())) {
                String prefix = "MEI - Gera\u00e7\u00e3o cadastro sem consulta pr\u00e9via";
                String token = UUID.randomUUID().toString();
                ((SrvSolicitacaoAlvaraRedeSimImpl)SpringContext.getBean(SrvSolicitacaoAlvaraRedeSimImpl.class)).generateCadastroMobiliarioAndInscricaoMunicipal(prefix, token, this.solicitacaoSelecionada.getProtocolo());
                this.recarregarSolicitacao();
                FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaSemAnaliseViabilidade').hide();");
                FacesUtil.execute((String)"window.location.reload();");
                return;
            }
            SolicitacaoAlvaraRedeSimDTO arquivoEmpresaSelecionada = PortalUtils.normalizeJson((String)this.solicitacaoSelecionada.getArquivoDadosEmpresa());
            ProcessaConsulta processaConsulta = (ProcessaConsulta)SpringContext.getBean(ProcessaConsulta.class);
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isAlteracaoRazaoOuSocioOuRazaoESocio() && !this.solicitacaoSelecionada.getSolicitacaoAlvara().possuiSomenteNatureza(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_NATUREZA_JURIDICA)) {
                CadastroImobiliarioEntity cie = processaConsulta.carregaCadastroImobiliario(this.solicitacaoSelecionada.getSolicitacaoAlvara(), this.getNu_Inscricao(arquivoEmpresaSelecionada));
                this.solicitacaoSelecionada.getSolicitacaoAlvara().setCadastroImobiliario(cie);
                if (UtilsController.isTestadaGenerica()) {
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setImobiliarioTestadaGenerica(cie.getTestadaPrincipalGenerica());
                } else {
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setImobiliarioTestada(cie.getTestadaPrincipal());
                }
            }
            FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaSemAnaliseViabilidade').hide();");
            this.saveOrUpdateCadastroMobiliario();
        }
        catch (CadastroImobiliarioNaoEncontradoException cine) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o foi encontrado o Cadastro Imobili\u00e1rio informado. ");
            this.consultaCadastroImobiliarioController.setRedeSim(true);
            this.showConsultaCadastro();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private void showConsultaCadastro() throws BaseException {
        if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoMEI() && SimNaoEnum.getSimShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INFORMAR_ENDERECO_MEI))) {
            if (!this.solicitacaoSelecionada.isEnderecoCadastroGeralValido().booleanValue()) {
                FacesUtil.execute((String)"PF('consultaEnderecoCadastroGeralDialog').show();");
            } else {
                this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ENDERECO_ALTERADO, Optional.of("O Cadastro foi alterado com sucesso"));
                this.recarregarSolicitacao();
                FacesUtil.execute((String)"window.location.reload();");
            }
        } else {
            FacesUtil.execute((String)"PF('consultaCadastroImobiliarioDialog').show();");
        }
    }

    public void realizarConsultaViabilidadeMeiSemConsultaPrevia() throws BaseException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).realizarConsultaViabilidadeMei(this.solicitacaoSelecionada);
            FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaComAnaliseViabilidade').hide();");
            FacesUtil.execute((String)"PF('dlgConsultaViabilidadeSuccess').show();");
        }
        catch (CadastroImobiliarioNaoEncontradoException cine) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o foi encontrado o Cadastro Imobili\u00e1rio informado. ");
            this.consultaCadastroImobiliarioController.setRedeSim(true);
            this.showConsultaCadastro();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void selecionarCadastroImobiliarioSolicitacaoMeiSemConsultaPrevia() throws BaseException {
        String paramInformarEnderecoMEI = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INFORMAR_ENDERECO_MEI);
        if (SimNaoEnum.getNaoShortText().equals(paramInformarEnderecoMEI)) {
            if (this.consultaCadastroImobiliarioController.getCadastroImobiliario() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro imobili\u00e1rio.");
                return;
            }
            if (!UtilsController.isUtilizaEnderecoCadastroGeral() && this.consultaCadastroImobiliarioController.getSelectedTestada() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Testada principal n\u00e3o encontrada no cadastro imobili\u00e1rio.");
                return;
            }
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setCadastroImobiliario(this.consultaCadastroImobiliarioController.getCadastroImobiliario());
        }
        try {
            if (this.isRealizaConsultaViabilidadeNaSolicitacao()) {
                this.realizarConsultaViabilidadeMeiSemConsultaPrevia();
            } else {
                if (!UtilsController.isUtilizaEnderecoCadastroGeral()) {
                    this.setarTestadaSelecionada();
                }
                if (SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                    this.saveOrUpdateCadastroMobiliario();
                }
                if (SimNaoEnum.getSimShortText().equals(paramInformarEnderecoMEI)) {
                    if (this.consultaEnderecoCadastroGeralController.isEnderecoInvalido().booleanValue()) {
                        ShowMessage.addErrorMessage((String)"validacao", (String)"Preencha corretamente o endere\u00e7o.");
                        return;
                    }
                    if (Objects.isNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario())) {
                        ShowMessage.addErrorMessage((String)"validacao", (String)"Cadastro Mobili\u00e1rio n\u00e3o encontrado.");
                        return;
                    }
                    this.consultaEnderecoCadastroGeralController.setNewAddress(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral());
                    FacadeSolicitacaoAlvara facadeSolicitacaoAlvara = (FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class);
                    facadeSolicitacaoAlvara.salvarCadastroGeral(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                    facadeSolicitacaoAlvara.salvarEnderecoPessoa(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getPessoa());
                    this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ENDERECO_ALTERADO, Optional.of("O Cadastro foi alterado com sucesso"));
                    FacesUtil.execute((String)"PF('consultaEnderecoCadastroGeralDialog').hide();");
                    FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaSemAnaliseViabilidade').hide();");
                    this.recarregarSolicitacao();
                    FacesUtil.execute((String)"window.location.reload();");
                    return;
                }
                if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial()) {
                    FacesUtil.execute((String)"PF('dlgSolicitacaoMeiSemConsultaPreviaSemAnaliseViabilidade').show();");
                } else {
                    FacesUtil.execute((String)"PF('dlgSolicitacaoAlteracaoCadastroMob').show();");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private void setarTestadaSelecionada() throws BaseException {
        if (UtilsController.isTestadaGenerica()) {
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setTestada((Testada)((CadastroImobiliarioTestadaGenericaEntity)this.consultaCadastroImobiliarioController.getSelectedTestada()));
        } else {
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setTestada((Testada)((CadastroImobiliarioTestadaEntity)this.consultaCadastroImobiliarioController.getSelectedTestada()));
        }
    }

    public void saveOrUpdateCadastroMobiliario() throws SolicitacaoAlvaraException {
        if (Objects.isNull(this.cadastroMobiliarioSelecionado)) {
            if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario())) {
                this.cadastroMobiliarioSelecionado = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario();
                this.logger.info((Object)String.format("Cadastro mobiliario selecionado..%d ", this.cadastroMobiliarioSelecionado.getId().getCodigo()));
            } else if (this.listagemCadastrosMobiliario.size() > 1) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro mobili\u00e1rio.");
                return;
            }
        }
        try {
            if (this.solicitacaoSelecionada.isInscricaoEnviada()) {
                if (((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).existsScriptsGeracaoLaudoAlvara() && !((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).existsSolicitacaoDocumentoRedeSim(this.solicitacaoSelecionada.getProtocolo(), TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo())) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi poss\u00edvel gerar os laudos, favor verificar a solicita\u00e7\u00e3o do Alvar\u00e1 no Empresa F\u00e1cil.");
                    return;
                }
                ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).generateLaudosRedeSim(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                this.recarregarSolicitacao();
                if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() && !EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionada.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.of("O Cadastro se encontra com situa\u00e7\u00e3o em An\u00e1lise, e os Laudos j\u00e1 foram Disparados para as Secretarias!"));
                }
                FacesUtil.execute((String)"PF('dlgGerarLaudosCadastroMobiliario').show();");
                this.recarregarSolicitacao();
                return;
            }
            SolicitacaoAlvaraEntity solicitacaoAlvara = this.solicitacaoSelecionada.getSolicitacaoAlvara();
            solicitacaoAlvara.setCadastroMobiliario(this.cadastroMobiliarioSelecionado);
            if (this.solicitacaoSelecionada.isRuralArquivoEmpresa()) {
                this.setEnderecoSolicitacao(solicitacaoAlvara);
            }
            this.validarAlteracaoDeEnderecoSemAtividadeNoMobiliario(solicitacaoAlvara);
            if (solicitacaoAlvara.isNaturezaInicial()) {
                if (solicitacaoAlvara.isSolicitacaoPJ() && this.habilitaCategoriaPj()) {
                    FacesUtil.execute((String)"PF('selecionarCategoriaDialogWidgetVar').show();");
                    return;
                }
                this.cadastroMobiliarioGerado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).saveOrUpdateMobiliarioByRedeSim(this.solicitacaoSelecionada, Optional.empty());
            } else {
                if (this.solicitacaoSelecionada.isSolicitacaoBaixa()) {
                    this.cadastroMobiliarioSelecionado = this.cadastroMobiliarioGerado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).saveOrUpdateMobiliarioByRedeSim(this.solicitacaoSelecionada, Optional.empty());
                    this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_BAIXA, Optional.of("O Cadastro foi gerado com sucesso"));
                    this.recarregarSolicitacao();
                    FacesUtil.execute((String)"window.location.reload();");
                    return;
                }
                if (Objects.isNull(this.cadastroMobiliarioSelecionado)) {
                    throw new SolicitacaoAlvaraException("N\u00e3o existe um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
                }
                SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)this.solicitacaoSelecionada.getArquivoDadosEmpresa());
                if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
                    solicitacaoAlvara.setDescricaoAtividades(PortalUtils.getDescricaoAtividadesMei((SolicitacaoAlvaraEntity)solicitacaoAlvara));
                } else {
                    solicitacaoAlvara.setDescricaoAtividades(solicitacaoDTO.getDados_solicitacao().getEmpresa().getDs_objeto_social());
                }
                if (!solicitacaoAlvara.isNaturezaInicial() && !solicitacaoAlvara.isAlteracaoRazao()) {
                    solicitacaoAlvara.setNomeRazaoSocial(this.cadastroMobiliarioSelecionado.getCadastroGeral().getPessoa().getNome());
                    solicitacaoAlvara.setFantasia(this.cadastroMobiliarioSelecionado.getCadastroGeral().getPessoa().getNomeFantasia());
                }
                boolean geraLaudos = false;
                if (!solicitacaoAlvara.isSolicitacaoMEI() && solicitacaoAlvara.isGrauRiscoBaixo() && SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_LAUDO_RISCO_B)).booleanValue()) {
                    geraLaudos = true;
                }
                if (!this.solicitacaoSelecionada.isSolicitacaoBaixa() && (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)).booleanValue() || SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)).booleanValue() && !solicitacaoAlvara.isGrauRiscoLiberdadeEconomica())) {
                    geraLaudos = true;
                }
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraAlteracao(this.solicitacaoSelecionada.getSolicitacaoAlvara(), geraLaudos);
                if (this.modoSimplificado) {
                    this.efetivarAlteracaoSolicitacao();
                }
            }
            this.finalizarUpdateOrSaveCadastroMobiliario();
            if (!this.solicitacaoSelecionada.isSolicitacaoBaixa() && SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_EM_EXCLUSAO_LOGICA)) && SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                this.alterarSituacaoParaAnalise();
            }
            FacesUtil.execute((String)"PF('dlgDadosEnderecoRural').hide();");
        }
        catch (AtividadeNaoConfiguradaException | SolicitacaoAlvaraException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Ocorreu um erro inesperado ao gerar o cadastro. Entre em contato com o suporte.");
        }
    }

    private void setEnderecoSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        solicitacaoAlvara.setLogradouro(this.logradouroSelecionado.getId().getLogradouro());
        solicitacaoAlvara.setCidadeLogradouro(this.cidadeSelecionada.getId());
        solicitacaoAlvara.setBairro(this.bairroSelecionado.getId().getBairro());
        solicitacaoAlvara.setCidadeBairro(this.cidadeSelecionada.getId());
        solicitacaoAlvara.setCep(Long.valueOf(Long.parseLong(this.cepRural.replace("-", ""))));
        solicitacaoAlvara.setComplementoLogradouro(this.complementoRural);
        solicitacaoAlvara.setNumero(this.numeroLogradouro);
    }

    private void validarAlteracaoDeEnderecoSemAtividadeNoMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        if (solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && !solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && this.isListaAtividadesMobiliarioVazia(solicitacaoAlvara)) {
            throw new SolicitacaoAlvaraException("Este Cadastro Mobili\u00e1rio n\u00e3o possui nenhuma atividade vinculada. Verifique com o setor respons\u00e1vel e depois tente novamente.");
        }
    }

    private boolean isListaAtividadesMobiliarioVazia(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        CadastroMobiliarioEntity cadastroMobiliario = solicitacaoAlvara.getCadastroMobiliario();
        return cadastroMobiliario != null && EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioCnaes()) != false && EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioAtividadeMeis()) != false;
    }

    public void confirmarSelecaoCategoriaMobiliario() throws BaseException {
        try {
            if (Objects.isNull(this.categoriaSelecionada)) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione uma categoria!");
                return;
            }
            this.cadastroMobiliarioGerado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).saveOrUpdateMobiliarioByRedeSim(this.solicitacaoSelecionada, Optional.of(this.categoriaSelecionada));
            this.logger.info((Object)String.format("Sol %d - cadastroMobiliarioGerado  Selecao categoria ", this.cadastroMobiliarioGerado.getId().getCodigo()));
            this.finalizarUpdateOrSaveCadastroMobiliario();
            this.categoriaSelecionada = null;
            FacesUtil.execute((String)"PF('selecionarCategoriaDialogWidgetVar').hide();");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private void finalizarUpdateOrSaveCadastroMobiliario() throws BaseException {
        String complementoObservacao;
        this.recarregarSolicitacao();
        String string = complementoObservacao = this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() ? "Gerado" : "Atualizado";
        if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
            this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_LIBERDADE_ECONOMICA, Optional.of(String.format("O Cadastro foi %s com sucesso - Liberdade Econ\u00f4mica", complementoObservacao)));
        } else if (EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionada.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
            if (this.modoSimplificado) {
                this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_MODO_SIMPLIFICADO, Optional.of("O Cadastro foi atualizado com modo Simplificado"));
            } else {
                this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_ANALISE, Optional.of(String.format("O Cadastro foi %s para situa\u00e7\u00e3o em An\u00e1lise", complementoObservacao)));
            }
        }
        if (this.isModoSimplificado() || !this.isModoSimplificado() && this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial()) {
            this.callWebIssIntegracao(this.solicitacaoSelecionada);
        }
        if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
            this.facadeRedeSim().generateAndSendInscricaoMunicipalRedeSim(this.solicitacaoSelecionada);
            this.facadeRedeSim().updateSolicitacaoEnvioInscricaoMunicipal(this.solicitacaoSelecionada);
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoMEI() && !this.facadeRedeSim().existsSolicitacaoDocumentoRedeSim(this.solicitacaoSelecionada.getProtocolo(), TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo()) && EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionada.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO, Optional.empty());
            }
        }
        if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() && !EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionada.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
            this.facadeRedeSim().adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.of("O Cadastro se encontra com situa\u00e7\u00e3o em An\u00e1lise, e os Laudos j\u00e1 foram Disparados para as Secretarias!"));
        }
        if (this.cadastroMobiliarioGerado != null && this.cadastroMobiliarioGerado.equals((Object)this.cadastroMobiliarioSelecionado)) {
            FacesUtil.execute((String)"PF('dlgAlteracaoCadastroMobiliario').show();");
        } else if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial()) {
            FacesUtil.execute((String)"PF('dlgGerarCadastroMobiliario').show();");
        }
        this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
    }

    public String getMensagemCadastroAtualizadoComSucesso() throws BaseException {
        if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
            return " A Inscri\u00e7\u00e3o municipal foi gerada e enviada para a Rede Sim!";
        }
        return "";
    }

    public void efetivarAlteracaoSolicitacao() {
        try {
            if (Objects.isNull(this.cadastroMobiliarioSelecionado)) {
                if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario())) {
                    this.cadastroMobiliarioSelecionado = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario();
                } else if (this.listagemCadastrosMobiliario.size() > 1) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro mobili\u00e1rio.");
                    return;
                }
            }
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setCadastroMobiliario(this.cadastroMobiliarioSelecionado);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).efetivarAlteracaoSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara());
            this.recarregarSolicitacao();
            this.cadastroMobiliarioGerado = this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private List<HistoricoExigenciaRedeSimEntity> getHistoricoExigenciasSolicitacaoSelecionada() throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getHistoricoPorSolicitacaoId(this.solicitacaoSelecionada.getId());
    }

    private void buscarCategoriasMobiliario() throws BaseException {
        this.categoriasMobiliario = ((FacadeCategoriaMobiliario)SpringContext.getBean(FacadeCategoriaMobiliario.class)).carregarCategoriasMobiliario();
    }

    public void carregarListaExigencias() {
        try {
            this.exigencias = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarExigenciasRedeSimAtivas();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao carregar a lista de exig\u00eancias.");
        }
    }

    public void actionGerarLaudos() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_LAUDOS;
        try {
            if (EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionada.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                this.laudosGerados.clear();
                SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)this.solicitacaoSelecionada.getArquivoDadosEmpresa());
                SolicitacaoAlvaraEntity solicitacaoAlvara = this.solicitacaoSelecionada.getSolicitacaoAlvara();
                if (EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).preencherSolcitacaoAlvaraAtividades(solicitacaoAlvara, solicitacaoDTO.getDados_solicitacao().getEmpresa().getAtividades());
                }
                ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).gerarLaudos(solicitacaoAlvara);
                if (!solicitacaoAlvara.getLaudos().isEmpty()) {
                    this.laudosGerados.addAll(solicitacaoAlvara.getLaudos());
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.empty());
                    FacesUtil.execute((String)"PF('dlgLaudosGerados').show();");
                } else {
                    ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhum laudo foi gerado para esta solicita\u00e7\u00e3o");
                }
                this.recarregarSolicitacao();
            } else {
                FacesUtil.execute((String)"PF('dlgLaudosJaExistentes').show();");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        finally {
            FacesUtil.execute((String)"statusDialog.hide()");
        }
    }

    private void recarregarSolicitacao() throws BaseException {
        this.solicitacaoSelecionada = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.solicitacaoSelecionada.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
    }

    public Boolean enviaAlvaraProvisorio() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_ALVARA_PROVISORIO_REDE_SIM));
    }

    public Boolean disableBotaoAlvaraProvisorio() throws BaseException {
        return Objects.isNull(this.solicitacaoSelecionada.getSolicitacaoAlvara().getCadastroMobiliario()) || this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() || this.isIndeferido() != false;
    }

    public void generateAlvaraProvisorio() throws BaseException {
        if (Objects.nonNull(this.dataAlvaraProvisorio)) {
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setDataValidadeProvisorio(this.dataAlvaraProvisorio);
        } else {
            this.solicitacaoSelecionada.getSolicitacaoAlvara().setDataValidadeProvisorio(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).calcularDataAlvaraProvisorio());
        }
        this.solicitacaoSelecionada.getSolicitacaoAlvara().setObservacoes("");
        this.solicitacaoSelecionada.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
        this.solicitacaoSelecionada.setSolicitacaoAlvara(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarObsAlvaraRedeSim(this.solicitacaoSelecionada));
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarAlvaraRedeSim(this.solicitacaoSelecionada.getSolicitacaoAlvara());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarObsAlvaraGerado(this.solicitacaoSelecionada.getSolicitacaoAlvara());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"));
        this.recarregarSolicitacao();
        FacesUtil.execute((String)"dialogAlvaraProvisorioBaixoRiscoWidgetVar.hide()");
        FacesUtil.execute((String)"dlgEnviarAlvaraProvisorio.show()");
    }

    public void generateAlvaraDefinitivo() throws BaseException {
        this.solicitacaoSelecionada.getSolicitacaoAlvara().setDataValidadeProvisorio(null);
        this.solicitacaoSelecionada.getSolicitacaoAlvara().setObservacoes("");
        this.solicitacaoSelecionada.setAlvaraEnviado(TipoAlvaraEnum.DEFINITIVO);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
        this.solicitacaoSelecionada.setSolicitacaoAlvara(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarObsAlvaraRedeSim(this.solicitacaoSelecionada));
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarAlvaraRedeSim(this.solicitacaoSelecionada.getSolicitacaoAlvara());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarObsAlvaraGerado(this.solicitacaoSelecionada.getSolicitacaoAlvara());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.ALVARA_EMITIDO, Optional.empty());
        FacesUtil.execute((String)"dlgVerificaDebito.hide()");
        FacesUtil.execute((String)"dialogAlvaraProvisorioBaixoRiscoWidgetVar.hide()");
        FacesUtil.execute((String)"dialogGerarAlvaraSemLaudosDeferidosWidgetVar.hide()");
        if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isAlteracao()) {
            this.callWebIssIntegracao(this.solicitacaoSelecionada);
        }
        if (!SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS.equals((Object)this.menuAction)) {
            this.recarregarSolicitacao();
            FacesUtil.execute((String)"dlgEnviarAlvaraDefinitivo.show()");
        } else {
            this.enviarAlvaraDefinitivo();
        }
    }

    private void generateAlvara() throws BaseException {
        Boolean gerarAlvaraProvisorio = this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoBaixo() && Boolean.TRUE.equals(this.enviaAlvaraProvisorio()) && !this.solicitacaoSelecionada.getSolicitacaoAlvara().possuiTodosLaudosLiberadoDefinitivo();
        if (SolicitacaoRedeSimMenuActionEnum.GERAR_ALVARA_PROVISORIO.equals((Object)this.menuAction) || Boolean.TRUE.equals(gerarAlvaraProvisorio)) {
            this.calcularDataAlvaraProvisorioEMostrarDialog();
        } else if (SolicitacaoRedeSimMenuActionEnum.GERAR_ALVARA_DEFINITIVO.equals((Object)this.menuAction) || Boolean.FALSE.equals(gerarAlvaraProvisorio) || this.solicitacaoSelecionada.getSolicitacaoAlvara().possuiTodosLaudosLiberadoDefinitivo()) {
            this.gerarAlvaraDefinitivo();
        }
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
    }

    private Boolean isAlvaraDefinitivoEnviado() {
        return TipoAlvaraEnum.alvaraDefinitivo((TipoAlvaraEnum)this.solicitacaoSelecionada.getAlvaraEnviado());
    }

    public void actionGerarAlvaraProvisorio() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_ALVARA_PROVISORIO;
        try {
            if (Boolean.TRUE.equals(this.isAlvaraDefinitivoEnviado())) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"O Alvar\u00e1 definitivo j\u00e1 foi enviado para o Empresa F\u00e1cil.");
                return;
            }
            if (this.solicitacaoSelecionada.getSolicitacaoAlvara().possuiTodosLaudosLiberadoDefinitivo()) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Todos os laudos j\u00e1 foram liberados em definitivo. Prossiga para gera\u00e7\u00e3o do alvar\u00e1.");
                return;
            }
            if (Strings.isNullOrEmpty((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.DIASALVARAPROVISORIO).getValor())) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"O par\u00e2metro DIASALVARAPROVISORIO n\u00e3o configurado.");
                return;
            }
            if (!this.possuiDebitoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara())) {
                FacesUtil.execute((String)"dlgVerificaDebito.show()");
                return;
            }
            Boolean existeAlvaraProvisorioEnviado = UtilsController.existeHistoricoAlvaraProvisorioEnviado((SolicitacaoRedeSimEntity)this.solicitacaoSelecionada);
            Date dataValidadeRiscoBaixoAtual = this.solicitacaoSelecionada.getSolicitacaoAlvara().getDataValidadeProvisorio();
            if (Boolean.TRUE.equals(existeAlvaraProvisorioEnviado)) {
                if (Objects.nonNull(dataValidadeRiscoBaixoAtual) && dataValidadeRiscoBaixoAtual.compareTo(new Date()) <= 0) {
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setRenovacao(SimNaoEnum.getSimShortText());
                }
                FacesUtil.execute((String)"dlgAlvaraProvisorioEnviado.show()");
                return;
            }
            this.dataAlvaraProvisorio = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).calcularDataAlvaraProvisorio();
            FacesUtil.execute((String)"dialogAlvaraProvisorioBaixoRiscoWidgetVar.show()");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void calcularDataAlvaraProvisorioEMostrarDialog() throws BaseException {
        this.dataAlvaraProvisorio = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).calcularDataAlvaraProvisorio();
        FacesUtil.execute((String)"dlgVerificaDebito.hide()");
        FacesUtil.execute((String)"dlgAlvaraProvisorioEnviado.hide()");
        FacesUtil.execute((String)"dialogAlvaraProvisorioBaixoRiscoWidgetVar.show()");
    }

    public void gerarAlvaraProvisorio() throws BaseException {
        try {
            if (this.solicitacaoSelecionada.isRenovarAlvaraProvisorio()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).renovarAlvaraRiscoBaixo(this.solicitacaoSelecionada.getSolicitacaoAlvara());
            }
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() && !this.solicitacaoSelecionada.isInscricaoEnviada() && SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                this.efetivarAlteracaoSolicitacao();
            }
            this.generateAlvaraProvisorio();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        finally {
            FacesUtil.execute((String)"dlgVerificaDebito.hide()");
            FacesUtil.execute((String)"dialogAlvaraProvisorioBaixoRiscoWidgetVar.hide()");
            FacesUtil.execute((String)"dialogPossuiDebitosEmAbertoWidgetVar.hide()");
            if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isAlteracao()) {
                this.callWebIssIntegracao(this.solicitacaoSelecionada);
            }
        }
    }

    public void enviarAlvaraProvisorio() {
        try {
            this.enviarAlvaraParaRedeSim(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
            FacesUtil.execute((String)"dlgEnviarAlvaraRedeSimSuccess.show()");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        finally {
            FacesUtil.execute((String)"dlgEnviarAlvaraProvisorio.hide()");
        }
        if (!SolicitacaoRedeSimMenuActionEnum.GERAR_DEBITOS.equals((Object)this.menuAction)) {
            this.generateDebitos();
        }
    }

    public void actionGerarAlvaraDefinitivo() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_ALVARA_DEFINITIVO;
        try {
            if (Boolean.TRUE.equals(this.isAlvaraDefinitivoEnviado())) {
                FacesUtil.execute((String)"dlgAlvaraDefinitivoEnviado.show()");
                return;
            }
            this.gerarAlvaraDefinitivo();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void gerarAlvaraDefinitivo() {
        try {
            if (!SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS.equals((Object)this.menuAction)) {
                if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().possuiTodosLaudosLiberadoDefinitivo()) {
                    FacesUtil.execute((String)"dialogGerarAlvaraSemLaudosDeferidosWidgetVar.show()");
                    return;
                }
                if (this.possuiDebitosEmAbertoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara())) {
                    FacesUtil.execute((String)"dialogPossuiDebitosEmAbertoWidgetVar.show()");
                    return;
                }
            }
            this.generateAlvaraDefinitivo();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void enviarAlvaraDefinitivo() throws BaseException {
        try {
            this.enviarAlvaraParaRedeSim(TipoAlvaraEnum.DEFINITIVO);
            FacesUtil.execute((String)"dlgEnviarAlvaraRedeSimSuccess.show()");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        finally {
            this.recarregarSolicitacao();
            FacesUtil.execute((String)"dlgEnviarAlvaraDefinitivo.hide()");
        }
    }

    public void sendAnulacaoDocumento() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarAnulacaoDocumento(this.solicitacaoSelecionada, this.modeloDocumentoAnulacao);
            switch (1.$SwitchMap$br$com$elotech$portalarrecadacao$enumerator$ModeloDocumentoRedeSimEnum[this.modeloDocumentoAnulacao.ordinal()]) {
                case 1: {
                    this.solicitacaoSelecionada.setInscricaoEnviada(SimNaoEnum.getNaoShortText());
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
                    break;
                }
                case 2: {
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setObservacoes(null);
                    this.solicitacaoSelecionada.getSolicitacaoAlvara().setDataValidadeProvisorio(null);
                    ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvara(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                    this.solicitacaoSelecionada.setAlvaraEnviado(null);
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
                    break;
                }
                case 3: {
                    if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoBaixo() && Boolean.TRUE.equals(this.enviaAlvaraProvisorio())) {
                        this.solicitacaoSelecionada.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
                    } else {
                        this.solicitacaoSelecionada.setAlvaraEnviado(null);
                    }
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
                }
            }
            this.recarregarSolicitacao();
            ShowMessage.addInfoMessage((String)"validacao", (String)String.format("Documento: %s - foi anulado com sucesso.", this.modeloDocumentoAnulacao.getDescricao()));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro ao enviar a anula\u00e7\u00e3o - " + e.getMessage()));
        }
        finally {
            FacesUtil.execute((String)"dlgEnviarAnulacaoDocumento.hide()");
        }
    }

    public void sendAnulacaoDocumentoInscricaoMunicipal() {
        this.setModeloDocumentoAnulacao(ModeloDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL);
        FacesUtil.execute((String)"dlgEnviarAnulacaoDocumento.show()");
    }

    public void sendAnulacaoDocumentoAlvaraProvisorio() {
        this.setModeloDocumentoAnulacao(ModeloDocumentoRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO);
        FacesUtil.execute((String)"dlgEnviarAnulacaoDocumento.show()");
    }

    public void sendAnulacaoDocumentoAlvaraLocalizacao() {
        this.setModeloDocumentoAnulacao(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO);
        FacesUtil.execute((String)"dlgEnviarAnulacaoDocumento.show()");
    }

    private void enviarAlvaraParaRedeSim(TipoAlvaraEnum situacaoEnvio) throws BaseException {
        this.solicitacaoSelecionada.setAlvaraEnviado(situacaoEnvio);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
    }

    public void toggleExigencia() {
        if (this.mostraExigencia.booleanValue()) {
            this.exigenciasAdicionadas.clear();
        } else {
            this.carregarListaExigencias();
        }
        this.mostraExigencia = this.mostraExigencia == false;
    }

    public void adicionarExigencia() {
        if (this.exigenciaSelecionada == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione uma exig\u00eancia.");
            return;
        }
        HistoricoExigenciaRedeSimEntity historico = new HistoricoExigenciaRedeSimEntity();
        historico.setSolicitacaoRedeSim(this.solicitacaoSelecionada);
        historico.setExigenciaRedeSim(this.exigenciaSelecionada);
        historico.setObservacoes(this.observacaoExigencia);
        historico.setDataAndamento(new Date());
        historico.setSituacao(SituacaoConsultaPreviaRedeSimEnum.EXIGENCIA.getSigla());
        UsuarioEntity user = (UsuarioEntity)this.authenticationProviderAise.getUsuarioLogado();
        historico.setUsuario(user.getUsuario());
        this.exigenciasAdicionadas.add(historico);
        this.exigenciaSelecionada = null;
        this.observacaoExigencia = null;
    }

    public void removeFromDataTable(HistoricoExigenciaRedeSimEntity exigenciaPair) {
        this.exigenciasAdicionadas.remove(exigenciaPair);
    }

    public void buscarExigencia() throws BaseException {
        ExigenciaRedeSimEntity exigencia = this.getExigenciaRedeSimPorCodigo(this.codigoExigencia.longValue());
        if (exigencia != null) {
            this.exigenciaSelecionada = exigencia;
        } else {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhuma exig\u00eancia encontrada!");
        }
    }

    public void enviarExigencia() {
        if (!EloListUtils.safeIsEmpty((List)this.exigenciasAdicionadas).booleanValue()) {
            try {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.solicitacaoSelecionada, this.exigenciasAdicionadas);
                this.salvarHistoricoExigenciasRedeSim(this.solicitacaoSelecionada, this.exigenciasAdicionadas);
                this.exigenciasAdicionadas = new ArrayList();
                this.exigenciasSolicitacaoSelecionada = Lists.newArrayList();
                this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
                ShowMessage.addInfoMessage((String)"validacao", (String)"Opera\u00e7\u00e3o realizada com sucesso!");
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            }
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o h\u00e1 exig\u00eancias para serem enviadas.");
        }
    }

    public void actionGerarDebitos() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_DEBITOS;
        try {
            if (Boolean.TRUE.equals(this.isAlvaraDefinitivoEnviado())) {
                FacesUtil.execute((String)"dlgAlvaraDefinitivoEnviadoDebito.show()");
                return;
            }
            this.generateDebitos();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void generateDebitos() {
        try {
            this.guiaRecolhimentoSelecionado = null;
            this.receitasSelecionadas.clear();
            this.receitas.clear();
            this.numeroParcela = 1;
            this.observacaoDebito = null;
            this.vencimentoPrimeiraParcela = EloDateUtils.addDay((Date)new Date(), (int)30);
            this.guiasRecolhimento = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getGuiasRecolhimentoAlvara(UtilsController.getEntidadeTributacao());
            this.geraCadastroLaudoRedeSim = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_LAUDO_VIA_INTEGRACAO_REDESIM));
            this.todosEventosAptos = UtilsController.areAllEventosAptos((SolicitacaoRedeSimEntity)this.solicitacaoSelecionada);
            if (this.possuiDebitoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara())) {
                if (this.isGeraDebitoAutomatico()) {
                    FacesUtil.execute((String)"dlgPossuiDebitoNaSolicitacaoDebitoAutomatico.show()");
                } else {
                    this.listaDebitosSelecionadosParaEnvio.clear();
                    this.listaDebitosSelecionadosParaEnvio.addAll(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara()));
                    FacesUtil.execute((String)"dlgPossuiDebitoNaSolicitacao.show()");
                }
            } else if (this.isGeraDebitoAutomatico()) {
                this.gerarDebitoAutomatico();
            } else {
                FacesUtil.execute((String)"dlgListaGeraDebito.show()");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void mostrarDialogListaDebitos() {
        try {
            this.listaDebitos = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara());
            FacesUtil.execute((String)"dlgPossuiDebitoNaSolicitacao.hide()");
            FacesUtil.execute((String)"dlgListaGeraDebito.show()");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private boolean possuiDebitoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).possuiDebitoNaSolicitacao(solicitacao);
    }

    private boolean possuiDebitosEmAbertoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List debitosEmAberto = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(solicitacao);
        return debitosEmAberto.size() != 0;
    }

    public void carregarReceitas() {
        try {
            GuiaRecolhimentoReceitaFiltro filtro = new GuiaRecolhimentoReceitaFiltro();
            EntidadeTributacaoEntity entidadeTributacao = UtilsController.getEntidadeTributacao();
            filtro.setExercicio(entidadeTributacao.getExercicio());
            filtro.setEntidade(entidadeTributacao.getId().getEntidade().getId());
            filtro.setGuiaRecolhimento(this.guiaRecolhimentoSelecionado.getGuiaRecolhimento());
            this.receitas = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getReceitasPorGuia(filtro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoDebito", (String)e.getMessage());
        }
    }

    public void validarDebito() {
        BigDecimal totalReceitas = BigDecimal.ZERO;
        if (Objects.isNull(this.vencimentoPrimeiraParcela)) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione o vencimento da primeira Parcela !");
        } else if (this.vencimentoPrimeiraParcela.compareTo(new Date()) < 0) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Vencimento da primeira Parcela n\u00e3o est\u00e1 correto !");
        } else if (Objects.isNull(this.guiaRecolhimentoSelecionado)) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione uma d\u00edvida !");
        } else if (EloListUtils.safeIsEmpty((List)this.receitasSelecionadas).booleanValue()) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione uma receita ");
        } else {
            for (ReceitaVo receita : this.receitasSelecionadas) {
                if (!EloNumberUtils.isBiggerThanZero((Number)receita.getValor()).booleanValue()) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Preecha o campo valor.");
                    return;
                }
                totalReceitas = totalReceitas.add(receita.getValor());
            }
            this.totalReceitas = EloStringUtils.formatValor((BigDecimal)totalReceitas, (int)2);
            FacesUtil.execute((String)"dlgValidacaoDebito.show()");
        }
    }

    private void imprimirTaxas(ImprimirTaxasAlvara imprimirTaxasAlvara) throws BaseException {
        String userKey = ((FacadeDebitos)SpringContext.getBean(FacadeDebitos.class)).loginWeb();
        if (imprimirTaxasAlvara.getCarne() != null) {
            String urlImprimiCarne = (String)SpringContext.getBean((String)"urlImprimirCarne", String.class);
            String urlCarne = urlImprimiCarne + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getCarne();
            FacesUtil.execute((String)("window.open('" + urlCarne + "','_blank')"));
        }
        if (imprimirTaxasAlvara.getBloqueto() != null) {
            String urlImprimirBloqueto = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
            String urlBloqueto = urlImprimirBloqueto + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getBloqueto() + "&exercicio=" + imprimirTaxasAlvara.getExercicioBloqueto();
            FacesUtil.execute((String)("window.open('" + urlBloqueto + "','_blank')"));
        }
    }

    private boolean isGeraDebitoAutomatico() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_DEBITO_AUTOMATICO_SOLICITACAO_REDESIM));
    }

    private boolean habilitaCategoriaPj() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_CATEGORIA_MOBILIARIO_PJ));
    }

    private boolean habilitaProcessoAutomaticoRedeSim() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_REDESIM));
    }

    public void novoDebito() {
        this.guiaRecolhimentoSelecionado = null;
        this.numeroParcela = null;
        this.receitas.clear();
        this.receitasSelecionadas.clear();
        this.observacaoDebito = "";
        FacesUtil.execute((String)"dlgGeraDebito.show();");
    }

    public void gerarDebitoManual() {
        try {
            DebitoWebVo debitoWebVo = new DebitoWebVo();
            debitoWebVo.setGuia(this.guiaRecolhimentoSelecionado.getGuiaRecolhimento().intValue());
            debitoWebVo.setDescricaoGuia(this.guiaRecolhimentoSelecionado.getDescricao());
            debitoWebVo.setObservacao(this.observacaoDebito);
            debitoWebVo.setReceitas(this.receitasSelecionadas);
            debitoWebVo.setVencimentoPrimeiraParcela(this.vencimentoPrimeiraParcela);
            debitoWebVo.setSolicitacaoAlvara(this.solicitacaoSelecionada.getSolicitacaoAlvara());
            if (!this.existeDebitosComGuiaRepetida(debitoWebVo).booleanValue()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarDebitoWeb(debitoWebVo);
                this.listaDebitos = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                FacesUtil.execute((String)"dlgGeraDebito.hide(); dlgValidacaoDebito.hide()");
            } else {
                ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o \u00e9 permitido criar dois d\u00e9bitos com a mesma d\u00edvida. Selecione uma nova d\u00edvida.");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessages((String)"validacao", (List)Lists.newArrayList((Object[])new String[]{"Ocorreu uma Falha ao gerar o d\u00e9bito.:", e.getMessage()}));
        }
    }

    private Boolean existeDebitosComGuiaRepetida(DebitoWebVo debitoWebVo) {
        for (DebitoEntity debito : this.listaDebitos) {
            if (!debito.getId().getGuiaRecolhimento().getId().getGuiaRecolhimento().equals(debitoWebVo.getGuia())) continue;
            return true;
        }
        return false;
    }

    public void enviarDebitoRedeSim() {
        if (EloListUtils.safeIsEmpty((List)this.listaDebitosSelecionadosParaEnvio).booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Selecione pelo menos um d\u00e9bito para enviar para o Rede Sim.");
            return;
        }
        FacesUtil.execute((String)"dlgEnviaDebitoParaRedeSim.show();");
    }

    public void enviarDebito() {
        try {
            this.enviarDebitos();
            if (!SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS.equals((Object)this.menuAction)) {
                this.generateAlvara();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu uma falha ao enviar o(s) d\u00e9bito(s). " + e.getMessage()));
        }
    }

    public void enviarDebitos() throws SolicitacaoAlvaraRedeSimException {
        Boolean listaDebitosVazia = EloListUtils.safeIsEmpty((List)this.listaDebitosSelecionadosParaEnvio);
        try {
            if (Boolean.TRUE.equals(listaDebitosVazia)) {
                this.listaDebitosSelecionadosParaEnvio.addAll(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara()));
            }
            if (!EloListUtils.safeIsEmpty((List)this.listaDebitosSelecionadosParaEnvio).booleanValue()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.TRUE.booleanValue(), this.listaDebitosSelecionadosParaEnvio);
                this.recarregarSolicitacao();
            }
            if (!SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS.equals((Object)this.menuAction)) {
                FacesUtil.execute((String)"dlgConfirmaEnvioDebito.show()");
            }
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraRedeSimException(e.getMessage(), (Throwable)e);
        }
        finally {
            FacesUtil.execute((String)"dlgEnviaDebitoParaRedeSim.hide()");
            if (Boolean.TRUE.equals(listaDebitosVazia)) {
                this.listaDebitosSelecionadosParaEnvio.clear();
            }
        }
    }

    public String getNumeroSolicitacao(SolicitacaoRedeSimEntity solicitacao) {
        if (solicitacao.getSolicitacaoAlvara() != null) {
            return solicitacao.getSolicitacaoAlvara().getNumeroSolicitacaoExercicio();
        }
        return "";
    }

    public SolicitacaoRedeSimDataModel getSolicitacaoRedeSimDataModel() {
        return this.solicitacaoRedeSimDataModel;
    }

    public void setSolicitacaoRedeSimDataModel(SolicitacaoRedeSimDataModel solicitacaoRedeSimDataModel) {
        this.solicitacaoRedeSimDataModel = solicitacaoRedeSimDataModel;
    }

    private void atualizaSituacaoDebitoPago() throws SolicitacaoAlvaraException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).atualizarSituacaoParaDebitoPago();
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("Falha ao atualizar situa\u00e7\u00e3o da solicita\u00e7\u00e3o para d\u00e9bito pago", e.getCause());
        }
    }

    private void montarAnexosSolicitacaoVo() throws SolicitacaoAlvaraRedeSimException {
        try {
            this.anexosSolicitacaoSelecionada = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarAnexosSolicitacaoVo(this.solicitacaoSelecionada);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void visualizarAnexoSolicitacao(AnexoSolicitacaoRedeSimVo anexoSolicitacao) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDocumentoAnexo(anexoSolicitacao);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public Boolean isIndeferido() {
        if (SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO.getSigla().equals(this.solicitacaoSelecionada.getSituacao()) || SituacaoConsultaPreviaRedeSimEnum.CONSULTA_INDEFERIDA.getSigla().equals(this.solicitacaoSelecionada.getSituacao())) {
            return true;
        }
        return false;
    }

    public Boolean isRestricaoCadastral() {
        return SituacaoConsultaPreviaRedeSimEnum.RESTRICAO_CADASTRAL.getSigla().equals(this.solicitacaoSelecionada.getSituacao());
    }

    public boolean isExibeMotivoIndeferimentoSolicitacao() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ENVIO_INDEFERIMENTO_REDESIM_SOLICITACAO_LAUDOS)) != false && !this.solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoMEI() && !SituacaoConsultaPreviaRedeSimEnum.ALVARA_ENVIADO.getSigla().equals(this.solicitacaoSelecionada.getSituacao());
    }

    public void indeferir() throws BaseException {
        if (this.isExibeMotivoIndeferimentoSolicitacao()) {
            this.exibeMotivoIndeferimentoRedeSim = Boolean.TRUE;
            return;
        }
        this.exibeMotivoIndeferimentoRedeSim = Boolean.FALSE;
        FacesUtil.execute((String)"dialogConfirmarIndeferimentoWidgetVar.show()");
    }

    public void toggleMotivoIndeferimento() {
        this.exibeMotivoIndeferimentoRedeSim = Boolean.FALSE;
        this.motivoIndeferimento = "";
    }

    public void indeferirSolicitacao() throws BaseException {
        try {
            if (this.isExibeMotivoIndeferimentoSolicitacao()) {
                if (EloStringUtils.isEmpty((String)this.motivoIndeferimento)) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o motivo do indeferimento!");
                    return;
                }
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarIndeferimentoRedeSim(this.solicitacaoSelecionada, this.motivoIndeferimento);
                this.toggleMotivoIndeferimento();
            } else {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO, Optional.empty());
            }
            this.recarregarSolicitacao();
            ShowMessage.addInfoMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o indeferida com sucesso!");
            FacesUtil.execute((String)"dialogConfirmarIndeferimentoWidgetVar.hide()");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao indeferir a solicita\u00e7\u00e3o.");
        }
    }

    public boolean isDocumentoEmitidoFoiInvalidado() {
        try {
            String paramInvalidarDocumentoEmitido = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INVALIDAR_DOCUMENTO_EMITIDO);
            if (SimNaoEnum.getSimShortText().equals(paramInvalidarDocumentoEmitido)) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public boolean isTramitaInscricaoMunicipalAtivado() {
        try {
            String paramInvalidarDocumentoEmitido = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TRAMITA_INSCRICAO_MUNICIPAL);
            if (SimNaoEnum.getSimShortText().equals(paramInvalidarDocumentoEmitido)) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public void invalidarAlvara() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.SUSPENSO, Boolean.FALSE.booleanValue());
            this.solicitacaoSelecionada.setInvalidado(SimNaoEnum.getSimShortText());
            this.solicitacaoSelecionada.setAlvaraEnviado(null);
            this.recarregarSolicitacao();
            FacesUtil.execute((String)"dlgConfirmarInvalidarDocumento.hide()");
            ShowMessage.addInfoMessage((String)"validacao", (String)"Documento suspenso com sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao suspender o alvar\u00e1");
        }
    }

    public void invalidarInscricaoMunicipal() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumentoInscricaoMunicipal(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.SUSPENSO);
            this.solicitacaoSelecionada.setInvalidado(SimNaoEnum.getSimShortText());
            this.recarregarSolicitacao();
            FacesUtil.execute((String)"dlgConfirmarInvalidarInscricaoMunicipal.hide()");
            ShowMessage.addInfoMessage((String)"validacao", (String)"Documento suspenso com sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao suspender o alvar\u00e1");
        }
    }

    public void actionGerarTermoDispensa() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_TERMO_DE_DISPENSA;
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).generateTermoDispensaRedeSim(this.solicitacaoSelecionada, Boolean.TRUE.booleanValue());
            FacesUtil.execute((String)"dlgEnviarTermoDispensaRedeSim.show()");
            this.recarregarSolicitacao();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void actionGerarInscricaoMunicipal() {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.GERAR_INSCRICAO_MUNICIPAL;
        try {
            boolean isNovoDocumentoInscricaoMunicipal;
            if (this.solicitacaoSelecionada.isInscricaoEnviada()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"A inscri\u00e7\u00e3o municipal j\u00e1 foi enviada!");
                return;
            }
            if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() && !this.solicitacaoSelecionada.isInscricaoEnviada() && SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                this.efetivarAlteracaoSolicitacao();
            }
            if (isNovoDocumentoInscricaoMunicipal = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarInscricaoMunicipal(this.solicitacaoSelecionada.getSolicitacaoAlvara())) {
                if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, Optional.of("Inscri\u00e7\u00e3o Municipal - Liberdade Econ\u00f4mica"));
                } else {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, Optional.empty());
                }
            }
            FacesUtil.execute((String)"dlgEnviarInscricaoMunicipalRedeSim.show()");
            if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isAlteracao()) {
                this.callWebIssIntegracao(this.solicitacaoSelecionada);
            }
            if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).updateSolicitacaoEnvioInscricaoMunicipal(this.solicitacaoSelecionada);
            }
            this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void enviarInscricaoMunicipalRedeSim() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumentoInscricaoMunicipal(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.EM_ANALISE);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumentoInscricaoMunicipal(this.solicitacaoSelecionada, SituacaoRespostaRedeSimEnum.EMITIDO);
            if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, Optional.of("Inscri\u00e7\u00e3o Municipal Enviada - Liberdade Econ\u00f4mica"));
            } else {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.solicitacaoSelecionada, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, Optional.empty());
            }
            this.recarregarSolicitacao();
            FacesUtil.execute((String)"dlgEnviarAlvaraRedeSimSuccess.show()");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        finally {
            FacesUtil.execute((String)"dlgVerificaDebito.hide()");
            FacesUtil.execute((String)"dlgEnviarInscricaoMunicipalRedeSim.hide()");
        }
    }

    public void sendTermoDispensaRedeSimRedeSim() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).sendTermoDispensaRedeSim(this.solicitacaoSelecionada);
            FacesUtil.execute((String)"dlgEnviarTermoDispensaRedeSim.hide()");
            FacesUtil.execute((String)"dlgEnviarAlvaraRedeSimSuccess.show()");
            this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void gerarDebitoAutomatico() {
        try {
            SolicitacaoAlvaraEntity solicitacaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(this.solicitacaoSelecionada.getSolicitacaoAlvara().getNumeroSolicitacao(), this.solicitacaoSelecionada.getSolicitacaoAlvara().getExercicio(), null);
            this.generateTaxas(solicitacaoAlvara);
            FacesUtil.execute((String)"dlgPossuiDebitoNaSolicitacaoDebitoAutomatico.hide()");
            FacesUtil.execute((String)"statusDialog.hide()");
            if (!SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS.equals((Object)this.menuAction)) {
                FacesUtil.execute((String)"dlgEnviaDebitoParaRedeSim.show()");
            } else {
                this.enviarDebitos();
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu uma falha ao gerar o d\u00e9bito. " + e.getMessage()));
        }
    }

    public void visualizarAndamento(HistoricoExigenciaRedeSimEntity andamento) {
        this.setAndamentoSelecionado(andamento);
        FacesUtil.execute((String)"dlgExigencia.show()");
    }

    private boolean isSolicitacaoMeiSemConsultaPrevia(SolicitacaoRedeSimEntity solicitacaoSelecionada) throws BaseException {
        if (solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            SolicitacaoRedeSimEntity consultaPreviaSolicitacaoSelecionada = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacaoSelecionada.getProtocolo(), TipoSolicitacaoRedeSimEnum.CONSULTA);
            return Objects.isNull(consultaPreviaSolicitacaoSelecionada);
        }
        return false;
    }

    private boolean isRealizaConsultaViabilidadeNaSolicitacao() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.REALIZAR_CONSULTA_VIABILIDADE_NA_SOLICITACAO));
    }

    private boolean possuiTodosOsDocumentosValidados(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).anexosRedeSimValidados(solicitacao);
    }

    private boolean verificarLiberacaoAutomaticaValidacaoDoc(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        return this.habilitaProcessoAutomaticoRedeSim() && solicitacao.getSolicitacaoAlvara().possuiTodosLaudosLiberado() && this.possuiTodosOsDocumentosValidados(solicitacao);
    }

    private String getNu_Inscricao(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDto) {
        if (solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco() != null && solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel() != null && solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel().getNu_inscricao() != null) {
            return EloStringUtils.somenteNumeros((String)solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel().getNu_inscricao());
        }
        return null;
    }

    public void validarOuInvalidarAnexo(AnexoSolicitacaoRedeSimVo docAnexo) {
        this.menuAction = SolicitacaoRedeSimMenuActionEnum.VALIDAR_DOCUMENTOS;
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).validarOuInvalidarDocumentoAnexoSolicitacao(docAnexo);
            ShowMessage.addInfoMessage((String)"validacao", (String)"O documento foi alterado com sucesso!");
            this.montarAnexosSolicitacaoVo();
            this.recarregarSolicitacao();
            if (Objects.nonNull(this.solicitacaoSelecionada.getSolicitacaoAlvara()) && this.verificarLiberacaoAutomaticaValidacaoDoc(this.solicitacaoSelecionada)) {
                if (!this.solicitacaoSelecionada.getSolicitacaoAlvara().isNaturezaInicial() && SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).efetivarAlteracaoSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                }
                if (this.solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal() || this.solicitacaoSelecionada.getSolicitacaoAlvara().isSolicitacaoPrestadorServico()) {
                    this.generateTaxas(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                }
                this.generateAlvara();
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro durante a valida\u00e7\u00e3o do documento: " + e.getMessage()));
        }
    }

    private void generateTaxas(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ImprimirTaxasAlvara imprimirTaxasAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirTaxas(solicitacaoAlvara);
        this.imprimirTaxas(imprimirTaxasAlvara);
    }

    public boolean isDesenvolvimento() {
        AppWebConfEntity appWebConf = null;
        try {
            appWebConf = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).loadAppWebConf();
            return appWebConf != null && appWebConf.isModoDesenvolvimento();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isConsultaPreviaRealizadaPeloSistema() {
        try {
            SolicitacaoRedeSimEntity consultaPrevia = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaDeferidaByProtocolo(this.solicitacaoSelecionada.getProtocolo());
            return consultaPrevia != null;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public void processoAutomatico() {
        try {
            JobIniciaProcessoIntegracaoMeiRedeSim job = new JobIniciaProcessoIntegracaoMeiRedeSim();
            job.execute(null);
        }
        catch (JobExecutionException e) {
            e.printStackTrace();
        }
    }

    public void gerarCadastroAposConsultaViabilidade() {
        try {
            this.saveOrUpdateCadastroMobiliario();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void gerarCadastroMobiliarioAlteracaoSolicitacaoInconsistente() {
        try {
            this.cadastroMobiliarioSelecionado = this.cadastroMobiliarioGerado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).saveOrUpdateMobiliarioByRedeSim(this.solicitacaoSelecionada, Optional.empty());
            this.saveOrUpdateCadastroMobiliario();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public boolean isModoSimplificado() {
        return this.modoSimplificado;
    }

    public void processarSolicitacoesNaoProcessadas() {
        if (Objects.nonNull(this.solicitacaoRedeSimDataModel) && EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSimDataModel.getDados().getData()).booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o tem registro na lista para ser processado!");
            return;
        }
        if (Objects.nonNull(this.solicitacaoRedeSimDataModel) && !EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSimDataModel.getDados().getData()).booleanValue() && !this.solicitacaoRedeSimDataModel.getDados().getData().stream().anyMatch(p -> SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla().equals(p.getSituacao()))) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o tem nenhum registro N\u00c3O PROCESSADO para ser processado.");
            return;
        }
        String prefix = "Reprocessamento";
        for (SolicitacaoRedeSimEntity solicitacaoNaoProcessada : this.solicitacaoRedeSimDataModel.getDados().getData()) {
            if (!SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla().equals(solicitacaoNaoProcessada.getSituacao())) continue;
            String token = UUID.randomUUID().toString();
            this.logger.info((Object)String.format("[%s] INICIANDO REPROCESSAMENTO MANUAL (WS02) Protocolo: %s", token, solicitacaoNaoProcessada.getProtocolo()));
            try {
                SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)solicitacaoNaoProcessada.getArquivoDadosEmpresa());
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).solicitacaoAlvara(solicitacaoDTO, solicitacaoNaoProcessada);
                boolean enviaInscricaoMunicipalDadosAtualizados = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS));
                if (enviaInscricaoMunicipalDadosAtualizados) {
                    ((SrvSolicitacaoAlvaraRedeSimImpl)SpringContext.getBean(SrvSolicitacaoAlvaraRedeSimImpl.class)).generateCadastroMobiliarioAndInscricaoMunicipal(prefix, token, solicitacaoDTO.getDados_solicitacao().getCo_protocolo_redesim());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)String.format("[%s] Erro no reprocessamento da solicitacao (WS02): %s", token, e.getMessage()), (Throwable)e);
            }
            this.logger.info((Object)String.format("[%s] FINALIZANDO REPROCESSAMENTO MANUAL (WS02) Protocolo: %s", token, solicitacaoNaoProcessada.getProtocolo()));
        }
    }

    public void processarSolicitacaoNaoProcessada(SolicitacaoRedeSimEntity solicitacaoNaoProcessada) {
        try {
            if (SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla().equals(solicitacaoNaoProcessada.getSituacao())) {
                String prefix = "Reprocessamento";
                String token = UUID.randomUUID().toString();
                SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)solicitacaoNaoProcessada.getArquivoDadosEmpresa());
                this.logger.info((Object)String.format("%s - [%s] Iniciando reprocessamento da solicita\u00e7\u00e3o: %s", prefix, token, solicitacaoDTO.getDados_solicitacao().getCo_protocolo_redesim()));
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).solicitacaoAlvara(solicitacaoDTO, solicitacaoNaoProcessada);
                boolean enviaInscricaoMunicipalDadosAtualizados = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS));
                if (enviaInscricaoMunicipalDadosAtualizados) {
                    ((SrvSolicitacaoAlvaraRedeSimImpl)SpringContext.getBean(SrvSolicitacaoAlvaraRedeSimImpl.class)).generateCadastroMobiliarioAndInscricaoMunicipal(prefix, token, solicitacaoDTO.getDados_solicitacao().getCo_protocolo_redesim());
                }
                this.pesquisar();
                ShowMessage.addInfoMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o Processada!");
            } else {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Essa solicita\u00e7\u00e3o j\u00e1 foi processada!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("N\u00e3o foi poss\u00edvel finalizar o processo. %s ", e.getMessage()));
        }
    }

    private void callWebIssIntegracao(SolicitacaoRedeSimEntity solicitacaoSelecionada) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).updateSolicitacaoRedeSimParaWebIss(solicitacaoSelecionada, null);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Erro ao integrar com a webiss - " + ex.getMessage()), (Throwable)ex);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro na integra\u00e7\u00e3o com a WebIss. " + ex.getMessage()));
        }
    }

    public void ativarOrDesativarSolicitacaoShowDialog(SolicitacaoRedeSimEntity solicitacao) {
        try {
            this.setSolicitacaoSelecionada(solicitacao);
            SolicitacaoRedeSimEntity consultaRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacao.getProtocolo(), TipoSolicitacaoRedeSimEnum.CONSULTA);
            if (Objects.nonNull(consultaRedeSim)) {
                FacesUtil.execute((String)"dlgSolicitacaoAtivaInativa.show()");
                return;
            }
            this.ativarOrDesativarSolicitacao();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }

    public void ativarOrDesativarSolicitacao() throws BaseException {
        try {
            SolicitacaoRedeSimEntity consultaRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.solicitacaoSelecionada.getProtocolo(), TipoSolicitacaoRedeSimEnum.CONSULTA);
            this.solicitacaoSelecionada.setAtivo(!this.solicitacaoSelecionada.isAtivo());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.solicitacaoSelecionada);
            if (Objects.nonNull(consultaRedeSim)) {
                consultaRedeSim.setAtivo(!consultaRedeSim.isAtivo());
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(consultaRedeSim);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }

    public List<LogradouroEntity> completeEndereco(String query) {
        List enderecos = null;
        try {
            if (Objects.nonNull(this.cidadeSelecionada)) {
                enderecos = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaLogradouroPorCidade(this.cidadeSelecionada.getId(), query);
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao buscar Logradouro");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    public List<CidadeEntity> completeCidade(String query) {
        List cidades = null;
        try {
            cidades = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaCidadePorDescricao(query);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao buscar Cidade");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cidades;
    }

    public List<BairroEntity> completeBairro(String query) {
        List bairros = null;
        try {
            if (Objects.nonNull(this.cidadeSelecionada)) {
                bairros = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaBairroPorDescricaoECidade(this.cidadeSelecionada.getId(), query);
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao buscar Bairro");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bairros;
    }

    public void selectLogradouro(SelectEvent event) {
        this.logradouroSelecionado = (LogradouroEntity)event.getObject();
    }

    public void selectCidade(SelectEvent event) throws BaseException {
        this.cidadeSelecionada = (CidadeEntity)event.getObject();
    }

    public void selectBairro(SelectEvent event) throws BaseException {
        this.bairroSelecionado = (BairroEntity)event.getObject();
    }

    public Date getVencimentoPrimeiraParcela() {
        return this.vencimentoPrimeiraParcela;
    }

    public void setVencimentoPrimeiraParcela(Date vencimentoPrimeiraParcela) {
        this.vencimentoPrimeiraParcela = vencimentoPrimeiraParcela;
    }

    public String getObservacaoDebito() {
        return this.observacaoDebito;
    }

    public void setObservacaoDebito(String observacaoDebito) {
        this.observacaoDebito = observacaoDebito;
    }

    public String getTotalReceitas() {
        return this.totalReceitas;
    }

    public void setTotalReceitas(String totalReceitas) {
        this.totalReceitas = totalReceitas;
    }

    public Integer getNumeroParcela() {
        return this.numeroParcela;
    }

    public void setNumeroParcela(Integer numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    public List<ReceitaVo> getReceitasSelecionadas() {
        return this.receitasSelecionadas;
    }

    public void setReceitasSelecionadas(List<ReceitaVo> receitasSelecionadas) {
        this.receitasSelecionadas = receitasSelecionadas;
    }

    public List<ReceitaVo> getReceitas() {
        return this.receitas;
    }

    public void setReceitas(List<ReceitaVo> receitas) {
        this.receitas = receitas;
    }

    public List<GuiaRecolhimentoEntity> getGuiasRecolhimento() {
        return this.guiasRecolhimento;
    }

    public void setGuiasRecolhimento(List<GuiaRecolhimentoEntity> guiasRecolhimento) {
        this.guiasRecolhimento = guiasRecolhimento;
    }

    public GuiaRecolhimentoEntity getGuiaRecolhimentoSelecionado() {
        return this.guiaRecolhimentoSelecionado;
    }

    public void setGuiaRecolhimentoSelecionado(GuiaRecolhimentoEntity guiaRecolhimentoSelecionado) {
        this.guiaRecolhimentoSelecionado = guiaRecolhimentoSelecionado;
    }

    public List<LaudoAlvaraEntity> getLaudosGerados() {
        return this.laudosGerados;
    }

    public void setLaudosGerados(List<LaudoAlvaraEntity> laudosGerados) {
        this.laudosGerados = laudosGerados;
    }

    public Boolean getExibeMotivoIndeferimentoRedeSim() {
        return this.exibeMotivoIndeferimentoRedeSim;
    }

    public void setExibeMotivoIndeferimentoRedeSim(Boolean exibeMotivoIndeferimentoRedeSim) {
        this.exibeMotivoIndeferimentoRedeSim = exibeMotivoIndeferimentoRedeSim;
    }

    public String getMotivoIndeferimento() {
        return this.motivoIndeferimento;
    }

    public void setMotivoIndeferimento(String motivoIndeferimento) {
        this.motivoIndeferimento = motivoIndeferimento;
    }

    public ModeloDocumentoRedeSimEnum getModeloDocumentoAnulacao() {
        return this.modeloDocumentoAnulacao;
    }

    public void setModeloDocumentoAnulacao(ModeloDocumentoRedeSimEnum modeloDocumentoAnulacao) {
        this.modeloDocumentoAnulacao = modeloDocumentoAnulacao;
    }

    public List<DebitoEntity> getListaDebitosSelecionadosParaEnvio() {
        return this.listaDebitosSelecionadosParaEnvio;
    }

    public void setListaDebitosSelecionadosParaEnvio(List<DebitoEntity> listaDebitosSelecionadosParaEnvio) {
        this.listaDebitosSelecionadosParaEnvio = listaDebitosSelecionadosParaEnvio;
    }

    public void setConsultaEnderecoCadastroGeralController(ConsultaEnderecoCadastroGeralController consultaEnderecoCadastroGeralController) {
        this.consultaEnderecoCadastroGeralController = consultaEnderecoCadastroGeralController;
    }
}

