/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoEncaminhadaEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroSolicitacaoEncaminhada;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroEventoRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.util.date.EloDateUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Scope;

@EloController(value="solicitacaoEncaminhadaController")
@Scope(value="flow")
public class SolicitacaoEncaminhadaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SolicitacaoEncaminhadaEntity> solicitacoesEncaminhadas;
    private FiltroSolicitacaoEncaminhada filtro;
    private List<EventoRedeSimEntity> eventosRedeSim;

    public FiltroSolicitacaoEncaminhada getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroSolicitacaoEncaminhada filtro) {
        this.filtro = filtro;
    }

    public List<SolicitacaoEncaminhadaEntity> getSolicitacoesEncaminhadas() {
        return this.solicitacoesEncaminhadas;
    }

    public void setSolicitacoesEncaminhadas(List<SolicitacaoEncaminhadaEntity> solicitacoesEncaminhadas) {
        this.solicitacoesEncaminhadas = solicitacoesEncaminhadas;
    }

    public List<EventoRedeSimEntity> getEventosRedeSim() {
        return this.eventosRedeSim;
    }

    public void setEventosRedeSim(List<EventoRedeSimEntity> eventosRedeSim) {
        this.eventosRedeSim = eventosRedeSim;
    }

    public void iniciar() throws BaseException {
        this.eventosRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarEventosRedeSim(new FiltroEventoRedeSim());
        this.limparFiltro();
        this.pesquisarSolicitacoesEncaminhadas();
    }

    public void pesquisarSolicitacoesEncaminhadas() {
        if (Objects.nonNull(this.filtro.getDataInicial()) && Objects.nonNull(this.filtro.getDataFinal()) && this.filtro.getDataInicial().compareTo(this.filtro.getDataFinal()) > 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data inicial n\u00e3o pode ser maior que a final.");
            return;
        }
        if (Objects.nonNull(this.filtro.getDataInicial())) {
            this.filtro.setDataInicial(this.filtro.getDataInicial());
        }
        if (Objects.nonNull(this.filtro.getDataFinal())) {
            this.filtro.setDataFinal(EloDateUtils.getEnd((Date)this.filtro.getDataFinal()));
        }
        try {
            this.solicitacoesEncaminhadas = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarSolicitacoesEncaminhadas(this.filtro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void limparFiltro() {
        this.filtro = new FiltroSolicitacaoEncaminhada();
    }

    public void saveSolicitacao(SolicitacaoEncaminhadaEntity solicitacao) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoEncaminhada(solicitacao);
            ShowMessage.addInfoMessage((String)"validacao", (String)("Solicita\u00e7\u00e3o de protocolo " + solicitacao.getProtocolo() + " foi salva com sucesso!"));
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro ao salvar a solicita\u00e7\u00e3o: " + e.getCause()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void validarData() {
    }
}

