/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ResponsavelSolicitacaoVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloController(value="solicitacaoAlvaraController")
@Scope(value="flow")
public class SolicitacaoAlvaraController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private List<SolicitacaoAlvaraNumConselhoEntity> listaSolAlvaraNumConselho = new ArrayList();
    @Resource
    private EntidadeController entidadeController;
    private List<RespostaWSAtividade> listaConfiguracaoCnae;
    private CadastroMobiliarioEntity cadastroMobiliario;
    private String mensagemAlerta;
    private ResponsavelSolicitacaoVo responsavelSolicitacao;

    public String getMensagemAlerta() {
        return this.mensagemAlerta;
    }

    public List<RespostaWSAtividade> getListaConfiguracaoCnae() {
        return this.listaConfiguracaoCnae;
    }

    public void setListaConfiguracaoCnae(List<RespostaWSAtividade> listaConfiguracaoCnae) {
        this.listaConfiguracaoCnae = listaConfiguracaoCnae;
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> getListaSolAlvaraNumConselho() {
        return this.listaSolAlvaraNumConselho;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public void setListaSolAlvaraNumConselho(List<SolicitacaoAlvaraNumConselhoEntity> listaSolAlvaraNumConselho) {
        this.listaSolAlvaraNumConselho = listaSolAlvaraNumConselho;
    }

    public SolicitacaoAlvaraController() {
        this.solicitacaoAlvara = new SolicitacaoAlvaraEntity();
        this.solicitacaoAlvara.setFinalizado("N");
    }

    public SolicitacaoAlvaraEntity setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.solicitacaoAlvara.setCadastroMobiliario(cadastroMobiliario);
        return this.solicitacaoAlvara;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public String formatCpfCnpj(String cpfCnpj) throws FormatError {
        if (!cpfCnpj.equals("") && cpfCnpj.length() >= 11) {
            return EloStringUtils.formatCpfCnpj((String)cpfCnpj);
        }
        return cpfCnpj;
    }

    public String getDescricaoDataHoraAtual() {
        return EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd/MM/yyyy - HH:mm");
    }

    public String retornaCnpjCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null) {
            CadastroMobiliarioEntity cadastroMobiliario = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral);
            if (cadastroMobiliario != null) {
                return cadastroMobiliario.getCadastroGeral().getPessoa().getCnpjCpf();
            }
            return "";
        }
        return "";
    }

    public String retornaNomeCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null) {
            CadastroMobiliarioEntity cadastroMobiliario = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral);
            if (cadastroMobiliario != null) {
                return cadastroMobiliario.getCadastroGeral().getPessoa().getNome();
            }
            return "";
        }
        return "";
    }

    public String getMensagemObservacao() throws BaseException {
        return UtilsController.getMensagemObservacaoRecibos((ParametroAlvaraEnum)ParametroAlvaraEnum.MENSAGEM_OBSERVACAO_SOLICITACAO);
    }

    public boolean temInformacaoAdicional() {
        return !this.solicitacaoAlvara.getObservacaoDasAtividades(Boolean.FALSE.booleanValue()).isEmpty();
    }

    public ResponsavelSolicitacaoVo buscarResponsavelSolicitacaoAlvara() throws BaseException {
        if (this.responsavelSolicitacao == null) {
            this.responsavelSolicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getResponsavelSolicitacaoAlvara(this.solicitacaoAlvara);
        }
        return this.responsavelSolicitacao;
    }
}

