/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.LoginPortalArrecadacao;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.date.EloDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;

@EloController(value="selecaoConsultaPreviaController")
@Scope(value="flow")
public class SelecaoConsultaPreviaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String solicitacao;
    private String cpfCnpj;
    private Long numeroConsulta;
    private Long exercicio;
    private boolean navMenu = true;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private EntidadeController entidadeController;

    public boolean isNavMenu() {
        return this.navMenu;
    }

    public void setNavMenu(boolean navMenu) {
        this.navMenu = navMenu;
    }

    public String getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(String solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public String avancar() throws BaseException {
        this.entidadeController.setNumeroConsultaPrevia(null);
        this.entidadeController.setExercicioSolicitacao(null);
        this.numeroConsulta = null;
        this.exercicio = null;
        try {
            Long[] consulta = UtilsController.separarNumeroExercicioSolicitacao((String)this.solicitacao);
            if (Objects.nonNull(consulta) && consulta.length >= 2 && Arrays.stream(consulta).allMatch(Objects::nonNull)) {
                this.numeroConsulta = consulta[0];
                this.exercicio = consulta[1];
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        SolicitacaoAlvaraEntity solicitacaoAlvara = this.preencherSolicitacao();
        if (solicitacaoAlvara != null && (solicitacaoAlvara.isNaturezaInicial() || solicitacaoAlvara.isNaturezaMudancaEndereco())) {
            solicitacaoAlvara.validarInformacoesImovel();
            if (solicitacaoAlvara.possuiErrosValidacaoImobiliario()) {
                ShowMessage.addWarnMessage((String)"validacao", (String)solicitacaoAlvara.descricaoInformacoesImobiliarias());
                ShowMessage.addErrorMessage((String)"validacao", (String)"Para continuar com a solicita\u00e7\u00e3o do Alvar\u00e1, regularize as informa\u00e7\u00f5es pendentes do Cadastro Imobili\u00e1rio.");
                return "";
            }
        }
        if (solicitacaoAlvara != null && solicitacaoAlvara.getRenovacao().equals(SimNaoEnum.NAO.getShortText())) {
            if (SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacaoAlvara.getFinalizado())) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Uma solicita\u00e7\u00e3o j\u00e1 foi gerada para esta consulta, fa\u00e7a uma nova consulta!");
                return null;
            }
            Boolean isSolicitacaoValid = true;
            if (solicitacaoAlvara.isSolicitacaoJuridicaNormal() || solicitacaoAlvara.isSolicitacaoCBO() && UtilsController.validarAreaUtilizadaCBO()) {
                isSolicitacaoValid = this.validaSolicitacaoJuridicaNormal(solicitacaoAlvara);
            }
            if (!isSolicitacaoValid.booleanValue()) {
                return null;
            }
            if (this.isConsultaPreviaExpirada(solicitacaoAlvara)) {
                return null;
            }
            if (UtilsController.isBloqueiaSolicitacaoLiberdadeEconomicaSemIntegracao((SolicitacaoAlvaraEntity)solicitacaoAlvara)) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"ATEN\u00c7\u00c3O! - Com o advento da Lei n\u00ba 13.874/2019, denominada de Lei da Liberdade Econ\u00f4mica, as empresas com atividades somente com CNAE's elencados nas RESOLU\u00c7\u00d5ES CGSIM N\u00bas. 57 e 59/2020 est\u00e3o dispensadas de Licen\u00e7a para Localiza\u00e7\u00e3o. Favor verificar se todos os CNAES inseridos na consulta pr\u00e9via est\u00e3o nas resolu\u00e7\u00f5es supracitadas. Caso sim, dever\u00e1 fazer apenas a inscri\u00e7\u00e3o municipal via pra\u00e7a de atendimento. Caso n\u00e3o, solicitar alvar\u00e1 atrav\u00e9s do sistema antigo. D\u00favidas: 3221-1321.");
                return null;
            }
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi encontrada nenhuma consulta pr\u00e9via com os dados informados.");
            return null;
        }
        this.solicitacaoAlvaraController.setSolicitacaoAlvara(solicitacaoAlvara);
        return this.verificarLogin();
    }

    protected boolean isConsultaPreviaExpirada(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        Date hoje = EloDateUtils.getDateShort((Date)new Date());
        if (hoje.compareTo(solicitacaoAlvara.getDataValidadeConsultaPrevia()) > 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("Esta consulta pr\u00e9via expirou em %s, por favor, realize uma nova consulta pr\u00e9via.", EloDateUtils.toAnsiDateString((Date)solicitacaoAlvara.getDataValidadeConsultaPrevia(), (String)"dd/MM/yyyy")));
            return true;
        }
        return false;
    }

    public boolean mostraUploadDocumentos() {
        return this.solicitacaoAlvaraController.getSolicitacaoAlvara().exigeUploadDocumentos();
    }

    private Boolean validaSolicitacaoJuridicaNormal(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isNaturezaInicial() && !solicitacaoAlvara.isPossuiPontoReferencia() && (solicitacaoAlvara.getAreaConstruida() == null || solicitacaoAlvara.getAreaConstruida().compareTo(BigDecimal.ZERO) == 0)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Na Consulta Pr\u00e9via n\u00e3o consta a \u00e1rea utilizada, fa\u00e7a uma nova Consulta Pr\u00e9via informando os valores.");
            return false;
        }
        return true;
    }

    public String verificarLogin() throws BaseException {
        if (!this.entidadeController.isNavMenu()) {
            this.solicitacaoAlvaraController.setSolicitacaoAlvara(this.entidadeController.getSolicitacaoAlvara());
            this.entidadeController.setNavMenu(true);
        }
        if (this.entidadeController.getVerificaIntegradoLoginExterno().booleanValue()) {
            return "toPossuiRestricoesCadastro";
        }
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            return "toLogin";
        }
        return "toPossuiRestricoesCadastro";
    }

    public SolicitacaoAlvaraEntity preencherSolicitacao() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = null;
        try {
            if (this.entidadeController.isNavMenu()) {
                solicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaConsultaPreviaPorCpfCnpjExercicioNumSolic(this.numeroConsulta, this.exercicio, this.cpfCnpj.replaceAll("[.,-/]", ""));
            } else {
                this.entidadeController.carregaEntidade();
                solicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaConsultaPreviaPorCpfCnpjExercicioNumSolic(this.entidadeController.getNumeroConsultaPrevia(), this.entidadeController.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio(), this.entidadeController.getCnpjConsultaPrevia().replaceAll("[.,-/]", ""));
            }
            if (solicitacao != null && !solicitacao.isNaturezaInicial()) {
                solicitacao.setCpfCnpjCmcResponsavel(this.solicitacaoAlvaraController.retornaCnpjCmcResponsavel(solicitacao.getCadastroMobiliario().getCmcresponsavel()));
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi encontrada nenhuma consulta pr\u00e9via com os dados informados.");
            throw new SolicitacaoAlvaraException("Consulta n\u00e3o encontrada!");
        }
        return solicitacao;
    }

    public void execute(String num, String cpfCnpj) throws BaseException {
        if (!UtilsController.desabilitaSolicitacaoAlvara()) {
            this.entidadeController.setNumeroConsultaPrevia(Long.valueOf(Long.parseLong(num)));
            this.entidadeController.setCnpjConsultaPrevia(cpfCnpj);
            this.entidadeController.setNavMenu(false);
            SolicitacaoAlvaraEntity solicitacaoAlvara = this.preencherSolicitacao();
            this.entidadeController.setSolicitacaoAlvara(solicitacaoAlvara);
            ((LoginPortalArrecadacao)SpringContext.getBean(LoginPortalArrecadacao.class)).setRedirecionaParaSolicitacao(true);
        }
    }
}

