/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.domain.vo.QuantidadeConsultaSolicitacaoVo;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="relatorioQuantidadeSolicitacaoController")
@Scope(value="flow")
public class RelatorioQuantidadeSolicitacaoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FiltroRelatorioSolicitacoesVo filtro;
    @Resource
    private EntidadeController entidadeController;
    private byte[] relatorio;
    private StringBuilder filtrosUsados;
    private List<QuantidadeConsultaSolicitacaoVo> listaQuantidade;
    private QuantidadeConsultaSolicitacaoVo quantidadeTotal;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricao;

    public FiltroRelatorioSolicitacoesVo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroRelatorioSolicitacoesVo filtro) {
        this.filtro = filtro;
    }

    public List<QuantidadeConsultaSolicitacaoVo> getListaQuantidade() {
        return this.listaQuantidade;
    }

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricao() {
        return this.listaTipoInscricao;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroRelatorioSolicitacoesVo();
        this.quantidadeTotal = new QuantidadeConsultaSolicitacaoVo();
        this.listaTipoInscricao = this.getTipoInscricaoAlvara();
        if (!EloListUtils.safeIsEmpty((List)this.listaTipoInscricao).booleanValue()) {
            this.filtro.setTipoInscricao((TipoInscricaoAlvaraEntity)this.listaTipoInscricao.get(0));
        }
    }

    public void filtrar() throws BaseException {
        this.listaQuantidade = new ArrayList();
        this.quantidadeTotal.inicializarTotalizadores();
        if (this.validaCampos()) {
            this.listaQuantidade = this.consultar(this.filtro);
            this.calcularTotal();
        }
    }

    public QuantidadeConsultaSolicitacaoVo getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    private List<QuantidadeConsultaSolicitacaoVo> consultar(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarListaQuantidadeConsultaSolicitacao(filtro);
    }

    public void limpar() {
        this.filtro.setPeriodoInicial(null);
        this.filtro.setPeriodoFinal(null);
        this.iniciarListaQuantidades();
        this.quantidadeTotal.inicializarTotalizadores();
    }

    public void iniciarListaQuantidades() {
        if (this.listaQuantidade == null) {
            this.listaQuantidade = new ArrayList();
        } else {
            this.listaQuantidade.clear();
        }
    }

    public boolean validaCampos() {
        int quantidadeDias;
        if (!this.temFiltroPreenchido()) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o per\u00edodo.");
            return false;
        }
        boolean valido = true;
        if (this.filtro.getPeriodoInicial() == null && this.filtro.getPeriodoFinal() != null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe a data inicial.");
            valido = false;
        }
        if (this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() == null) {
            this.filtro.setPeriodoFinal(new Date());
        }
        if (this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() != null && (quantidadeDias = EloDateUtils.daysBetween((Date)this.filtro.getPeriodoInicial(), (Date)this.filtro.getPeriodoFinal())) < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final n\u00e3o pode ser anterior \u00e0 data inicial.");
            valido = false;
        }
        return valido;
    }

    private boolean temFiltroPreenchido() {
        boolean temFiltro = false;
        this.filtrosUsados = new StringBuilder("Filtros: ");
        this.filtrosUsados.append("Tipo de Inscri\u00e7\u00e3o = ").append(this.filtro.getTipoInscricao().getDescricao()).append(" ");
        if (this.filtro.getPeriodoInicial() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getPeriodoFinal() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
        return temFiltro;
    }

    public void imprimirRelatorio() throws Exception {
        try {
            DataSet dataSet = new DataSet(SolicitacaoAlvaraVo.class);
            HashMap<String, Parameter> params = new HashMap<String, Parameter>();
            String relatorioJasper = "RelatorioQuantidadeConsultaSolicitacao.jasper";
            ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
            params.put("brasao", new Parameter((Object)inputStreamBrasao));
            params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
            params.put("filtros", new Parameter((Object)this.filtrosUsados.toString()));
            params.put("nome_secretaria", new Parameter((Object)UtilsController.getNomeSecretaria()));
            this.montarDataSetSolicitacaoAlvara(dataSet);
            this.relatorio = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private void montarDataSetSolicitacaoAlvara(DataSet dataSet) {
        this.listaQuantidade.add(this.quantidadeTotal);
        dataSet.addAll((Collection)this.listaQuantidade);
    }

    private void calcularTotal() {
        for (QuantidadeConsultaSolicitacaoVo qtde : this.listaQuantidade) {
            this.quantidadeTotal.setConsultaPrevia(Long.valueOf(this.quantidadeTotal.getConsultaPrevia() + qtde.getConsultaPrevia()));
            this.quantidadeTotal.setSolicitacao(Long.valueOf(this.quantidadeTotal.getSolicitacao() + qtde.getSolicitacao()));
            this.quantidadeTotal.setRiscoA(Long.valueOf(this.quantidadeTotal.getRiscoA() + qtde.getRiscoA()));
            this.quantidadeTotal.setRiscoC(Long.valueOf(this.quantidadeTotal.getRiscoC() + qtde.getRiscoC()));
            this.quantidadeTotal.setAlvaraEmitido(Long.valueOf(this.quantidadeTotal.getAlvaraEmitido() + qtde.getAlvaraEmitido()));
        }
    }

    public StreamedContent downloadRelatorio() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.relatorio);
        String nomeRelatorio = "RELATORIO_QUANTIDADE_CONSULTA_SOLICITACAO_" + EloDateUtils.toAnsiDateString((Date)new Date());
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }

    public List<TipoInscricaoAlvaraEntity> getTipoInscricaoAlvara() throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }
}

