/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.domain.vo.OpcaoImpressaoRelatorioVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="relatorioAlvarasEmitidosController")
@Scope(value="flow")
public class RelatorioAlvarasEmitidosController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FiltroRelatorioSolicitacoesVo filtro;
    private StringBuilder filtrosUsados;
    private List<SolicitacaoAlvaraEntity> listaAlvarasEmitidos;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricao;
    private OpcaoImpressaoRelatorioVo opcaoImpressao;

    public FiltroRelatorioSolicitacoesVo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroRelatorioSolicitacoesVo filtro) {
        this.filtro = filtro;
    }

    public List<SolicitacaoAlvaraEntity> getListaAlvarasEmitidos() {
        return this.listaAlvarasEmitidos;
    }

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricao() {
        return this.listaTipoInscricao;
    }

    public OpcaoImpressaoRelatorioVo getOpcaoImpressao() {
        return this.opcaoImpressao;
    }

    public void setOpcaoImpressao(OpcaoImpressaoRelatorioVo opcaoImpressao) {
        this.opcaoImpressao = opcaoImpressao;
    }

    public StringBuilder getFiltrosUsados() {
        return this.filtrosUsados;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroRelatorioSolicitacoesVo();
        this.listaTipoInscricao = this.getTipoInscricaoAlvara();
        if (!EloListUtils.safeIsEmpty((List)this.listaTipoInscricao).booleanValue()) {
            this.filtro.setTipoInscricao((TipoInscricaoAlvaraEntity)this.listaTipoInscricao.get(0));
        }
        this.inicializarOpcaoImpressao();
    }

    public List<TipoInscricaoAlvaraEntity> getTipoInscricaoAlvara() throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }

    public void filtrar() throws BaseException {
        this.listaAlvarasEmitidos = new ArrayList();
        if (this.validaCampos()) {
            this.listaAlvarasEmitidos = this.consultar(this.filtro);
        }
    }

    private List<SolicitacaoAlvaraEntity> consultar(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarListaAlvarasEmitidos(filtro);
    }

    public void limpar() {
        this.filtro.setCpfCnpjResponsavel("");
        this.filtro.setCpfCnpjMobiliario("");
        this.filtro.setCadastroImobiliario("");
        this.filtro.setPeriodoInicial(null);
        this.filtro.setPeriodoFinal(null);
        this.filtro.setCodigoAtividade("");
        this.filtro.setAtividadeSelecionada(null);
        this.filtro.setCodigoEndereco("");
        this.filtro.setEndereco(null);
        this.filtro.setZona("");
        this.filtro.setQuadra("");
        this.filtro.setLote("");
        this.iniciarListaAlvarasEmitidos();
    }

    public void iniciarListaAlvarasEmitidos() {
        if (this.listaAlvarasEmitidos == null) {
            this.listaAlvarasEmitidos = new ArrayList();
        } else {
            this.listaAlvarasEmitidos.clear();
        }
    }

    public boolean validaCampos() {
        int quantidadeDias;
        if (!this.temFiltroPreenchido()) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Informe ao menos um filtro para minimizar o tempo da consulta.");
            return false;
        }
        boolean valido = true;
        if (this.filtro.getPeriodoInicial() == null && this.filtro.getPeriodoFinal() != null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe a data inicial.");
            valido = false;
        }
        if (this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() == null) {
            this.filtro.setPeriodoFinal(new Date());
        }
        if (this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() != null && (quantidadeDias = EloDateUtils.daysBetween((Date)this.filtro.getPeriodoInicial(), (Date)this.filtro.getPeriodoFinal())) < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final n\u00e3o pode ser anterior \u00e0 data inicial.");
            valido = false;
        }
        return valido;
    }

    public String recuperarTipoAtividade() {
        if (this.filtro.getTipoInscricao().getSigla().equals("N") || this.filtro.getTipoInscricao().getSigla().equals("P")) {
            return "CNAE";
        }
        if (this.filtro.getTipoInscricao().getSigla().equals("C")) {
            return "CBO";
        }
        if (this.filtro.getTipoInscricao().getSigla().equals("M") || this.filtro.getTipoInscricao().getSigla().equals("MP")) {
            return "MEI";
        }
        return "";
    }

    public List<Atividade> completeAtividade(String query) {
        ArrayList<Atividade> atividades = new ArrayList<Atividade>();
        if (this.filtro.getTipoInscricao() != null) {
            try {
                if (this.filtro.getTipoInscricao().getSigla().equals("C")) {
                    List cbos = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregaListaAtividadesCboPorDescricao(query);
                    atividades.addAll(cbos);
                } else if (this.filtro.getTipoInscricao().getSigla().equals("M") || this.filtro.getTipoInscricao().getSigla().equals("MP")) {
                    List listaMei = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaMeiPorDescricao(query, "N");
                    atividades.addAll(listaMei);
                } else if (this.filtro.getTipoInscricao().getSigla().equals("N") || this.filtro.getTipoInscricao().getSigla().equals("P")) {
                    List cnaes = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaCnaePorDescricao(query);
                    atividades.addAll(cnaes);
                }
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return atividades;
    }

    public List<LogradouroEntity> completeLogradouro(String query) {
        List enderecos = null;
        try {
            Long codigoCidade = ((EntidadeController)SpringContext.getBean(EntidadeController.class)).getEntidade().getLogradouro().getId().getCidade().getId();
            enderecos = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaLogradouroPorCidade(codigoCidade, query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    private boolean temFiltroPreenchido() {
        String juncao;
        boolean temFiltro = false;
        this.filtrosUsados = new StringBuilder("Filtros: ");
        String tipoAtividade = this.recuperarTipoAtividade();
        this.filtrosUsados.append(this.filtro.isConsultaPrevia() ? "Consulta Pr\u00e9via para" : "Solicita\u00e7\u00e3o para").append(" ");
        this.filtrosUsados.append("Tipo de Inscri\u00e7\u00e3o = ").append(this.filtro.getTipoInscricao().getDescricao()).append(" ");
        if (!EloStringUtils.isEmpty((String)this.filtro.getCpfCnpjResponsavel())) {
            temFiltro = true;
            this.filtrosUsados.append("CPF/CNPJ do Respons\u00e1vel = ").append(this.filtro.getCpfCnpjResponsavel()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCadastroMobiliario())) {
            temFiltro = true;
            this.filtrosUsados.append("Cadastro Mobili\u00e1rio = ").append(this.filtro.getCadastroMobiliario()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCpfCnpjMobiliario())) {
            temFiltro = true;
            this.filtrosUsados.append("CPF/CNPJ do Mobili\u00e1rio = ").append(this.filtro.getCpfCnpjMobiliario()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCadastroImobiliario())) {
            temFiltro = true;
            this.filtrosUsados.append("Cadastro Imobili\u00e1rio = ").append(this.filtro.getCadastroImobiliario()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getGrauRisco())) {
            temFiltro = true;
            this.filtrosUsados.append("Grau de Risco = ").append(this.filtro.getGrauRisco()).append(" ");
        }
        if (this.filtro.getPeriodoInicial() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getPeriodoFinal() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoAtividade()) || this.filtro.getAtividadeSelecionada() != null) {
            temFiltro = true;
            juncao = "";
            this.filtrosUsados.append(tipoAtividade + " = ");
            if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoAtividade())) {
                this.filtrosUsados.append(this.filtro.getCodigoAtividade());
                juncao = " - ";
            }
            if (this.filtro.getAtividadeSelecionada() != null) {
                this.filtrosUsados.append(juncao).append(this.filtro.getAtividadeSelecionada().getDescricao());
            }
            this.filtrosUsados.append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoEndereco()) || this.filtro.getEndereco() != null) {
            temFiltro = true;
            juncao = "";
            this.filtrosUsados.append("Endere\u00e7o = ");
            if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoEndereco())) {
                this.filtrosUsados.append(this.filtro.getCodigoEndereco());
                juncao = " - ";
            }
            if (this.filtro.getEndereco() != null) {
                this.filtrosUsados.append(juncao).append(this.filtro.getEndereco().getTipoDescricao());
            }
            this.filtrosUsados.append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getZona())) {
            temFiltro = true;
            this.filtrosUsados.append("Zona = ").append(this.filtro.getZona()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getQuadra())) {
            temFiltro = true;
            this.filtrosUsados.append("Quadra = ").append(this.filtro.getQuadra()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getLote())) {
            temFiltro = true;
            this.filtrosUsados.append("Lote = ").append(this.filtro.getLote()).append(" ");
        }
        if (this.filtro.getInicioDataExpedicao() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Data Expedi\u00e7\u00e3o In\u00edcio = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getInicioDataExpedicao(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getFimDataExpedicao() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Data Expedi\u00e7\u00e3o Fim = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getFimDataExpedicao(), (String)"dd/MM/yyyy")).append(" ");
        }
        return temFiltro;
    }

    public String formatCpfCnpj(String cpfCnpj) throws FormatError {
        if (EloStringUtils.isEmpty((String)cpfCnpj)) {
            return cpfCnpj;
        }
        return EloStringUtils.formatCpfCnpj((String)cpfCnpj);
    }

    public void inicializarOpcaoImpressao() {
        if (this.opcaoImpressao == null) {
            this.opcaoImpressao = new OpcaoImpressaoRelatorioVo();
        }
    }

    public void exibirRelatorio() {
        if (this.validarOpcoesImpressao()) {
            RequestContext context = RequestContext.getCurrentInstance();
            context.execute("dlgOpcaoImpressao.hide();");
            context.execute("dialogRelatorio.show();");
        } else {
            ShowMessage.addErrorMessage((String)"messageOpcaoImpressao", (String)"Marque as op\u00e7\u00f5es.");
        }
    }

    private boolean validarOpcoesImpressao() {
        for (Field campo : this.opcaoImpressao.getClass().getDeclaredFields()) {
            if (!campo.getType().equals(Boolean.TYPE) && !campo.getType().equals(Boolean.class)) continue;
            try {
                campo.setAccessible(true);
                Object valor = campo.get(this.opcaoImpressao);
                if (!valor.equals(Boolean.TRUE)) continue;
                return true;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

